/*
 * Decompiled with CFR 0.152.
 */
package org.drools.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.drools.model.Prototype;
import org.drools.model.PrototypeFact;

public class PrototypeImpl
implements Prototype {
    private final String pkg;
    private final String name;
    private final SortedMap<String, Prototype.Field> fields;
    private boolean event;

    public PrototypeImpl(String name) {
        this(name, new Prototype.Field[0]);
    }

    public PrototypeImpl(String name, String ... fields) {
        this(name, (Prototype.Field[])Stream.of(fields).map(FieldImpl::new).toArray(Prototype.Field[]::new));
    }

    public PrototypeImpl(String name, Prototype.Field ... fields) {
        int lastDot = name.lastIndexOf(46);
        this.pkg = lastDot > 0 ? name.substring(0, lastDot) : "defaultpkg";
        String string = this.name = lastDot > 0 ? name.substring(lastDot + 1) : name;
        if (fields != null && fields.length > 0) {
            this.fields = new TreeMap<String, Prototype.Field>();
            for (Prototype.Field field : fields) {
                this.fields.put(field.getName(), field);
            }
        } else {
            this.fields = Collections.emptySortedMap();
        }
    }

    @Override
    public String getPackage() {
        return this.pkg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<String> getFieldNames() {
        return this.fields.keySet();
    }

    @Override
    public Prototype.Field getField(String name) {
        return (Prototype.Field)this.fields.get(name);
    }

    @Override
    public int getFieldIndex(String name) {
        int i = 0;
        for (String field : this.fields.keySet()) {
            if (field.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrototypeImpl prototype = (PrototypeImpl)o;
        return this.pkg.equals(prototype.pkg) && this.name.equals(prototype.name) && this.fields.equals(prototype.fields);
    }

    public int hashCode() {
        return Objects.hash(this.pkg, this.name, this.fields);
    }

    @Override
    public boolean isEvent() {
        return this.event;
    }

    @Override
    public PrototypeImpl setAsEvent(boolean event) {
        this.event = event;
        return this;
    }

    public static class FieldImpl
    implements Prototype.Field {
        private final String name;
        private final Function<PrototypeFact, Object> extractor;
        private final boolean typed;
        private final Class<?> type;

        public FieldImpl(String name) {
            this(name, (PrototypeFact p) -> p.get(name));
        }

        public FieldImpl(String name, Function<PrototypeFact, Object> extractor) {
            this.name = name;
            this.extractor = extractor;
            this.type = Object.class;
            this.typed = false;
        }

        public FieldImpl(String name, Class<?> type) {
            this(name, type, p -> p.get(name));
        }

        public FieldImpl(String name, Class<?> type, Function<PrototypeFact, Object> extractor) {
            this.name = name;
            this.extractor = extractor;
            this.type = type;
            this.typed = true;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Function<PrototypeFact, Object> getExtractor() {
            return this.extractor;
        }

        @Override
        public boolean isTyped() {
            return this.typed;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }
    }
}

