/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.FailedPredicateException;
import org.antlr.runtime.MismatchedNotSetException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.MismatchedTreeNodeException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.DroolsParaphraseTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsParserExceptionFactory {
    public static final String MISMATCHED_TOKEN_MESSAGE_COMPLETE = "Line %1$d:%2$d mismatched input '%3$s' expecting '%4$s'%5$s";
    public static final String MISMATCHED_TOKEN_MESSAGE_PART = "Line %1$d:%2$d mismatched input '%3$s'%4$s";
    public static final String MISMATCHED_TREE_NODE_MESSAGE_COMPLETE = "Line %1$d:%2$d mismatched tree node '%3$s' expecting '%4$s'%5$s";
    public static final String MISMATCHED_TREE_NODE_MESSAGE_PART = "Line %1$d:%2$d mismatched tree node '%3$s'%4$s";
    public static final String NO_VIABLE_ALT_MESSAGE = "Line %1$d:%2$d no viable alternative at input '%3$s'%4$s";
    public static final String EARLY_EXIT_MESSAGE = "Line %1$d:%2$d required (...)+ loop did not match anything at input '%3$s'%4$s";
    public static final String MISMATCHED_SET_MESSAGE = "Line %1$d:%2$d mismatched input '%3$s' expecting one of the following tokens: '%4$s'%5$s.";
    public static final String MISMATCHED_NOT_SET_MESSAGE = "Line %1$d:%2$d mismatched input '%3$s' not expecting any of the following tokens: '%4$s'%5$s";
    public static final String FAILED_PREDICATE_MESSAGE = "Line %1$d:%2$d rule '%3$s' failed predicate: {%4$s}?%5$s";
    public static final String TRAILING_SEMI_COLON_NOT_ALLOWED_MESSAGE = "Line %1$d:%2$d trailing semi-colon not allowed%3$s";
    public static final String PARSER_LOCATION_MESSAGE_COMPLETE = " in %1$s %2$s";
    public static final String PARSER_LOCATION_MESSAGE_PART = " in %1$s";
    private String[] tokenNames = null;
    private Stack<Map<DroolsParaphraseTypes, String>> paraphrases = null;

    public DroolsParserExceptionFactory(String[] tokenNames, Stack<Map<DroolsParaphraseTypes, String>> paraphrases) {
        this.tokenNames = tokenNames;
        this.paraphrases = paraphrases;
    }

    public DroolsParserException createTrailingSemicolonException(int line, int column, int offset) {
        String message = String.format(TRAILING_SEMI_COLON_NOT_ALLOWED_MESSAGE, line, column, this.formatParserLocation());
        return new DroolsParserException("ERR 104", message, line, column, offset, null);
    }

    public DroolsParserException createDroolsException(RecognitionException e) {
        List<String> codeAndMessage = this.createErrorMessage(e);
        return new DroolsParserException(codeAndMessage.get(1), codeAndMessage.get(0), e.line, e.charPositionInLine, e.index, e);
    }

    private List<String> createErrorMessage(RecognitionException e) {
        ArrayList<String> codeAndMessage = new ArrayList<String>(2);
        String message = "";
        if (e instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)e;
            if (this.tokenNames != null && mte.expecting >= 0 && mte.expecting < this.tokenNames.length) {
                message = String.format(MISMATCHED_TOKEN_MESSAGE_COMPLETE, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.getBetterToken(mte.expecting), this.formatParserLocation());
                codeAndMessage.add(message);
                codeAndMessage.add("ERR 102");
            } else {
                message = String.format(MISMATCHED_TOKEN_MESSAGE_PART, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.formatParserLocation());
                codeAndMessage.add(message);
                codeAndMessage.add("ERR 102");
            }
        } else if (e instanceof MismatchedTreeNodeException) {
            MismatchedTreeNodeException mtne = (MismatchedTreeNodeException)e;
            if (mtne.expecting >= 0 && mtne.expecting < this.tokenNames.length) {
                message = String.format(MISMATCHED_TREE_NODE_MESSAGE_COMPLETE, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.getBetterToken(mtne.expecting), this.formatParserLocation());
                codeAndMessage.add(message);
                codeAndMessage.add("ERR 106");
            } else {
                message = String.format(MISMATCHED_TREE_NODE_MESSAGE_PART, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.formatParserLocation());
                codeAndMessage.add(message);
                codeAndMessage.add("ERR 106");
            }
        } else if (e instanceof NoViableAltException) {
            message = String.format(NO_VIABLE_ALT_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 101");
        } else if (e instanceof EarlyExitException) {
            message = String.format(EARLY_EXIT_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 105");
        } else if (e instanceof MismatchedSetException) {
            MismatchedSetException mse = (MismatchedSetException)e;
            String expected = this.expectedTokensAsString(mse.expecting);
            message = String.format(MISMATCHED_SET_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), expected, this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 107");
        } else if (e instanceof MismatchedNotSetException) {
            MismatchedNotSetException mse = (MismatchedNotSetException)e;
            String expected = this.expectedTokensAsString(mse.expecting);
            message = String.format(MISMATCHED_NOT_SET_MESSAGE, e.line, e.charPositionInLine, this.getBetterToken(e.token), expected, this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 108");
        } else if (e instanceof FailedPredicateException) {
            FailedPredicateException fpe = (FailedPredicateException)e;
            message = String.format(FAILED_PREDICATE_MESSAGE, e.line, e.charPositionInLine, fpe.ruleName, fpe.predicateText, this.formatParserLocation());
            codeAndMessage.add(message);
            codeAndMessage.add("ERR 103");
        }
        if (((String)codeAndMessage.get(0)).length() == 0) {
            codeAndMessage.add("?????");
        }
        return codeAndMessage;
    }

    private String expectedTokensAsString(BitSet set) {
        StringBuilder buf = new StringBuilder();
        buf.append("{ ");
        int i = 0;
        for (int token : set.toArray()) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getBetterToken(token));
            ++i;
        }
        buf.append(" }");
        String expected = buf.toString();
        return expected;
    }

    private String formatParserLocation() {
        StringBuilder sb = new StringBuilder();
        if (this.paraphrases != null) {
            for (Map map : this.paraphrases) {
                for (Map.Entry activeEntry : map.entrySet()) {
                    if (((String)activeEntry.getValue()).length() == 0) {
                        sb.append(String.format(PARSER_LOCATION_MESSAGE_PART, this.getLocationName((DroolsParaphraseTypes)((Object)activeEntry.getKey()))));
                        continue;
                    }
                    sb.append(String.format(PARSER_LOCATION_MESSAGE_COMPLETE, this.getLocationName((DroolsParaphraseTypes)((Object)activeEntry.getKey())), activeEntry.getValue()));
                }
            }
        }
        return sb.toString();
    }

    private String getLocationName(DroolsParaphraseTypes type) {
        switch (type) {
            case PACKAGE: {
                return "package";
            }
            case IMPORT: {
                return "import";
            }
            case FUNCTION_IMPORT: {
                return "function import";
            }
            case GLOBAL: {
                return "global";
            }
            case FUNCTION: {
                return "function";
            }
            case QUERY: {
                return "query";
            }
            case TEMPLATE: {
                return "template";
            }
            case RULE: {
                return "rule";
            }
            case RULE_ATTRIBUTE: {
                return "rule attribute";
            }
            case PATTERN: {
                return "pattern";
            }
        }
        return "";
    }

    private String getBetterToken(Token token) {
        if (token == null) {
            return "";
        }
        return this.getBetterToken(token.getType(), token.getText());
    }

    private String getBetterToken(int tokenType) {
        return this.getBetterToken(tokenType, null);
    }

    private String getBetterToken(int tokenType, String defaultValue) {
        switch (tokenType) {
            case 140: {
                return defaultValue == null ? "int" : defaultValue;
            }
            case 158: {
                return defaultValue == null ? "float" : defaultValue;
            }
            case 129: {
                return defaultValue == null ? "string" : defaultValue;
            }
            case 134: {
                return defaultValue == null ? "boolean" : defaultValue;
            }
            case 154: {
                return "null";
            }
            case 159: {
                return "then";
            }
            case 125: {
                return ";";
            }
            case 128: {
                return ".*";
            }
            case 130: {
                return ":";
            }
            case 146: {
                return "==";
            }
            case 151: {
                return "!=";
            }
            case 147: {
                return ">";
            }
            case 148: {
                return ">=";
            }
            case 149: {
                return "<";
            }
            case 150: {
                return "<=";
            }
            case 145: {
                return "->";
            }
            case 126: {
                return defaultValue == null ? "identifier" : defaultValue;
            }
            case 135: {
                return "(";
            }
            case 136: {
                return ")";
            }
            case 152: {
                return "[";
            }
            case 153: {
                return "]";
            }
            case 160: {
                return "{";
            }
            case 161: {
                return "}";
            }
            case 133: {
                return ",";
            }
            case 127: {
                return ".";
            }
            case 144: {
                return "&&";
            }
            case 143: {
                return "||";
            }
            case 199: {
                return defaultValue == null ? "misc" : defaultValue;
            }
            case -1: {
                return "<eof>";
            }
        }
        return tokenType > this.tokenNames.length ? "unknown" : this.tokenNames[tokenType];
    }
}

