/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.DRLParser;
import org.drools.lang.DroolsEditorType;
import org.drools.lang.DroolsParaphraseTypes;
import org.drools.lang.DroolsParserExceptionFactory;
import org.drools.lang.DroolsSentence;
import org.drools.lang.DroolsSentenceType;
import org.drools.lang.DroolsSoftKeywords;
import org.drools.lang.DroolsToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserHelper {
    public List<DroolsParserException> errors = new ArrayList<DroolsParserException>();
    public LinkedList<DroolsSentence> editorInterface = null;
    public boolean isEditorInterfaceEnabled = false;
    public boolean lookaheadTest = false;
    private Stack<Map<DroolsParaphraseTypes, String>> paraphrases = new Stack();
    private DRLParser parser = null;
    private DroolsParserExceptionFactory errorMessageFactory = null;
    private TokenStream input = null;
    private RecognizerSharedState state = null;

    public ParserHelper(DRLParser parser, String[] tokenNames, TokenStream input, RecognizerSharedState state) {
        this.parser = parser;
        this.errorMessageFactory = new DroolsParserExceptionFactory(tokenNames, this.paraphrases);
        this.input = input;
        this.state = state;
    }

    public LinkedList<DroolsSentence> getEditorInterface() {
        return this.editorInterface;
    }

    public void enableEditorInterface() {
        this.isEditorInterfaceEnabled = true;
    }

    public void disableEditorInterface() {
        this.isEditorInterfaceEnabled = false;
    }

    public void beginSentence(DroolsSentenceType sentenceType) {
        if (this.isEditorInterfaceEnabled) {
            if (null == this.editorInterface) {
                this.editorInterface = new LinkedList();
            }
            DroolsSentence sentence = new DroolsSentence();
            sentence.setType(sentenceType);
            this.editorInterface.add(sentence);
        }
    }

    public DroolsSentence getActiveSentence() {
        return this.editorInterface.getLast();
    }

    public void emit(List<?> tokens, DroolsEditorType editorType) {
        if (this.isEditorInterfaceEnabled && tokens != null) {
            for (Object activeObject : tokens) {
                this.emit((Token)activeObject, editorType);
            }
        }
    }

    public void emit(Token token, DroolsEditorType editorType) {
        if (this.isEditorInterfaceEnabled && token != null) {
            ((DroolsToken)token).setEditorType(editorType);
            this.getActiveSentence().addContent((DroolsToken)token);
        }
    }

    public void emit(boolean forceEmit, int activeContext) {
        if (this.isEditorInterfaceEnabled) {
            this.getActiveSentence().addContent(activeContext);
        }
    }

    public void emit(int activeContext) {
        if (this.isEditorInterfaceEnabled) {
            this.emit(false, activeContext);
        }
    }

    public DroolsToken getLastTokenOnList(LinkedList<?> list) {
        DroolsToken lastToken = null;
        for (Object object : list) {
            if (!(object instanceof DroolsToken)) continue;
            lastToken = (DroolsToken)((Object)object);
        }
        return lastToken;
    }

    public int getLastIntegerValue(LinkedList<?> list) {
        int lastIntergerValue = -1;
        for (Object object : list) {
            if (!(object instanceof Integer)) continue;
            lastIntergerValue = (Integer)object;
        }
        return lastIntergerValue;
    }

    public String retrieveLT(int LTNumber) {
        if (null == this.input) {
            return null;
        }
        if (null == this.input.LT(LTNumber)) {
            return null;
        }
        if (null == this.input.LT(LTNumber).getText()) {
            return null;
        }
        return this.input.LT(LTNumber).getText();
    }

    public boolean validateLT(int LTNumber, String text) {
        String text2Validate = this.retrieveLT(LTNumber);
        return text2Validate == null ? false : text2Validate.equalsIgnoreCase(text);
    }

    public boolean isPluggableEvaluator(int offset, boolean negated) {
        String text2Validate = this.retrieveLT(offset);
        return text2Validate == null ? false : DroolsSoftKeywords.isOperator(text2Validate, negated);
    }

    public boolean isPluggableEvaluator(boolean negated) {
        return this.isPluggableEvaluator(1, negated);
    }

    public boolean validateIdentifierKey(String text) {
        return this.validateLT(1, text);
    }

    public boolean validateSpecialID(int index) {
        return this.validateLT(index, "this") || this.validateLT(index, "super") || this.validateLT(index, "new") || this.validateLT(index, "class");
    }

    public boolean validateIdentifierSufix() {
        return this.validateLT(1, "[") || this.validateLT(1, "(") || this.validateLT(1, "<") || this.validateLT(1, ".") && this.validateSpecialID(2);
    }

    public void checkTrailingSemicolon(String text, Token token) {
        if (text.trim().endsWith(";")) {
            this.errors.add(this.errorMessageFactory.createTrailingSemicolonException(((DroolsToken)token).getLine(), ((DroolsToken)token).getCharPositionInLine(), ((DroolsToken)token).getStopIndex()));
        }
    }

    public boolean validateNotWithBinding() {
        return this.input.LA(1) == 126 && this.input.LA(2) == 126 && this.input.LA(3) == 130;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateRestr() {
        boolean returnValue;
        block9: {
            int lookahead = 2;
            int countParen = 1;
            while (this.input.LA(lookahead) != 133) {
                if (this.input.LA(lookahead) == 135) {
                    ++countParen;
                } else if (this.input.LA(lookahead) == 136) {
                    --countParen;
                } else if (this.input.LA(lookahead) == -1) break;
                if (countParen == 0) break;
                ++lookahead;
            }
            returnValue = false;
            int activeIndex = this.input.index();
            this.lookaheadTest = true;
            try {
                try {
                    this.input.seek(this.input.LT(2).getTokenIndex());
                    this.parser.constraint_expression();
                    returnValue = true;
                }
                catch (RecognitionException e) {
                    Object var7_6 = null;
                    this.input.seek(activeIndex);
                    break block9;
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.input.seek(activeIndex);
                throw throwable;
            }
            this.input.seek(activeIndex);
        }
        this.lookaheadTest = false;
        return returnValue;
    }

    public String safeSubstring(String text, int start, int end) {
        return text.substring(Math.min(start, text.length()), Math.min(Math.max(start, end), text.length()));
    }

    public void reportError(RecognitionException ex) {
        if (this.state.errorRecovery) {
            return;
        }
        this.state.errorRecovery = true;
        this.errors.add(this.errorMessageFactory.createDroolsException(ex));
    }

    public List<DroolsParserException> getErrors() {
        return this.errors;
    }

    public List<String> getErrorMessages() {
        ArrayList<String> messages = new ArrayList<String>(this.errors.size());
        for (DroolsParserException activeException : this.errors) {
            messages.add(activeException.getMessage());
        }
        return messages;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public void pushParaphrases(DroolsParaphraseTypes type) {
        HashMap<DroolsParaphraseTypes, String> activeMap = new HashMap<DroolsParaphraseTypes, String>();
        activeMap.put(type, "");
        this.paraphrases.push(activeMap);
    }

    public Map<DroolsParaphraseTypes, String> popParaphrases() {
        return this.paraphrases.pop();
    }

    public void setParaphrasesValue(DroolsParaphraseTypes type, String value) {
        this.paraphrases.peek().put(type, value);
    }

    public String buildStringFromTokens(List<Token> tokenList) {
        StringBuilder sb = new StringBuilder();
        if (null != tokenList) {
            for (Token activeToken : tokenList) {
                if (null == activeToken) continue;
                sb.append(activeToken.getText());
            }
        }
        return sb.toString();
    }

    public void emitErrorMessage(String msg) {
    }

    protected void syncToSet() {
        BitSet follow = this.state.following[this.state._fsp];
        this.syncToSet(follow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void syncToSet(BitSet follow) {
        int mark = -1;
        try {
            try {
                mark = this.input.mark();
                while (!this.memberOfFollowSet(follow)) {
                    if (this.input.LA(1) == -1) {
                        this.input.rewind();
                        return;
                    }
                    this.reportError((RecognitionException)new MismatchedSetException(follow, (IntStream)this.input));
                    this.input.consume();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var5_5 = null;
                if (mark == -1) return;
                this.input.release(mark);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (mark == -1) throw throwable;
            this.input.release(mark);
            throw throwable;
        }
        Object var5_4 = null;
        if (mark == -1) return;
        this.input.release(mark);
    }

    private boolean memberOfFollowSet(BitSet follow) {
        boolean isMember = follow.member(this.input.LA(1));
        if (this.input.LA(1) == 126) {
            String token = this.input.LT(1).getText();
            isMember = "import".equals(token) || "global".equals(token) || "function".equals(token) || "declare".equals(token) || "rule".equals(token) || "query".equals(token) || "salience".equals(token) || "no".equals(token) || "agenda".equals(token) || "timer".equals(token) || "activation".equals(token) || "auto".equals(token) || "date".equals(token) || "enabled".equals(token) || "ruleflow".equals(token) || "dialect".equals(token) || "calendars".equals(token);
        }
        return isMember;
    }
}

