/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DroolsErrorWrapper;
import org.drools.compiler.compiler.DroolsWarningWrapper;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.DescrDumper;
import org.drools.compiler.lang.DumperContext;
import org.drools.compiler.rule.builder.ConstraintBuilder;
import org.drools.compiler.rule.builder.EvaluatorDefinition;
import org.drools.compiler.rule.builder.EvaluatorWrapper;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.compiler.rule.builder.PredicateBuilder;
import org.drools.compiler.rule.builder.QueryElementBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.XpathAnalysis;
import org.drools.compiler.rule.builder.util.AnnotationFactory;
import org.drools.compiler.rule.builder.util.ConstraintUtil;
import org.drools.compiler.rule.builder.util.PatternBuilderUtil;
import org.drools.core.base.AcceptsClassObjectType;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.FieldNameSupplier;
import org.drools.core.base.ObjectType;
import org.drools.core.base.ValueType;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.QueryImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.facttemplates.FactTemplateFieldExtractor;
import org.drools.core.facttemplates.FactTemplateObjectType;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.PatternSource;
import org.drools.core.rule.PredicateConstraint;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.SlidingLengthWindow;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.XpathBackReference;
import org.drools.core.rule.accessor.AcceptsReadAccessor;
import org.drools.core.rule.accessor.DeclarationScopeResolver;
import org.drools.core.rule.accessor.Evaluator;
import org.drools.core.rule.accessor.FieldValue;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.rule.constraint.Constraint;
import org.drools.core.rule.constraint.NegConstraint;
import org.drools.core.rule.constraint.XpathConstraint;
import org.drools.core.time.TimeUtils;
import org.drools.core.util.index.IndexUtil;
import org.drools.drl.ast.descr.AnnotatedBaseDescr;
import org.drools.drl.ast.descr.AnnotationDescr;
import org.drools.drl.ast.descr.AtomicExprDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.BehaviorDescr;
import org.drools.drl.ast.descr.BindingDescr;
import org.drools.drl.ast.descr.ConnectiveType;
import org.drools.drl.ast.descr.ConstraintConnectiveDescr;
import org.drools.drl.ast.descr.DeclarativeInvokerDescr;
import org.drools.drl.ast.descr.EntryPointDescr;
import org.drools.drl.ast.descr.ExprConstraintDescr;
import org.drools.drl.ast.descr.ExpressionDescr;
import org.drools.drl.ast.descr.FromDescr;
import org.drools.drl.ast.descr.LiteralRestrictionDescr;
import org.drools.drl.ast.descr.MVELExprDescr;
import org.drools.drl.ast.descr.OperatorDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.PatternSourceDescr;
import org.drools.drl.ast.descr.PredicateDescr;
import org.drools.drl.ast.descr.RelationalExprDescr;
import org.drools.drl.ast.descr.ReturnValueRestrictionDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drl.parser.DrlExprParser;
import org.drools.drl.parser.DroolsParserException;
import org.drools.util.ClassUtils;
import org.drools.util.StringUtils;
import org.drools.util.TypeResolver;
import org.kie.api.definition.rule.Watch;
import org.kie.api.definition.type.Role;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternBuilder
implements RuleConditionBuilder<PatternDescr> {
    private static final Logger LOG = LoggerFactory.getLogger(PatternBuilder.class);
    private static final java.util.regex.Pattern evalRegexp = java.util.regex.Pattern.compile("^eval\\s*\\(", 8);
    private static final java.util.regex.Pattern identifierRegexp = java.util.regex.Pattern.compile("([\\p{L}_$][\\p{L}\\p{N}_$]*)");
    private static final java.util.regex.Pattern getterRegexp = java.util.regex.Pattern.compile("get([\\p{L}_][\\p{L}\\p{N}_]*)\\(\\s*\\)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleConditionElement build(RuleBuildContext context, PatternDescr descr) {
        boolean typeSafe = context.isTypesafe();
        try {
            RuleConditionElement ruleConditionElement = this.build(context, descr, (Pattern)null);
            return ruleConditionElement;
        }
        finally {
            context.setTypesafe(typeSafe);
        }
    }

    @Override
    public RuleConditionElement build(RuleBuildContext context, PatternDescr patternDescr, Pattern prefixPattern) {
        Declaration xpathStartDeclaration = null;
        if (patternDescr.getObjectType() == null) {
            xpathStartDeclaration = this.lookupObjectType(context, patternDescr);
        }
        if (patternDescr.getObjectType() == null || patternDescr.getObjectType().equals("")) {
            PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "ObjectType not correctly defined");
            return null;
        }
        ObjectType objectType = this.getObjectType(context, patternDescr);
        if (objectType == null) {
            return this.buildQuery(context, patternDescr, patternDescr);
        }
        Pattern pattern = this.buildPattern(context, patternDescr, xpathStartDeclaration, objectType);
        this.processClassObjectType(context, objectType, pattern);
        this.processAnnotations(context, patternDescr, pattern);
        this.processSource(context, patternDescr, pattern);
        this.processConstraintsAndBinds(context, patternDescr, xpathStartDeclaration, pattern);
        this.processBehaviors(context, patternDescr, pattern);
        if (!pattern.hasNegativeConstraint() && "on".equals(System.getProperty("drools.negatable"))) {
            pattern.addConstraint((Constraint)new NegConstraint(false));
        }
        context.getDeclarationResolver().popBuildStack();
        return pattern;
    }

    private Declaration lookupObjectType(RuleBuildContext context, PatternDescr patternDescr) {
        List descrs = patternDescr.getConstraint().getDescrs();
        if (descrs.size() != 1 || !(descrs.get(0) instanceof ExprConstraintDescr)) {
            return null;
        }
        ExprConstraintDescr descr = (ExprConstraintDescr)descrs.get(0);
        Object expr = descr.getExpression();
        if (((String)expr).charAt(0) != '/') {
            return null;
        }
        XpathAnalysis xpathAnalysis = XpathAnalysis.analyze((String)expr);
        if (xpathAnalysis.hasError()) {
            PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Invalid xpath expression '" + (String)expr + "': " + xpathAnalysis.getError());
            return null;
        }
        XpathAnalysis.XpathPart firstXpathChunk = xpathAnalysis.getPart(0);
        String identifier = firstXpathChunk.getField();
        DeclarationScopeResolver resolver = context.getDeclarationResolver();
        if (resolver.hasDataSource(identifier)) {
            patternDescr.setObjectType(this.findObjectType(context, firstXpathChunk, identifier));
            FromDescr fromDescr = new FromDescr();
            fromDescr.setDataSource((DeclarativeInvokerDescr)new MVELExprDescr(identifier));
            patternDescr.setSource((PatternSourceDescr)fromDescr);
            patternDescr.removeAllConstraint();
            firstXpathChunk.getConstraints().forEach(s -> patternDescr.addConstraint((BaseDescr)new ExprConstraintDescr(s)));
            if (!xpathAnalysis.isSinglePart()) {
                String xpathExpr = (String)(patternDescr.getIdentifier() == null ? "" : patternDescr.getIdentifier() + " : ") + ((String)expr).substring(xpathAnalysis.getPart(1).getStart());
                patternDescr.addConstraint((BaseDescr)new ExprConstraintDescr(xpathExpr));
                patternDescr.setIdentifier("$void$");
            }
        } else {
            Declaration declr = resolver.getDeclaration(identifier);
            if (declr == null) {
                PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "The identifier '" + identifier + "' is not in scope");
                return null;
            }
            patternDescr.setObjectType(declr.getExtractor().getExtractToClassName());
            expr = (String)(patternDescr.getIdentifier() != null ? patternDescr.getIdentifier() + (patternDescr.isUnification() ? " := " : " : ") : "") + ((String)expr).substring(identifier.length() + 1);
            descr.setExpression((String)expr);
            return declr;
        }
        return null;
    }

    private String findObjectType(RuleBuildContext context, XpathAnalysis.XpathPart firstXpathChunk, String identifier) {
        if (firstXpathChunk.getInlineCast() != null) {
            return firstXpathChunk.getInlineCast();
        }
        return context.getPkg().getRuleUnitDescriptionLoader().getDescription(context.getRule()).flatMap(ruDescr -> ruDescr.getDatasourceType(identifier)).map(Class::getCanonicalName).orElse(null);
    }

    private Pattern buildPattern(RuleBuildContext context, PatternDescr patternDescr, Declaration xpathStartDeclaration, ObjectType objectType) {
        Pattern pattern;
        boolean duplicateBindings;
        String patternIdentifier = patternDescr.getIdentifier();
        boolean bl = duplicateBindings = patternIdentifier != null && objectType instanceof ClassObjectType && context.getDeclarationResolver().isDuplicated(context.getRule(), patternIdentifier, objectType.getClassName());
        if (!StringUtils.isEmpty((CharSequence)patternIdentifier) && !duplicateBindings) {
            pattern = new Pattern(context.getNextPatternId(), 0, 0, objectType, patternIdentifier, this.isInternalFact(patternDescr, context));
            if (objectType instanceof ClassObjectType) {
                context.getPkg().wireObjectType(objectType, (AcceptsClassObjectType)pattern.getDeclaration().getExtractor());
            }
        } else {
            pattern = new Pattern(context.getNextPatternId(), 0, 0, objectType, null);
        }
        pattern.setPassive(this.isPassivePattern(patternDescr, context));
        context.getDeclarationResolver().pushOnBuildStack((RuleConditionElement)pattern);
        if (duplicateBindings) {
            this.processDuplicateBindings(patternDescr.isUnification(), patternDescr, xpathStartDeclaration, pattern, (BaseDescr)patternDescr, "this", patternDescr.getIdentifier(), context);
        }
        return pattern;
    }

    public boolean isInternalFact(PatternDescr patternDescr, RuleBuildContext context) {
        return patternDescr.getSource() != null && !(patternDescr.getSource() instanceof EntryPointDescr) && (!(patternDescr.getSource() instanceof FromDescr) || !context.getEntryPointId(((FromDescr)patternDescr.getSource()).getExpression()).isPresent());
    }

    private boolean isPassivePattern(PatternDescr patternDescr, RuleBuildContext context) {
        return patternDescr.isQuery() || patternDescr.getSource() instanceof FromDescr && !context.getEntryPointId(((FromDescr)patternDescr.getSource()).getDataSource().getText()).isPresent();
    }

    private void processClassObjectType(RuleBuildContext context, ObjectType objectType, Pattern pattern) {
        if (objectType instanceof ClassObjectType) {
            context.getPkg().wireObjectType(objectType, (AcceptsClassObjectType)pattern);
            Class cls = ((ClassObjectType)objectType).getClassType();
            if (cls.getPackage() != null && !cls.getPackage().getName().equals("java.lang")) {
                TypeDeclaration typeDeclr = context.getKnowledgeBuilder().getAndRegisterTypeDeclaration(cls, cls.getPackage().getName());
                context.setTypesafe(typeDeclr == null || typeDeclr.isTypesafe());
            } else {
                context.setTypesafe(true);
            }
        }
    }

    private ObjectType getObjectType(RuleBuildContext context, PatternDescr patternDescr) {
        return this.getObjectType(context, patternDescr, patternDescr.getObjectType());
    }

    private ObjectType getObjectType(RuleBuildContext context, PatternDescr patternDescr, String objectType) {
        FactTemplate factTemplate = context.getPkg().getFactTemplate(objectType);
        if (factTemplate != null) {
            return new FactTemplateObjectType(factTemplate);
        }
        try {
            Class userProvidedClass = context.getDialect().getTypeResolver().resolveType(objectType);
            if (!Modifier.isPublic(userProvidedClass.getModifiers())) {
                PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "The class '" + objectType + "' is not public");
                return null;
            }
            return new ClassObjectType(userProvidedClass, this.isEvent(context, userProvidedClass));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private boolean isEvent(RuleBuildContext context, Class<?> userProvidedClass) {
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(context, userProvidedClass);
        if (typeDeclaration != null) {
            return typeDeclaration.getRole() == Role.Type.EVENT;
        }
        Role role = userProvidedClass.getAnnotation(Role.class);
        return role != null && role.value() == Role.Type.EVENT;
    }

    private TypeDeclaration getTypeDeclaration(RuleBuildContext context, Class<?> userProvidedClass) {
        TypeDeclaration typeDeclaration;
        String packageName = ClassUtils.getPackage(userProvidedClass);
        TypeDeclarationContext kbuilder = context.getKnowledgeBuilder();
        PackageRegistry pkgr = kbuilder.getPackageRegistry(packageName);
        TypeDeclaration typeDeclaration2 = typeDeclaration = pkgr != null ? pkgr.getPackage().getTypeDeclaration(userProvidedClass) : null;
        if (typeDeclaration == null && kbuilder.getKnowledgeBase() != null) {
            InternalKnowledgePackage pkg = kbuilder.getKnowledgeBase().getPackage(packageName);
            TypeDeclaration typeDeclaration3 = typeDeclaration = pkg != null ? pkg.getTypeDeclaration(userProvidedClass) : null;
        }
        if (typeDeclaration == null) {
            typeDeclaration = context.getPkg().getTypeDeclaration(userProvidedClass);
        }
        return typeDeclaration;
    }

    private void processSource(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        if (patternDescr.getSource() != null) {
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(patternDescr.getSource().getClass());
            pattern.setSource((PatternSource)builder.build(context, patternDescr.getSource(), pattern));
        }
    }

    private void processBehaviors(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        for (BehaviorDescr behaviorDescr : patternDescr.getBehaviors()) {
            if (pattern.getObjectType().isEvent()) {
                Behavior window = this.createWindow(behaviorDescr);
                if (window != null) {
                    pattern.addBehavior(window);
                    context.setNeedStreamMode();
                    continue;
                }
                PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Unknown window type '" + behaviorDescr.getSubType() + "'");
                continue;
            }
            PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "A Sliding Window can only be assigned to types declared with @role( event ). The type '" + pattern.getObjectType() + "' in '" + context.getRule().getName() + "' is not declared as an Event.");
        }
    }

    private Behavior createWindow(BehaviorDescr behaviorDescr) {
        if (Behavior.BehaviorType.TIME_WINDOW.matches(behaviorDescr.getSubType())) {
            return new SlidingTimeWindow(TimeUtils.parseTimeString((String)((String)behaviorDescr.getParameters().get(0))));
        }
        if (Behavior.BehaviorType.LENGTH_WINDOW.matches(behaviorDescr.getSubType())) {
            return new SlidingLengthWindow(Integer.parseInt((String)behaviorDescr.getParameters().get(0)));
        }
        return null;
    }

    private RuleConditionElement buildQuery(RuleBuildContext context, PatternDescr descr, PatternDescr patternDescr) {
        RuleImpl rule;
        RuleConditionElement rce = null;
        if (context.getRule().getName().equals(patternDescr.getObjectType())) {
            rce = this.buildQueryElement(context, (BaseDescr)descr, (QueryImpl)context.getRule());
        }
        if (rce == null && (rule = context.getPkg().getRule(patternDescr.getObjectType())) instanceof QueryImpl) {
            rce = this.buildQueryElement(context, (BaseDescr)descr, (QueryImpl)rule);
        }
        if (rce == null) {
            for (String importName : context.getDialect().getTypeResolver().getImports()) {
                RuleImpl rule2;
                int pos = (importName = importName.trim()).indexOf(42);
                if (pos < 0) continue;
                String pkgName = importName.substring(0, pos - 1);
                PackageRegistry pkgReg = context.getKnowledgeBuilder().getPackageRegistry(pkgName);
                if (pkgReg == null || !((rule2 = pkgReg.getPackage().getRule(patternDescr.getObjectType())) instanceof QueryImpl)) continue;
                rce = this.buildQueryElement(context, (BaseDescr)descr, (QueryImpl)rule2);
                break;
            }
        }
        if (rce == null) {
            PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Unable to resolve ObjectType '" + patternDescr.getObjectType() + "'");
        }
        return rce;
    }

    private RuleConditionElement buildQueryElement(RuleBuildContext context, BaseDescr descr, QueryImpl rule) {
        if (context.getRule() != rule) {
            context.getRule().addUsedQuery(rule);
        }
        return QueryElementBuilder.getInstance().build(context, descr, rule);
    }

    private void processDuplicateBindings(boolean isUnification, PatternDescr patternDescr, Declaration xpathStartDeclaration, Pattern pattern, BaseDescr original, String leftExpression, String rightIdentifier, RuleBuildContext context) {
        if (isUnification) {
            this.build(context, patternDescr, xpathStartDeclaration, pattern, original, leftExpression + " == " + rightIdentifier);
        } else {
            PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Duplicate declaration for variable '" + rightIdentifier + "' in the rule '" + context.getRule().getName() + "'");
        }
    }

    protected void processAnnotations(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        this.processListenedPropertiesAnnotation(context, patternDescr, pattern);
        this.processMetadataAnnotations(patternDescr, pattern, context.getDialect().getTypeResolver());
    }

    protected void processMetadataAnnotations(PatternDescr patternDescr, Pattern pattern, TypeResolver typeResolver) {
        for (AnnotationDescr ann : patternDescr.getAnnotations()) {
            String annFQN = ann.getFullyQualifiedName();
            if (Watch.class.getCanonicalName().equals(annFQN)) continue;
            AnnotationDefinition def = this.buildAnnotationDef(ann, typeResolver);
            pattern.getAnnotations().put(annFQN, def);
        }
    }

    private AnnotationDefinition buildAnnotationDef(AnnotationDescr annotationDescr, TypeResolver resolver) {
        try {
            return AnnotationDefinition.build((Class)resolver.resolveType(annotationDescr.getFullyQualifiedName()), (Map)annotationDescr.getValueMap(), (TypeResolver)resolver);
        }
        catch (Exception e) {
            LOG.error("Exception", (Throwable)e);
            AnnotationDefinition annotationDefinition = new AnnotationDefinition(annotationDescr.getFullyQualifiedName());
            for (String propKey : annotationDescr.getValueMap().keySet()) {
                Object value = annotationDescr.getValue(propKey);
                if (value instanceof AnnotationDescr) {
                    value = this.buildAnnotationDef((AnnotationDescr)value, resolver);
                }
                annotationDefinition.getValues().put(propKey, new AnnotationDefinition.AnnotationPropertyVal(propKey, null, value, null));
            }
            return annotationDefinition;
        }
    }

    protected void processListenedPropertiesAnnotation(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        String watchedValues = null;
        try {
            Watch watch = AnnotationFactory.getTypedAnnotation((AnnotatedBaseDescr)patternDescr, Watch.class);
            watchedValues = watch == null ? null : watch.value();
        }
        catch (Exception e) {
            PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, e.getMessage());
        }
        if (watchedValues == null) {
            return;
        }
        Collection<String> settableProperties = this.getSettableProperties(context, patternDescr, pattern);
        ArrayList<Object> listenedProperties = new ArrayList<Object>();
        for (String propertyName : watchedValues.split(",")) {
            if ((propertyName = propertyName.trim()).equals("*") || propertyName.equals("!*")) {
                if (listenedProperties.contains("*") || listenedProperties.contains("!*")) {
                    PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Duplicate usage of wildcard * in @" + Watch.class.getSimpleName() + " annotation");
                    continue;
                }
                listenedProperties.add(propertyName);
                continue;
            }
            boolean isNegative = propertyName.startsWith("!");
            String string = propertyName = isNegative ? propertyName.substring(1).trim() : propertyName;
            if (settableProperties != null && !settableProperties.contains(propertyName)) {
                PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Unknown property " + propertyName + " in @" + Watch.class.getSimpleName() + " annotation");
                continue;
            }
            if (listenedProperties.contains(propertyName) || listenedProperties.contains("!" + propertyName)) {
                PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Duplicate property " + propertyName + " in @" + Watch.class.getSimpleName() + " annotation");
                continue;
            }
            listenedProperties.add(isNegative ? "!" + propertyName : propertyName);
        }
        pattern.addWatchedProperties(listenedProperties);
    }

    protected Collection<String> getSettableProperties(RuleBuildContext context, PatternDescr patternDescr, Pattern pattern) {
        ObjectType patternType = pattern.getObjectType();
        if (patternType.isTemplate()) {
            return ((FactTemplateObjectType)patternType).getFieldNames();
        }
        Class patternClass = ((ClassObjectType)patternType).getClassType();
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(pattern, context);
        if (!typeDeclaration.isPropertyReactive()) {
            PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Wrong usage of @" + Watch.class.getSimpleName() + " annotation on class " + patternClass.getName() + " that is not annotated as @PropertyReactive");
        }
        typeDeclaration.setTypeClass(patternClass);
        return typeDeclaration.getAccessibleProperties();
    }

    private void processConstraintsAndBinds(RuleBuildContext context, PatternDescr patternDescr, Declaration xpathStartDeclaration, Pattern pattern) {
        DumperContext mvelCtx = new DumperContext().setRuleContext(context);
        for (BaseDescr b : patternDescr.getDescrs()) {
            Object expression;
            boolean isPositional = false;
            if (b instanceof BindingDescr) {
                BindingDescr bind = (BindingDescr)b;
                expression = bind.getVariable() + (bind.isUnification() ? " := " : " : ") + bind.getExpression();
            } else if (b instanceof ExprConstraintDescr) {
                ExprConstraintDescr descr = (ExprConstraintDescr)b;
                expression = descr.getExpression();
                isPositional = descr.getType() == ExprConstraintDescr.Type.POSITIONAL;
            } else {
                expression = b.getText();
            }
            ConstraintConnectiveDescr result = this.parseExpression(context, patternDescr, b, (String)expression);
            if (result == null) {
                return;
            }
            result.setNegated(b.isNegated());
            if (isPositional &= result.getDescrs().size() != 1 || !(result.getDescrs().get(0) instanceof BindingDescr)) {
                this.processPositional(context, patternDescr, xpathStartDeclaration, pattern, (ExprConstraintDescr)b);
                continue;
            }
            List<Constraint> constraints = this.build(context, patternDescr, xpathStartDeclaration, pattern, result, mvelCtx);
            pattern.addConstraints(constraints);
        }
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(pattern, context);
        if (typeDeclaration != null && typeDeclaration.isPropertyReactive()) {
            for (String field : PatternBuilder.lookAheadFieldsOfIdentifier(context.getRuleDescr(), patternDescr)) {
                this.addFieldToPatternWatchlist(pattern, typeDeclaration, field);
            }
        }
    }

    public static Collection<String> lookAheadFieldsOfIdentifier(RuleDescr ruleDescr, PatternDescr patternDescr) {
        String identifier = patternDescr.getIdentifier();
        if (identifier == null) {
            return Collections.emptyList();
        }
        HashSet<String> props = new HashSet<String>();
        for (PatternDescr pattern : ruleDescr.getLhs().getAllPatternDescr()) {
            if (pattern == patternDescr || pattern == null) continue;
            for (BaseDescr expr : pattern.getDescrs()) {
                String text;
                int pos;
                if (!(expr instanceof ExprConstraintDescr) || (pos = (text = expr.getText()).indexOf(identifier + ".")) != 0 && (pos <= 0 || Character.isJavaIdentifierPart(text.charAt(pos - 1)))) continue;
                String prop = StringUtils.extractFirstIdentifier((String)text, (int)(pos + identifier.length() + 1));
                String propFromGetter = ClassUtils.getter2property((String)prop);
                props.add(propFromGetter != null ? propFromGetter : StringUtils.lcFirst((String)prop));
            }
            if (!PatternBuilder.isPassThroughPattern(pattern, identifier)) continue;
            props.addAll(PatternBuilder.collectProps(pattern));
        }
        return props;
    }

    private static boolean isPassThroughPattern(PatternDescr pattern, String identifier) {
        if (pattern.getSource() instanceof FromDescr) {
            FromDescr from = (FromDescr)pattern.getSource();
            String expr = from.getExpression().trim();
            return identifier.equals(expr);
        }
        return false;
    }

    private static Collection<String> collectProps(PatternDescr pattern) {
        HashSet<String> props = new HashSet<String>();
        for (BaseDescr expr : pattern.getDescrs()) {
            if (!(expr instanceof ExprConstraintDescr)) continue;
            String text = expr.getText();
            String prop = StringUtils.extractFirstIdentifier((String)text, (int)0);
            String propFromGetter = ClassUtils.getter2property((String)prop);
            props.add(propFromGetter != null ? propFromGetter : StringUtils.lcFirst((String)prop));
        }
        return props;
    }

    private void processPositional(RuleBuildContext context, PatternDescr patternDescr, Declaration xpathStartDeclaration, Pattern pattern, ExprConstraintDescr descr) {
        if (descr.getType() == ExprConstraintDescr.Type.POSITIONAL && pattern.getObjectType() instanceof ClassObjectType) {
            TypeDeclaration tDecl = context.getKnowledgeBuilder().getTypeDeclaration(pattern.getObjectType());
            if (tDecl == null) {
                PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Unable to find @positional definitions for :" + pattern.getObjectType() + "\n");
                return;
            }
            ClassDefinition clsDef = tDecl.getTypeClassDef();
            if (clsDef == null) {
                PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Unable to find @Positional field " + descr.getPosition() + " for class " + tDecl.getTypeName() + "\n");
                return;
            }
            FieldDefinition field = clsDef.getField(descr.getPosition());
            if (field == null) {
                PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Unable to find @Positional field " + descr.getPosition() + " for class " + tDecl.getTypeName() + "\n");
                return;
            }
            String expr = descr.getExpression();
            boolean isSimpleIdentifier = StringUtils.isIdentifier((String)expr);
            if (isSimpleIdentifier) {
                BindingDescr binder = new BindingDescr();
                binder.setUnification(true);
                binder.setExpression(field.getName());
                binder.setVariable(descr.getExpression());
                this.buildRuleBindings(context, patternDescr, xpathStartDeclaration, pattern, binder);
            } else {
                this.build(context, patternDescr, xpathStartDeclaration, pattern, (BaseDescr)descr, field.getName() + " == " + descr.getExpression());
            }
        }
    }

    private void build(RuleBuildContext context, PatternDescr patternDescr, Declaration xpathStartDeclaration, Pattern pattern, BaseDescr original, String expr) {
        ConstraintConnectiveDescr result = this.parseExpression(context, patternDescr, original, expr);
        if (result == null) {
            return;
        }
        result.copyLocation(original);
        DumperContext mvelCtx = new DumperContext().setRuleContext(context);
        List<Constraint> constraints = this.build(context, patternDescr, xpathStartDeclaration, pattern, result, mvelCtx);
        pattern.addConstraints(constraints);
    }

    private List<Constraint> build(RuleBuildContext context, PatternDescr patternDescr, Declaration xpathStartDeclaration, Pattern pattern, ConstraintConnectiveDescr descr, DumperContext mvelCtx) {
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        ArrayList initialDescrs = new ArrayList(descr.getDescrs());
        for (BaseDescr d : initialDescrs) {
            boolean isXPath = this.isXPathDescr(d);
            if (isXPath && pattern.hasXPath()) {
                PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "More than a single oopath constraint is not allowed in the same pattern");
                return constraints;
            }
            context.setXpathOffsetadjustment(xpathStartDeclaration == null ? 0 : -1);
            Constraint constraint = isXPath ? this.buildXPathDescr(context, patternDescr, xpathStartDeclaration, pattern, (ExpressionDescr)d, mvelCtx) : this.buildCcdDescr(context, patternDescr, xpathStartDeclaration, pattern, d, descr, mvelCtx);
            if (constraint == null) continue;
            Declaration declCorrXpath = this.getDeclarationCorrespondingToXpath(pattern, isXPath, constraint);
            if (declCorrXpath == null) {
                constraints.add(constraint);
                continue;
            }
            Pattern modifiedPattern = pattern.clone();
            modifiedPattern.setObjectType((ObjectType)new ClassObjectType(declCorrXpath.getDeclarationClass()));
            constraint = this.buildCcdDescr(context, patternDescr, xpathStartDeclaration, modifiedPattern, d.replaceVariable(declCorrXpath.getBindingName(), "this"), descr, mvelCtx);
            if (constraint == null) continue;
            ((XpathConstraint.XpathChunk)pattern.getXpathConstraint().getChunks().getLast()).addConstraint(constraint);
        }
        if (descr.getDescrs().size() > initialDescrs.size()) {
            ArrayList additionalDescrs = new ArrayList(descr.getDescrs());
            additionalDescrs.removeAll(initialDescrs);
            if (!additionalDescrs.isEmpty()) {
                ArrayList<Constraint> additionalConstraints = new ArrayList<Constraint>();
                for (BaseDescr d : additionalDescrs) {
                    Constraint constraint = this.buildCcdDescr(context, patternDescr, xpathStartDeclaration, pattern, d, descr, mvelCtx);
                    if (constraint == null) continue;
                    additionalConstraints.add(constraint);
                }
                constraints.addAll(0, additionalConstraints);
            }
        }
        return constraints;
    }

    private Declaration getDeclarationCorrespondingToXpath(Pattern pattern, boolean isXPath, Constraint constraint) {
        Declaration xPathDecl;
        if (!isXPath && pattern.hasXPath() && (xPathDecl = pattern.getXPathDeclaration()) != null) {
            for (Declaration decl : constraint.getRequiredDeclarations()) {
                if (!xPathDecl.equals((Object)decl)) continue;
                return decl;
            }
        }
        return null;
    }

    private boolean isXPathDescr(BaseDescr descr) {
        return descr instanceof ExpressionDescr && (((ExpressionDescr)descr).getExpression().startsWith("/") || ((ExpressionDescr)descr).getExpression().startsWith("?/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constraint buildXPathDescr(RuleBuildContext context, PatternDescr patternDescr, Declaration xpathStartDeclaration, Pattern pattern, ExpressionDescr descr, DumperContext mvelCtx) {
        ObjectType originalType;
        String expression = descr.getExpression();
        XpathAnalysis xpathAnalysis = XpathAnalysis.analyze(expression);
        if (xpathAnalysis.hasError()) {
            PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Invalid xpath expression '" + expression + "': " + xpathAnalysis.getError());
            return null;
        }
        XpathConstraint xpathConstraint = new XpathConstraint();
        ObjectType objectType = pattern.getObjectType();
        if (objectType.isTemplate()) {
            throw new UnsupportedOperationException("xpath is not supported with fact templates");
        }
        Class patternClass = ((ClassObjectType)objectType).getClassType();
        ArrayList<Class> backReferenceClasses = new ArrayList<Class>();
        backReferenceClasses.add(patternClass);
        XpathBackReference backRef = new XpathBackReference(pattern, backReferenceClasses);
        pattern.setBackRefDeclarations(backRef);
        ObjectType currentObjectType = originalType = pattern.getObjectType();
        mvelCtx.setInXpath(true);
        try {
            for (XpathAnalysis.XpathPart part : xpathAnalysis) {
                XpathConstraint.XpathChunk xpathChunk = xpathConstraint.addChunck(patternClass, part.getField(), part.getIndex(), part.isIterate(), part.isLazy());
                context.getPkg().wireObjectType(currentObjectType, (AcceptsClassObjectType)xpathChunk);
                if (xpathChunk == null) {
                    PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Invalid xpath expression '" + expression + "': cannot access " + part.getField() + " on " + patternClass);
                    pattern.setObjectType(originalType);
                    Iterator<String> iterator = null;
                    return iterator;
                }
                if (part.getInlineCast() != null) {
                    try {
                        patternClass = context.getDialect().getTypeResolver().resolveType(part.getInlineCast());
                    }
                    catch (ClassNotFoundException e) {
                        PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Unknown class " + part.getInlineCast() + " in xpath expression '" + expression + "'");
                        Constraint constraint = null;
                        mvelCtx.setInXpath(false);
                        pattern.setBackRefDeclarations(null);
                        pattern.setObjectType(originalType);
                        context.resetXpathChuckNr();
                        return constraint;
                    }
                    part.addInlineCastConstraint(patternClass);
                    currentObjectType = this.getObjectType(context, patternDescr, patternClass.getName());
                    xpathChunk.setReturnedType(currentObjectType);
                } else {
                    patternClass = xpathChunk.getReturnedClass();
                    currentObjectType = this.getObjectType(context, patternDescr, patternClass.getName());
                }
                context.increaseXpathChuckNr();
                pattern.setObjectType(currentObjectType);
                backReferenceClasses.add(0, patternClass);
                backRef.reset();
                for (String constraint : part.getConstraints()) {
                    ConstraintConnectiveDescr result = this.parseExpression(context, patternDescr, (BaseDescr)new ExprConstraintDescr(constraint), constraint);
                    if (result == null) continue;
                    int chunkNbr = context.getXpathChuckNr();
                    for (Constraint c : this.build(context, patternDescr, xpathStartDeclaration, pattern, result, mvelCtx)) {
                        xpathChunk.addConstraint(c);
                    }
                    context.setXpathChuckNr(chunkNbr);
                }
            }
            xpathConstraint.setXpathStartDeclaration(xpathStartDeclaration);
            if (descr instanceof BindingDescr) {
                Declaration pathDeclr = pattern.addDeclaration(((BindingDescr)descr).getVariable());
                pathDeclr.setxPathOffset(context.getXpathChuckNr());
                xpathConstraint.setDeclaration(pathDeclr);
            }
        }
        finally {
            mvelCtx.setInXpath(false);
            pattern.setBackRefDeclarations(null);
            pattern.setObjectType(originalType);
            context.resetXpathChuckNr();
        }
        return xpathConstraint;
    }

    private Constraint buildCcdDescr(RuleBuildContext context, PatternDescr patternDescr, Declaration xpathStartDeclaration, Pattern pattern, BaseDescr d, ConstraintConnectiveDescr ccd, DumperContext mvelCtx) {
        d.copyLocation((BaseDescr)patternDescr);
        mvelCtx.clear();
        String expr = DescrDumper.getInstance().dump(d, ccd, mvelCtx);
        Map<String, OperatorDescr> aliases = mvelCtx.getAliases();
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(pattern, context);
        for (BindingDescr bind : mvelCtx.getBindings()) {
            this.buildRuleBindings(context, patternDescr, xpathStartDeclaration, pattern, bind, typeDeclaration);
        }
        if (expr.length() == 0) {
            return null;
        }
        Constraint constraint = this.processAtomicExpression(context, pattern, d, expr, aliases);
        return constraint != null ? constraint : this.buildExpression(context, pattern, d, expr, aliases, ccd.isNegated());
    }

    private Constraint buildExpression(RuleBuildContext context, Pattern pattern, BaseDescr d, String expr, Map<String, OperatorDescr> aliases, boolean negated) {
        if ("_.neg".equals(expr)) {
            pattern.setHasNegativeConstraint(true);
            return new NegConstraint();
        }
        if ("!_.neg".equals(expr)) {
            pattern.setHasNegativeConstraint(true);
            return new NegConstraint(false);
        }
        RelationalExprDescr relDescr = d instanceof RelationalExprDescr ? (RelationalExprDescr)d : null;
        boolean simple = this.isSimpleExpr(relDescr);
        if (simple && !ClassObjectType.Map_ObjectType.isAssignableFrom(pattern.getObjectType()) && !ClassObjectType.Match_ObjectType.isAssignableFrom(pattern.getObjectType())) {
            String normalizedExpr = this.normalizeExpression(context, pattern, relDescr, expr);
            if (negated) {
                normalizedExpr = this.normalizeNegatedExpr(normalizedExpr, relDescr.getOperator());
                relDescr.getOperatorDescr().setNegated(!relDescr.getOperatorDescr().isNegated());
            }
            return this.buildRelationalExpression(context, pattern, relDescr, normalizedExpr, aliases);
        }
        Object rewrittenExpr = this.rewriteOrExpressions(context, pattern, d, expr);
        if (simple) {
            rewrittenExpr = ConstraintUtil.inverseExpression(relDescr, expr, this.findLeftExpressionValue(relDescr), this.findRightExpressionValue(relDescr), relDescr.getOperator(), pattern);
        }
        if (negated) {
            rewrittenExpr = "!(" + (String)rewrittenExpr + ")";
        }
        return this.createAndBuildPredicate(context, pattern, d, (String)rewrittenExpr, aliases);
    }

    private String normalizeNegatedExpr(String expr, String operator) {
        IndexUtil.ConstraintType constraintType = IndexUtil.ConstraintType.decode((String)operator);
        return constraintType.getOperator() != null ? expr.replace(constraintType.getOperator(), constraintType.negate().getOperator()) : "!(" + expr + ")";
    }

    private String rewriteOrExpressions(RuleBuildContext context, Pattern pattern, BaseDescr d, String expr) {
        String rewrittenExpr;
        if (d instanceof ConstraintConnectiveDescr && ((ConstraintConnectiveDescr)d).getConnective() == ConnectiveType.OR && (rewrittenExpr = this.rewriteCompositeExpressions(context, pattern, (ConstraintConnectiveDescr)d)) != null) {
            return rewrittenExpr;
        }
        return expr;
    }

    private String rewriteCompositeExpressions(RuleBuildContext context, Pattern pattern, ConstraintConnectiveDescr d) {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        for (BaseDescr subDescr : d.getDescrs()) {
            Object normalizedExpr;
            if (subDescr instanceof BindingDescr) continue;
            if (i++ > 0) {
                sb.append(" ").append(d.getConnective().getConnective()).append(" ");
            }
            if (subDescr instanceof RelationalExprDescr && this.isSimpleExpr((RelationalExprDescr)subDescr)) {
                RelationalExprDescr relDescr = (RelationalExprDescr)subDescr;
                if (relDescr.getExpression() != null) {
                    normalizedExpr = this.normalizeExpression(context, pattern, relDescr, relDescr.getExpression());
                } else {
                    --i;
                    normalizedExpr = "";
                }
            } else if (subDescr instanceof ConstraintConnectiveDescr) {
                String rewrittenExpr = this.rewriteCompositeExpressions(context, pattern, (ConstraintConnectiveDescr)subDescr);
                if (rewrittenExpr == null) {
                    return null;
                }
                normalizedExpr = "(" + rewrittenExpr + ")";
            } else if (subDescr instanceof AtomicExprDescr) {
                normalizedExpr = ((AtomicExprDescr)subDescr).getRewrittenExpression();
            } else {
                return null;
            }
            sb.append((String)normalizedExpr);
        }
        return sb.toString();
    }

    private String normalizeExpression(RuleBuildContext context, Pattern pattern, RelationalExprDescr subDescr, String subExpr) {
        String leftValue = this.findLeftExpressionValue(subDescr);
        String rightValue = this.findRightExpressionValue(subDescr);
        String operator = subDescr.getOperator();
        subExpr = ConstraintUtil.inverseExpression(subDescr, subExpr, leftValue, rightValue, operator, pattern);
        ValueType valueType = this.getValueType(context, pattern, leftValue);
        if (valueType != null && valueType.isDate()) {
            FieldValue fieldValue = ConstraintBuilder.get().getMvelFieldValue(context, valueType, rightValue);
            if (fieldValue != null) {
                subExpr = subExpr.replace(rightValue, PatternBuilderUtil.getNormalizeDate(valueType, fieldValue));
            }
            return subExpr;
        }
        if (operator.equals("str")) {
            return PatternBuilderUtil.normalizeStringOperator(leftValue, rightValue, new LiteralRestrictionDescr(operator, subDescr.isNegated(), subDescr.getParameters(), rightValue, 3));
        }
        return PatternBuilderUtil.normalizeEmptyKeyword(subExpr, operator);
    }

    private ValueType getValueType(RuleBuildContext context, Pattern pattern, String leftValue) {
        Declaration declaration = (Declaration)pattern.getDeclarations().get(leftValue);
        if (declaration != null && declaration.getExtractor() != null) {
            return declaration.getValueType();
        }
        ObjectType objectType = pattern.getObjectType();
        if (objectType.isTemplate()) {
            return ((FactTemplateObjectType)objectType).getFactTemplate().getFieldTemplate(leftValue).getValueType();
        }
        Class clazz = ((ClassObjectType)objectType).getClassType();
        Class fieldType = context.getPkg().getFieldType(clazz, leftValue);
        return fieldType != null ? ValueType.determineValueType((Class)fieldType) : null;
    }

    protected Constraint buildRelationalExpression(RuleBuildContext context, Pattern pattern, RelationalExprDescr relDescr, String expr, Map<String, OperatorDescr> aliases) {
        String[] values = new String[2];
        boolean usesThisRef = this.findExpressionValues(relDescr, values);
        ExprBindings value1Expr = this.getExprBindings(context, pattern, values[0]);
        ExprBindings value2Expr = this.getExprBindings(context, pattern, values[1]);
        if (!usesThisRef && value1Expr.isConstant()) {
            return this.createAndBuildPredicate(context, pattern, (BaseDescr)relDescr, expr, aliases);
        }
        Constraint constraint = this.buildConstraintForPattern(context, pattern, relDescr, expr, values[0], values[1], value2Expr.isConstant(), aliases);
        return constraint != null ? constraint : this.createAndBuildPredicate(context, pattern, (BaseDescr)relDescr, expr, aliases);
    }

    private ExprBindings getExprBindings(RuleBuildContext context, Pattern pattern, String value) {
        String identifier;
        ExprBindings valueExpr = new ExprBindings();
        ConstraintBuilder.get().setExprInputs(context, valueExpr, pattern.getObjectType() instanceof ClassObjectType ? ((ClassObjectType)pattern.getObjectType()).getClassType() : FactTemplate.class, value);
        if (!this.isIdentifierLiteral(value) && (identifier = StringUtils.extractFirstIdentifier((String)value, (int)0)).length() > 0) {
            valueExpr.setWithJavaIdentifier(true);
        }
        return valueExpr;
    }

    private boolean isIdentifierLiteral(String expr) {
        return expr.equals("true") || expr.equals("false") || expr.equals("null") || expr.endsWith(".class");
    }

    private boolean findExpressionValues(RelationalExprDescr relDescr, String[] values) {
        values[0] = this.findLeftExpressionValue(relDescr);
        values[1] = this.findRightExpressionValue(relDescr);
        return "this".equals(values[1]) || values[1].startsWith("this.") || values[1].contains(")this).") || "this".equals(values[0]) || values[0].startsWith("this.") || values[0].contains(")this).");
    }

    private String findLeftExpressionValue(RelationalExprDescr relDescr) {
        return relDescr.getLeft() instanceof AtomicExprDescr ? ((AtomicExprDescr)relDescr.getLeft()).getRewrittenExpression() : ((BindingDescr)relDescr.getLeft()).getExpression();
    }

    private String findRightExpressionValue(RelationalExprDescr relDescr) {
        return relDescr.getRight() instanceof AtomicExprDescr ? ((AtomicExprDescr)relDescr.getRight()).getRewrittenExpression().trim() : ((BindingDescr)relDescr.getRight()).getExpression().trim();
    }

    protected Constraint buildConstraintForPattern(RuleBuildContext context, Pattern pattern, RelationalExprDescr relDescr, String expr, String value1, String value2, boolean isConstant, Map<String, OperatorDescr> aliases) {
        String[] parts;
        LiteralRestrictionDescr restrictionDescr;
        ReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, (BaseDescr)relDescr, pattern, value1, null, true);
        if (extractor == null) {
            return null;
        }
        if ("contains".equals(relDescr.getOperator()) && !this.isTypeCompatibleWithContainsOperator(extractor.getExtractToClass())) {
            PatternBuilder.registerDescrBuildError(context, (BaseDescr)relDescr, "Cannot use contains on " + extractor.getExtractToClass() + " in expression '" + expr + "'");
            return null;
        }
        int dotPos = value1.indexOf(46);
        if (dotPos > 0) {
            String part0 = value1.substring(0, dotPos).trim();
            if ("this".equals(part0.trim())) {
                value1 = value1.substring(dotPos + 1);
            } else if (pattern.getDeclaration() != null && part0.equals(pattern.getDeclaration().getIdentifier())) {
                value1 = value1.substring(dotPos + 1);
                expr = expr.substring(dotPos + 1);
            }
        }
        if ((restrictionDescr = this.buildLiteralRestrictionDescr(context, relDescr, value2, isConstant)) != null) {
            Constraint constraint;
            ValueType vtype = extractor.getValueType();
            FieldValue field = ConstraintBuilder.get().getMvelFieldValue(context, vtype, restrictionDescr.getText().trim());
            if (field != null && (constraint = PatternBuilder.getConstraintBuilder().buildLiteralConstraint(context, pattern, vtype, field, expr, value1, relDescr.getOperator(), relDescr.isNegated(), value2, extractor, restrictionDescr, aliases)) != null) {
                return constraint;
            }
        }
        value2 = context.getDeclarationResolver().normalizeValueForUnit(value2);
        Declaration declr = null;
        if (value2.indexOf(40) < 0 && value2.indexOf(46) < 0 && value2.indexOf(91) < 0 && (declr = context.getDeclarationResolver().getDeclaration(value2)) == null) {
            Pattern thisPattern = (Pattern)context.getDeclarationResolver().peekBuildStack();
            declr = PatternBuilder.createDeclarationObject(context, value2, thisPattern);
        }
        Declaration[] declarations = null;
        if (declr == null && (parts = value2.split("\\.")).length == 2) {
            if ("this".equals(parts[0].trim())) {
                declr = PatternBuilder.createDeclarationObject(context, parts[1].trim(), (Pattern)context.getDeclarationResolver().peekBuildStack());
                value2 = parts[1].trim();
            } else {
                declr = context.getDeclarationResolver().getDeclaration(parts[0].trim());
                if (declr != null) {
                    if (declr.isPatternDeclaration()) {
                        declarations = new Declaration[]{declr};
                        declr = PatternBuilder.createDeclarationObject(context, parts[1].trim(), declr.getPattern());
                        value2 = parts[1].trim();
                    } else {
                        return null;
                    }
                }
            }
        }
        if (declarations == null) {
            if (declr != null) {
                declarations = new Declaration[]{declr};
            } else {
                declarations = this.getDeclarationsForReturnValue(context, relDescr, value2);
                if (declarations == null) {
                    return null;
                }
            }
        }
        return PatternBuilder.getConstraintBuilder().buildVariableConstraint(context, pattern, expr, declarations, value1, relDescr.getOperatorDescr(), value2, extractor, declr, relDescr, aliases);
    }

    private boolean isTypeCompatibleWithContainsOperator(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || type.isArray() || type == String.class;
    }

    private Declaration[] getDeclarationsForReturnValue(RuleBuildContext context, RelationalExprDescr relDescr, String value2) {
        Pattern pattern = (Pattern)context.getDeclarationResolver().peekBuildStack();
        ReturnValueRestrictionDescr returnValueRestrictionDescr = new ReturnValueRestrictionDescr(relDescr.getOperator(), relDescr, (Object)value2);
        AnalysisResult analysis = context.getDialect().analyzeExpression(context, (BaseDescr)returnValueRestrictionDescr, returnValueRestrictionDescr.getContent(), new BoundIdentifiers(pattern, (PackageBuildContext)context, null, pattern.getObjectType()));
        if (analysis == null) {
            return null;
        }
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            Declaration decl = context.getDeclarationResolver().getDeclaration(id);
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        PatternBuilder.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), usedIdentifiers, factDeclarations);
        Declaration[] previousDeclarations = tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]);
        Declaration[] localDeclarations = factDeclarations.toArray(new Declaration[factDeclarations.size()]);
        Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
        Arrays.sort(localDeclarations, RuleTerminalNode.SortDeclarations.instance);
        String[] requiredGlobals = usedIdentifiers.getGlobals().keySet().toArray(new String[usedIdentifiers.getGlobals().size()]);
        Declaration[] requiredDeclarations = new Declaration[previousDeclarations.length + localDeclarations.length];
        System.arraycopy(previousDeclarations, 0, requiredDeclarations, 0, previousDeclarations.length);
        System.arraycopy(localDeclarations, 0, requiredDeclarations, previousDeclarations.length, localDeclarations.length);
        Declaration[] declarations = new Declaration[requiredDeclarations.length + requiredGlobals.length];
        int i = 0;
        for (Declaration declaration : requiredDeclarations) {
            declarations[i++] = declaration;
        }
        for (String string : requiredGlobals) {
            declarations[i++] = context.getDeclarationResolver().getDeclaration(string);
        }
        return declarations;
    }

    protected LiteralRestrictionDescr buildLiteralRestrictionDescr(RuleBuildContext context, RelationalExprDescr exprDescr, String rightValue, boolean isRightLiteral) {
        if (isRightLiteral) {
            return new LiteralRestrictionDescr(exprDescr.getOperator(), exprDescr.isNegated(), exprDescr.getParameters(), rightValue, 3);
        }
        int dotPos = rightValue.lastIndexOf(46);
        if (dotPos >= 0) {
            String mainPart = rightValue.substring(0, dotPos);
            String lastPart = rightValue.substring(dotPos + 1);
            try {
                Field field;
                Class clazz = context.getDialect().getTypeResolver().resolveType(mainPart);
                if (lastPart.indexOf(40) < 0 && lastPart.indexOf(46) < 0 && lastPart.indexOf(91) < 0 && (field = ClassUtils.getField((Class)clazz, (String)lastPart)) != null && (field.isEnumConstant() || Modifier.isFinal(field.getModifiers()))) {
                    return new LiteralRestrictionDescr(exprDescr.getOperator(), exprDescr.isNegated(), exprDescr.getParameters(), rightValue, 3);
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected Constraint processAtomicExpression(RuleBuildContext context, Pattern pattern, BaseDescr d, String expr, Map<String, OperatorDescr> aliases) {
        Matcher m;
        if (d instanceof AtomicExprDescr && (m = evalRegexp.matcher(((AtomicExprDescr)d).getExpression())).find()) {
            PredicateDescr pdescr = new PredicateDescr(context.getRuleDescr().getResource(), (Object)expr);
            pdescr.copyLocation(d);
            return this.buildEval(context, pattern, pdescr, aliases, expr, true);
        }
        return null;
    }

    protected boolean isSimpleExpr(RelationalExprDescr relDescr) {
        boolean simple = false;
        if (relDescr != null && (relDescr.getLeft() instanceof AtomicExprDescr || relDescr.getLeft() instanceof BindingDescr) && (relDescr.getRight() instanceof AtomicExprDescr || relDescr.getRight() instanceof BindingDescr)) {
            simple = true;
        }
        return simple;
    }

    protected Constraint createAndBuildPredicate(RuleBuildContext context, Pattern pattern, BaseDescr base, String expr, Map<String, OperatorDescr> aliases) {
        Dialect dialect = context.getDialect();
        context.setDialect(context.getDialect("mvel"));
        PredicateDescr pdescr = new PredicateDescr(context.getRuleDescr().getResource(), (Object)expr);
        pdescr.copyParameters(base);
        pdescr.copyLocation(base);
        Constraint evalConstraint = this.buildEval(context, pattern, pdescr, aliases, expr, false);
        context.setDialect(dialect);
        return evalConstraint;
    }

    protected void buildRuleBindings(RuleBuildContext context, PatternDescr patternDescr, Declaration xpathStartDeclaration, Pattern pattern, BindingDescr fieldBindingDescr) {
        this.buildRuleBindings(context, patternDescr, xpathStartDeclaration, pattern, fieldBindingDescr, this.getTypeDeclaration(pattern, context));
    }

    protected void buildRuleBindings(RuleBuildContext context, PatternDescr patternDescr, Declaration xpathStartDeclaration, Pattern pattern, BindingDescr fieldBindingDescr, TypeDeclaration typeDeclaration) {
        ReadAccessor extractor;
        if (context.getDeclarationResolver().isDuplicated(context.getRule(), fieldBindingDescr.getVariable(), null)) {
            this.processDuplicateBindings(fieldBindingDescr.isUnification(), patternDescr, xpathStartDeclaration, pattern, (BaseDescr)fieldBindingDescr, fieldBindingDescr.getBindingField(), fieldBindingDescr.getVariable(), context);
            if (fieldBindingDescr.isUnification()) {
                return;
            }
        }
        Declaration declr = pattern.addDeclaration(fieldBindingDescr.getVariable());
        if (context.isInXpath()) {
            declr.setxPathOffset(context.getXpathChuckNr());
        }
        if ((extractor = PatternBuilder.getFieldReadAccessor(context, (BaseDescr)fieldBindingDescr, pattern, fieldBindingDescr.getBindingField(), (AcceptsReadAccessor)declr, true)) == null) {
            PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Field Reader does not exist for declaration '" + fieldBindingDescr.getVariable() + "' in '" + fieldBindingDescr + "' in the rule '" + context.getRule().getName() + "'");
            return;
        }
        declr.setReadAccessor(extractor);
        if (!declr.isFromXpathChunk() && typeDeclaration != null && extractor instanceof FieldNameSupplier) {
            this.addFieldToPatternWatchlist(pattern, typeDeclaration, ((FieldNameSupplier)extractor).getFieldName());
        }
    }

    private void addFieldToPatternWatchlist(Pattern pattern, TypeDeclaration typeDeclaration, String fieldName) {
        if (typeDeclaration.getAccessibleProperties().contains(fieldName)) {
            pattern.addBoundProperty(fieldName);
        }
    }

    private TypeDeclaration getTypeDeclaration(Pattern pattern, RuleBuildContext context) {
        return context.getKnowledgeBuilder().getTypeDeclaration(pattern.getObjectType());
    }

    protected Constraint buildEval(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr, Map<String, OperatorDescr> aliases, String expr, boolean isEvalExpression) {
        boolean isJavaEval;
        AnalysisResult analysis = PatternBuilder.buildAnalysis(context, pattern, predicateDescr, aliases);
        if (analysis == null) {
            return null;
        }
        Declaration[][] usedDeclarations = PatternBuilder.getUsedDeclarations(context, pattern, analysis);
        Declaration[] previousDeclarations = usedDeclarations[0];
        Declaration[] localDeclarations = usedDeclarations[1];
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        Arrays.sort(previousDeclarations, RuleTerminalNode.SortDeclarations.instance);
        Arrays.sort(localDeclarations, RuleTerminalNode.SortDeclarations.instance);
        boolean bl = isJavaEval = isEvalExpression && context.getDialect().isJava();
        if (isJavaEval) {
            PredicateConstraint predicateConstraint = new PredicateConstraint(null, previousDeclarations, localDeclarations);
            PredicateBuilder builder = context.getDialect().getPredicateBuilder();
            builder.build(context, usedIdentifiers, previousDeclarations, localDeclarations, predicateConstraint, predicateDescr, analysis);
            return predicateConstraint;
        }
        String[] requiredGlobals = usedIdentifiers.getGlobals().keySet().toArray(new String[usedIdentifiers.getGlobals().size()]);
        Declaration[] mvelDeclarations = new Declaration[previousDeclarations.length + localDeclarations.length + requiredGlobals.length];
        int i = 0;
        for (Declaration declaration : previousDeclarations) {
            mvelDeclarations[i++] = declaration;
        }
        for (Declaration declaration : localDeclarations) {
            mvelDeclarations[i++] = declaration;
        }
        for (String string : requiredGlobals) {
            mvelDeclarations[i++] = context.getDeclarationResolver().getDeclaration(string);
        }
        boolean bl2 = pattern.getObjectType().isTemplate() || !((ClassObjectType)pattern.getObjectType()).getClassType().isArray() && !context.getKnowledgeBuilder().getTypeDeclaration(pattern.getObjectType()).isTypesafe();
        return PatternBuilder.getConstraintBuilder().buildMvelConstraint(context.getPkg().getName(), expr, mvelDeclarations, PatternBuilder.getOperators(usedIdentifiers.getOperators()), context, previousDeclarations, localDeclarations, predicateDescr, analysis, bl2);
    }

    public static EvaluatorWrapper[] getOperators(Map<String, EvaluatorWrapper> operatorMap) {
        EvaluatorWrapper[] operators = new EvaluatorWrapper[operatorMap.size()];
        int i = 0;
        for (Map.Entry<String, EvaluatorWrapper> entry : operatorMap.entrySet()) {
            EvaluatorWrapper evaluator = entry.getValue();
            evaluator.setBindingName(entry.getKey());
            operators[i++] = evaluator;
        }
        return operators;
    }

    public static Declaration[][] getUsedDeclarations(RuleBuildContext context, Pattern pattern, AnalysisResult analysis) {
        BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
        ArrayList<Declaration> tupleDeclarations = new ArrayList<Declaration>();
        ArrayList<Declaration> factDeclarations = new ArrayList<Declaration>();
        for (String id : usedIdentifiers.getDeclrClasses().keySet()) {
            Declaration decl = context.getDeclarationResolver().getDeclaration(id);
            if (decl.getPattern() == pattern) {
                factDeclarations.add(decl);
                continue;
            }
            tupleDeclarations.add(decl);
        }
        PatternBuilder.createImplicitBindings(context, pattern, analysis.getNotBoundedIdentifiers(), analysis.getBoundIdentifiers(), factDeclarations);
        Declaration[][] usedDeclarations = new Declaration[][]{tupleDeclarations.toArray(new Declaration[tupleDeclarations.size()]), factDeclarations.toArray(new Declaration[factDeclarations.size()])};
        return usedDeclarations;
    }

    public static AnalysisResult buildAnalysis(RuleBuildContext context, Pattern pattern, PredicateDescr predicateDescr, Map<String, OperatorDescr> aliases) {
        HashMap<String, EvaluatorWrapper> operators = aliases == null ? new HashMap<String, EvaluatorWrapper>() : PatternBuilder.buildOperators(context, pattern, (BaseDescr)predicateDescr, aliases);
        return context.getDialect().analyzeExpression(context, (BaseDescr)predicateDescr, predicateDescr.getContent(), new BoundIdentifiers(pattern, (PackageBuildContext)context, operators, pattern.getObjectType()));
    }

    public static Map<String, EvaluatorWrapper> buildOperators(RuleBuildContext context, Pattern pattern, BaseDescr predicateDescr, Map<String, OperatorDescr> aliases) {
        if (aliases.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, EvaluatorWrapper> operators = new HashMap<String, EvaluatorWrapper>();
        for (Map.Entry<String, OperatorDescr> entry : aliases.entrySet()) {
            OperatorDescr op = entry.getValue();
            Declaration leftDecl = PatternBuilder.createDeclarationForOperator(context, pattern, op.getLeftString());
            Declaration rightDecl = PatternBuilder.createDeclarationForOperator(context, pattern, op.getRightString());
            EvaluatorDefinition.Target left = leftDecl != null && leftDecl.isPatternDeclaration() ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            EvaluatorDefinition.Target right = rightDecl != null && rightDecl.isPatternDeclaration() ? EvaluatorDefinition.Target.HANDLE : EvaluatorDefinition.Target.FACT;
            op.setLeftIsHandle(left == EvaluatorDefinition.Target.HANDLE);
            op.setRightIsHandle(right == EvaluatorDefinition.Target.HANDLE);
            Evaluator evaluator = PatternBuilder.getConstraintBuilder().getEvaluator(context, predicateDescr, ValueType.OBJECT_TYPE, op.getOperator(), false, op.getParametersText(), left, right);
            EvaluatorWrapper wrapper = PatternBuilder.getConstraintBuilder().wrapEvaluator(evaluator, leftDecl, rightDecl);
            operators.put(entry.getKey(), wrapper);
        }
        return operators;
    }

    private static Declaration createDeclarationForOperator(RuleBuildContext context, Pattern pattern, String expr) {
        Declaration declaration;
        int dotPos = expr.indexOf(46);
        if (dotPos < 0) {
            if (!StringUtils.isIdentifier((String)expr)) {
                return null;
            }
            declaration = context.getDeclarationResolver().getDeclaration(expr);
            if (declaration == null) {
                if ("this".equals(expr)) {
                    declaration = PatternBuilder.createDeclarationObject(context, "this", pattern);
                } else {
                    declaration = new Declaration("this", pattern);
                    context.getPkg().getReader(pattern.getObjectType().getClassName(), expr, (AcceptsReadAccessor)declaration);
                }
            }
        } else {
            String part1 = expr.substring(0, dotPos).trim();
            String part2 = expr.substring(dotPos + 1).trim();
            if ("this".equals(part1)) {
                declaration = PatternBuilder.createDeclarationObject(context, part2, (Pattern)context.getDeclarationResolver().peekBuildStack());
            } else {
                declaration = context.getDeclarationResolver().getDeclaration(part1);
                if (declaration != null) {
                    declaration = PatternBuilder.createDeclarationObject(context, part2, declaration.getPattern());
                }
            }
        }
        return declaration;
    }

    private static ConstraintBuilder getConstraintBuilder() {
        return ConstraintBuilder.get();
    }

    public static void createImplicitBindings(RuleBuildContext context, Pattern pattern, Set<String> unboundIdentifiers, BoundIdentifiers boundIdentifiers, List<Declaration> factDeclarations) {
        Iterator<String> it = unboundIdentifiers.iterator();
        while (it.hasNext()) {
            String identifier = it.next();
            Declaration declaration = PatternBuilder.createDeclarationObject(context, identifier, pattern);
            if (declaration == null) continue;
            factDeclarations.add(declaration);
            boundIdentifiers.getDeclrClasses().put(identifier, declaration.getDeclarationClass());
            it.remove();
        }
    }

    protected static Declaration createDeclarationObject(RuleBuildContext context, String identifier, Pattern pattern) {
        return PatternBuilder.createDeclarationObject(context, identifier, identifier, pattern);
    }

    protected static Declaration createDeclarationObject(RuleBuildContext context, String identifier, String expr, Pattern pattern) {
        BindingDescr implicitBinding = new BindingDescr(identifier, expr);
        Declaration declaration = new Declaration(identifier, null, pattern, true);
        ReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, (BaseDescr)implicitBinding, pattern, implicitBinding.getExpression(), (AcceptsReadAccessor)declaration, false);
        if (extractor == null) {
            return null;
        }
        declaration.setReadAccessor(extractor);
        return declaration;
    }

    public static void registerReadAccessor(RuleBuildContext context, ObjectType objectType, String fieldName, AcceptsReadAccessor target) {
        if (!ValueType.FACTTEMPLATE_TYPE.equals((Object)objectType.getValueType())) {
            context.getPkg().getReader(objectType.getClassName(), fieldName, target);
        }
    }

    public static ReadAccessor getFieldReadAccessor(RuleBuildContext context, BaseDescr descr, Pattern pattern, String fieldName, AcceptsReadAccessor target, boolean reportError) {
        return PatternBuilder.getFieldReadAccessor(context, descr, pattern, pattern.getObjectType(), fieldName, target, reportError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReadAccessor getFieldReadAccessor(RuleBuildContext context, BaseDescr descr, Pattern pattern, ObjectType objectType, String fieldName, AcceptsReadAccessor target, boolean reportError) {
        ReadAccessor reader;
        Declaration decl;
        if (ValueType.FACTTEMPLATE_TYPE.equals((Object)objectType.getValueType())) {
            FactTemplate factTemplate = ((FactTemplateObjectType)objectType).getFactTemplate();
            FactTemplateFieldExtractor reader2 = new FactTemplateFieldExtractor(factTemplate, fieldName);
            if (target == null) return reader2;
            target.setReadAccessor((ReadAccessor)reader2);
            return reader2;
        }
        boolean isGetter = getterRegexp.matcher(fieldName).matches();
        if (isGetter) {
            fieldName = fieldName.substring(3, fieldName.indexOf(40)).trim();
        }
        if (!isGetter) {
            if (!identifierRegexp.matcher(fieldName).matches()) return ConstraintBuilder.get().buildMvelFieldReadAccessor(context, descr, pattern, objectType, fieldName, reportError);
        }
        if ((decl = (Declaration)context.getDeclarationResolver().getDeclarations(context.getRule()).get(fieldName)) != null && decl.getExtractor() instanceof FieldNameSupplier && "this".equals(((FieldNameSupplier)decl.getExtractor()).getFieldName())) {
            return decl.getExtractor();
        }
        try {
            reader = context.getPkg().getReader(objectType.getClassName(), fieldName, target);
            return reader;
        }
        catch (Exception e) {
            if (reportError && context.isTypesafe()) {
                PatternBuilder.registerDescrBuildError(context, descr, e, "Unable to create Field Extractor for '" + fieldName + "'" + e.getMessage());
            }
            reader = null;
            return reader;
        }
        finally {
            if (!reportError) return reader;
            Collection results = context.getPkg().getWiringResults(((ClassObjectType)objectType).getClassType(), fieldName);
            if (results.isEmpty()) return reader;
            Iterator iterator = results.iterator();
            while (iterator.hasNext()) {
                KnowledgeBuilderResult res = (KnowledgeBuilderResult)iterator.next();
                if (res.getSeverity() == ResultSeverity.ERROR) {
                    context.addError(new DroolsErrorWrapper(res));
                    continue;
                }
                context.addWarning(new DroolsWarningWrapper(res));
            }
            return reader;
        }
    }

    protected ConstraintConnectiveDescr parseExpression(RuleBuildContext context, PatternDescr patternDescr, BaseDescr original, String expression) {
        DrlExprParser parser = new DrlExprParser(context.getConfiguration().getLanguageLevel());
        ConstraintConnectiveDescr result = parser.parse(DescrDumper.normalizeEval(expression));
        result.setResource(patternDescr.getResource());
        result.copyLocation(original);
        if (parser.hasErrors()) {
            for (DroolsParserException error : parser.getErrors()) {
                PatternBuilder.registerDescrBuildError(context, (BaseDescr)patternDescr, "Unable to parse pattern expression:\n" + error.getMessage());
            }
            return null;
        }
        return result;
    }

    public static void registerDescrBuildError(RuleBuildContext context, BaseDescr patternDescr, String error) {
        PatternBuilder.registerDescrBuildError(context, patternDescr, null, error);
    }

    public static void registerDescrBuildError(RuleBuildContext context, BaseDescr patternDescr, Object object, String error) {
        context.addError(new DescrBuildError(context.getParentDescr(), patternDescr, object, error));
    }

    public static class ExprBindings {
        protected Set<String> globalBindings = new HashSet<String>();
        protected Set<String> ruleBindings = new HashSet<String>();
        protected Set<String> fieldAccessors = new HashSet<String>();
        protected boolean withJavaIdentifier = false;

        public Set<String> getGlobalBindings() {
            return this.globalBindings;
        }

        public Set<String> getRuleBindings() {
            return this.ruleBindings;
        }

        public Set<String> getFieldAccessors() {
            return this.fieldAccessors;
        }

        public boolean isWithJavaIdentifier() {
            return this.withJavaIdentifier;
        }

        public void setWithJavaIdentifier(boolean withJavaIdentifier) {
            this.withJavaIdentifier = withJavaIdentifier;
        }

        public boolean isConstant() {
            return !this.withJavaIdentifier && this.globalBindings.isEmpty() && this.ruleBindings.isEmpty() && this.fieldAccessors.size() <= 1;
        }
    }
}

