/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.core.WorkingMemory;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.PatternSource;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.Tuple;

public abstract class Accumulate
extends ConditionalElement
implements PatternSource {
    private static final long serialVersionUID = 510L;
    protected RuleConditionElement source;
    protected Declaration[] requiredDeclarations;
    protected Declaration[] innerDeclarationCache;
    protected List<Accumulate> cloned = Collections.emptyList();

    public Accumulate() {
    }

    public Accumulate(RuleConditionElement source, Declaration[] requiredDeclarations) {
        this.source = source;
        this.requiredDeclarations = requiredDeclarations;
        this.initInnerDeclarationCache();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.source = (RuleConditionElement)in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
        this.cloned = (List)in.readObject();
        this.initInnerDeclarationCache();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.source);
        out.writeObject(this.requiredDeclarations);
        out.writeObject(this.cloned);
    }

    public abstract Accumulator[] getAccumulators();

    public abstract Object createContext();

    public abstract void init(Object var1, Object var2, Tuple var3, WorkingMemory var4);

    public abstract void accumulate(Object var1, Object var2, Tuple var3, InternalFactHandle var4, WorkingMemory var5);

    public abstract void reverse(Object var1, Object var2, Tuple var3, InternalFactHandle var4, WorkingMemory var5);

    public abstract Object getResult(Object var1, Object var2, Tuple var3, WorkingMemory var4);

    public abstract boolean supportsReverse();

    @Override
    public abstract Accumulate clone();

    protected void registerClone(Accumulate clone) {
        if (this.cloned == Collections.EMPTY_LIST) {
            this.cloned = new ArrayList<Accumulate>(1);
        }
        this.cloned.add(clone);
    }

    public RuleConditionElement getSource() {
        return this.source;
    }

    @Override
    public Map<String, Declaration> getInnerDeclarations() {
        return this.source.getInnerDeclarations();
    }

    @Override
    public Map<String, Declaration> getOuterDeclarations() {
        return Collections.emptyMap();
    }

    @Override
    public Declaration resolveDeclaration(String identifier) {
        return this.source.getInnerDeclarations().get(identifier);
    }

    public abstract Object createWorkingMemoryContext();

    public List<RuleConditionElement> getNestedElements() {
        return Collections.singletonList(this.source);
    }

    @Override
    public boolean isPatternScopeDelimiter() {
        return true;
    }

    public abstract boolean isMultiFunction();

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        for (int i = 0; i < this.requiredDeclarations.length; ++i) {
            if (!this.requiredDeclarations[i].equals(declaration)) continue;
            this.requiredDeclarations[i] = resolved;
        }
        this.replaceAccumulatorDeclaration(declaration, resolved);
    }

    protected abstract void replaceAccumulatorDeclaration(Declaration var1, Declaration var2);

    protected Declaration[] getInnerDeclarationCache() {
        return this.innerDeclarationCache;
    }

    private void initInnerDeclarationCache() {
        Map<String, Declaration> innerDeclarations = this.source.getInnerDeclarations();
        this.innerDeclarationCache = innerDeclarations.values().toArray(new Declaration[innerDeclarations.size()]);
        Arrays.sort(this.innerDeclarationCache, RuleTerminalNode.SortDeclarations.instance);
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public boolean hasRequiredDeclarations() {
        return this.requiredDeclarations != null && this.requiredDeclarations.length > 0;
    }

    @Override
    public boolean requiresLeftActivation() {
        return true;
    }
}

