/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.asm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.base.ClassFieldReader;
import org.kie.api.io.Resource;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.mvel2.asm.AnnotationVisitor;
import org.mvel2.asm.Attribute;
import org.mvel2.asm.ClassReader;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

public class ClassFieldInspector {
    private final Map<String, Integer> fieldNames = new HashMap<String, Integer>();
    private final Map<String, Class<?>> fieldTypes = new HashMap();
    private final Map<String, Field> fieldTypesField = new HashMap<String, Field>();
    private final Map<String, Method> getterMethods = new HashMap<String, Method>();
    private final Map<String, Method> setterMethods = new HashMap<String, Method>();
    private final Set<String> nonGetters = new HashSet<String>();
    private Class<?> classUnderInspection = null;
    private Map<String, Collection<KnowledgeBuilderResult>> results = null;

    public ClassFieldInspector(Class<?> classUnderInspection) throws IOException {
        this(classUnderInspection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFieldInspector(Class<?> classUnderInspection, boolean includeFinalMethods) throws IOException {
        this.classUnderInspection = classUnderInspection;
        String name = this.getResourcePath(classUnderInspection);
        InputStream stream = classUnderInspection.getResourceAsStream(name);
        if (stream != null) {
            try {
                this.processClassWithByteCode(classUnderInspection, stream, includeFinalMethods);
            }
            finally {
                stream.close();
            }
        } else {
            this.processClassWithoutByteCode(classUnderInspection, includeFinalMethods);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassWithByteCode(Class<?> clazz, InputStream stream, boolean includeFinalMethods) throws IOException {
        ClassReader reader = new ClassReader(stream);
        ClassFieldVisitor visitor = new ClassFieldVisitor(clazz, includeFinalMethods, this);
        reader.accept((ClassVisitor)visitor, 0);
        if (clazz.getSuperclass() != null) {
            String name = this.getResourcePath(clazz.getSuperclass());
            InputStream parentStream = clazz.getResourceAsStream(name);
            if (parentStream != null) {
                try {
                    this.processClassWithByteCode(clazz.getSuperclass(), parentStream, includeFinalMethods);
                }
                finally {
                    parentStream.close();
                }
            } else {
                this.processClassWithoutByteCode(clazz.getSuperclass(), includeFinalMethods);
            }
        }
        if (clazz.isInterface()) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
                String name = this.getResourcePath(anInterface);
                InputStream parentStream = clazz.getResourceAsStream(name);
                if (parentStream != null) {
                    try {
                        this.processClassWithByteCode(anInterface, parentStream, includeFinalMethods);
                        continue;
                    }
                    finally {
                        parentStream.close();
                    }
                }
                this.processClassWithoutByteCode(anInterface, includeFinalMethods);
            }
        }
    }

    private void processClassWithoutByteCode(Class<?> clazz, boolean includeFinalMethods) {
        int fieldIndex;
        List<Method> methods = Arrays.asList(clazz.getMethods());
        Collections.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                String n2;
                String n1 = m1.getName();
                if (n1.equals(n2 = m2.getName()) && m1.getDeclaringClass() != m2.getDeclaringClass()) {
                    return m1.getDeclaringClass().isAssignableFrom(m2.getDeclaringClass()) ? -1 : 1;
                }
                return n1.compareTo(n2);
            }
        });
        for (Method method : methods) {
            int mask;
            int n = mask = includeFinalMethods ? 1 : 17;
            if ((method.getModifiers() & mask) != 1) continue;
            if (!(method.getParameterTypes().length != 0 || method.getName().equals("<init>") || method.getName().equals("<clinit>") || method.getReturnType() == Void.TYPE || method.isDefault())) {
                fieldIndex = this.fieldNames.size();
                this.addToMapping(method, fieldIndex);
                continue;
            }
            if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
            fieldIndex = this.fieldNames.size();
            this.addToMapping(method, fieldIndex);
        }
        List<Field> flds = Arrays.asList(clazz.getFields());
        Collections.sort(flds, new Comparator<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        for (Field fld : flds) {
            if (Modifier.isStatic(fld.getModifiers()) || this.fieldNames.containsKey(fld.getName())) continue;
            fieldIndex = this.fieldNames.size();
            this.fieldNames.put(fld.getName(), fieldIndex);
            this.fieldTypes.put(fld.getName(), fld.getType());
            this.fieldTypesField.put(fld.getName(), fld);
        }
    }

    private String getResourcePath(Class<?> clazz) {
        return "/" + clazz.getCanonicalName() + ".class";
    }

    public Map<String, Integer> getFieldNames() {
        return this.fieldNames;
    }

    public boolean isNonGetter(String name) {
        return this.nonGetters.contains(name);
    }

    public Map<String, Field> getFieldTypesField() {
        return this.fieldTypesField;
    }

    public Map<String, Class<?>> getFieldTypes() {
        return this.fieldTypes;
    }

    public Class<?> getFieldType(String name) {
        return this.fieldTypes.get(name);
    }

    public Map<String, Method> getGetterMethods() {
        return this.getterMethods;
    }

    public Map<String, Method> getSetterMethods() {
        return this.setterMethods;
    }

    private void addToMapping(Method method, int index) {
        String name;
        int offset = (name = method.getName()).startsWith("is") ? 2 : (name.startsWith("get") || name.startsWith("set") ? 3 : 0);
        String fieldName = this.calcFieldName(name, offset);
        if (this.fieldNames.containsKey(fieldName)) {
            if (offset != 0 && this.nonGetters.contains(fieldName)) {
                Integer oldIndex = this.removeOldField(fieldName);
                this.storeField(oldIndex, fieldName);
                this.storeGetterSetter(method, fieldName);
                this.nonGetters.remove(fieldName);
            } else if (offset != 0) {
                this.storeGetterSetter(method, fieldName);
            }
        } else {
            this.storeField(index, fieldName);
            this.storeGetterSetter(method, fieldName);
            if (offset == 0) {
                this.nonGetters.add(fieldName);
            }
        }
    }

    private Integer removeOldField(String fieldName) {
        Integer index = this.fieldNames.remove(fieldName);
        this.fieldTypes.remove(fieldName);
        this.getterMethods.remove(fieldName);
        return index;
    }

    private void storeField(Integer index, String fieldName) {
        this.fieldNames.put(fieldName, index);
    }

    private Map<String, Field> getAllFields(Class<?> type) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                fields.put(f.getName(), f);
            }
        }
        return fields;
    }

    private void storeGetterSetter(Method method, String fieldName) {
        Field f = this.getAllFields(this.classUnderInspection).get(fieldName);
        if (method.getName().startsWith("set") && method.getParameterTypes().length == 1) {
            this.setterMethods.put(fieldName, method);
            if (!this.fieldTypes.containsKey(fieldName)) {
                this.fieldTypes.put(fieldName, method.getParameterTypes()[0]);
            }
            if (!this.fieldTypesField.containsKey(fieldName)) {
                this.fieldTypesField.put(fieldName, f);
            }
        } else if (!Void.TYPE.isAssignableFrom(method.getReturnType())) {
            Method existingMethod = this.getterMethods.get(fieldName);
            if (existingMethod != null && !this.isOverride(existingMethod, method)) {
                if (method.getReturnType() != existingMethod.getReturnType() && method.getReturnType().isAssignableFrom(existingMethod.getReturnType())) {
                    return;
                }
                this.addResult(fieldName, new GetterOverloadWarning(this.classUnderInspection, this.getterMethods.get(fieldName).getName(), this.fieldTypes.get(fieldName), method.getName(), method.getReturnType()));
            }
            this.getterMethods.put(fieldName, method);
            this.fieldTypes.put(fieldName, method.getReturnType());
            this.fieldTypesField.put(fieldName, f);
        }
    }

    private boolean isOverride(Method oldMethod, Method newMethod) {
        return !oldMethod.getDeclaringClass().equals(newMethod.getDeclaringClass()) && oldMethod.getDeclaringClass().isAssignableFrom(newMethod.getDeclaringClass());
    }

    private String calcFieldName(String name, int offset) {
        name = name.substring(offset);
        return ClassFieldReader.decapitalizeFieldName(name);
    }

    public Collection<KnowledgeBuilderResult> getInspectionResults(String fieldName) {
        return this.results != null && this.results.containsKey(fieldName) ? this.results.get(fieldName) : Collections.EMPTY_LIST;
    }

    private void addResult(String fieldName, KnowledgeBuilderResult result) {
        Map<String, Collection<KnowledgeBuilderResult>> results = this.getResults();
        Collection<KnowledgeBuilderResult> fieldResults = results.get(fieldName);
        if (fieldResults == null) {
            fieldResults = new ArrayList<KnowledgeBuilderResult>(3);
            results.put(fieldName, fieldResults);
        }
        fieldResults.add(result);
    }

    protected Map<String, Collection<KnowledgeBuilderResult>> getResults() {
        if (this.results == null) {
            this.results = new HashMap<String, Collection<KnowledgeBuilderResult>>();
        }
        return this.results;
    }

    public class GetterOverloadWarning
    implements KnowledgeBuilderResult {
        private Class klass;
        private String oldName;
        private Class oldType;
        private String newName;
        private Class newType;

        public GetterOverloadWarning(Class klass, String oldName, Class oldType, String newName, Class newType) {
            this.klass = klass;
            this.oldName = oldName;
            this.oldType = oldType;
            this.newName = newName;
            this.newType = newType;
        }

        public ResultSeverity getSeverity() {
            return ResultSeverity.WARNING;
        }

        public String getMessage() {
            return " Getter overloading detected in class " + this.klass.getName() + " : " + this.oldName + " (" + this.oldType + ") vs " + this.newName + " (" + this.newType + ") ";
        }

        public int[] getLines() {
            return new int[0];
        }

        public Resource getResource() {
            return null;
        }
    }

    static class ClassFieldAnnotationVisitor
    extends AnnotationVisitor {
        ClassFieldAnnotationVisitor() {
            super(327680);
        }

        public void visit(String arg0, Object arg1) {
        }

        public void visitEnum(String arg0, String arg1, String arg2) {
        }

        public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
            return new ClassFieldAnnotationVisitor();
        }

        public AnnotationVisitor visitArray(String arg0) {
            return new ClassFieldAnnotationVisitor();
        }

        public void visitEnd() {
        }
    }

    static class ClassFieldVisitor
    extends ClassVisitor {
        private Class<?> clazz;
        private ClassFieldInspector inspector;
        private boolean includeFinalMethods;

        ClassFieldVisitor(Class<?> cls, boolean includeFinalMethods, ClassFieldInspector inspector) {
            super(327680);
            this.clazz = cls;
            this.includeFinalMethods = includeFinalMethods;
            this.inspector = inspector;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            block6: {
                int mask;
                int n = mask = this.includeFinalMethods ? 1 : 17;
                if ((access & mask) == 1) {
                    try {
                        Method[] methods;
                        if (desc.startsWith("()") && !name.equals("<init>") && !name.equals("<clinit>")) {
                            Method method = this.clazz.getMethod(name, null);
                            if (method.getReturnType() != Void.TYPE) {
                                int fieldIndex = this.inspector.fieldNames.size();
                                this.inspector.addToMapping(method, fieldIndex);
                            }
                            break block6;
                        }
                        if (!name.startsWith("set")) break block6;
                        for (Method method : methods = this.clazz.getMethods()) {
                            if (!name.equals(method.getName()) || !desc.equals(Type.getMethodDescriptor((Method)method))) continue;
                            int fieldIndex = this.inspector.fieldNames.size();
                            this.inspector.addToMapping(method, fieldIndex);
                            break;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error getting field access method: " + name + ": " + e.getMessage(), e);
                    }
                }
            }
            return null;
        }

        public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
        }

        public void visitAttribute(Attribute arg0) {
        }

        public void visitEnd() {
        }

        public void visit(int arg0, int arg1, String arg2, String arg3, String arg4, String[] arg5) {
        }

        public void visitSource(String arg0, String arg1) {
        }

        public void visitOuterClass(String arg0, String arg1, String arg2) {
        }

        public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
            return new ClassFieldAnnotationVisitor();
        }

        public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
            return null;
        }
    }
}

