/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.spi.Tuple;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.TupleRBTree;
import org.drools.core.util.index.IndexUtil;
import org.drools.core.util.index.TupleList;

public class TupleIndexRBTree
implements Externalizable,
TupleMemory {
    private TupleRBTree<Comparable<Comparable>> tree;
    private AbstractHashTable.FieldIndex index;
    private IndexUtil.ConstraintType constraintType;
    private int size;
    private boolean left;

    public TupleIndexRBTree() {
    }

    public TupleIndexRBTree(IndexUtil.ConstraintType constraintType, AbstractHashTable.FieldIndex index, boolean left) {
        this.index = index;
        this.constraintType = constraintType;
        this.left = left;
        this.tree = new TupleRBTree();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tree);
        out.writeObject(this.index);
        out.writeObject((Object)this.constraintType);
        out.writeInt(this.size);
        out.writeBoolean(this.left);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tree = (TupleRBTree)in.readObject();
        this.index = (AbstractHashTable.FieldIndex)in.readObject();
        this.constraintType = (IndexUtil.ConstraintType)((Object)in.readObject());
        this.size = in.readInt();
        this.left = in.readBoolean();
    }

    @Override
    public void add(Tuple tuple) {
        Comparable key = this.getLeftIndexedValue(tuple);
        TupleRBTree.Node<Comparable<Comparable>> list = this.tree.insert(key);
        list.add(tuple);
        ++this.size;
    }

    @Override
    public void remove(Tuple tuple) {
        TupleList list = tuple.getMemory();
        list.remove(tuple);
        if (list.getFirst() == null) {
            this.tree.delete((Comparable<Comparable>)((TupleRBTree.Node)list).key);
        }
        --this.size;
    }

    @Override
    public void removeAdd(Tuple tuple) {
        this.remove(tuple);
        this.add(tuple);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Entry[] toArray() {
        FastIterator it = this.tree.fastIterator();
        if (it == null) {
            return new Entry[0];
        }
        ArrayList toBeRemoved = new ArrayList();
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        TupleList list = null;
        while ((list = (TupleList)it.next(list)) != null) {
            for (Tuple entry = list.getFirst(); entry != null; entry = (Tuple)entry.getNext()) {
                result.add(entry);
            }
        }
        return result.toArray(new Tuple[result.size()]);
    }

    @Override
    public Tuple getFirst(Tuple rightTuple) {
        Comparable key = this.getRightIndexedValue(rightTuple);
        return this.getNext(key, true);
    }

    @Override
    public Iterator<Tuple> iterator() {
        TupleRBTree.Node<Comparable<Comparable>> list = this.tree.first();
        Tuple firstTuple = list != null ? list.getFirst() : null;
        return new FastIterator.IteratorAdapter(this.fastIterator(), firstTuple);
    }

    @Override
    public boolean contains(Tuple leftTuple) {
        Comparable key = this.getLeftIndexedValue(leftTuple);
        return this.tree.lookup(key) != null;
    }

    @Override
    public FastIterator fastIterator() {
        return new TupleFastIterator();
    }

    @Override
    public FastIterator fullFastIterator() {
        return new TupleFastIterator();
    }

    @Override
    public FastIterator fullFastIterator(Tuple leftTuple) {
        FastIterator fastIterator = this.fullFastIterator();
        Comparable key = this.getLeftIndexedValue(leftTuple);
        fastIterator.next(this.getNext(key, true));
        return fastIterator;
    }

    private Comparable getLeftIndexedValue(Tuple tuple) {
        return this.getIndexedValue(tuple, this.left);
    }

    private Comparable getRightIndexedValue(Tuple tuple) {
        return this.getIndexedValue(tuple, !this.left);
    }

    private Comparable getIndexedValue(Tuple tuple, boolean left) {
        return left ? (Comparable)this.index.getDeclaration().getExtractor().getValue(tuple.getObject(this.index.getDeclaration())) : (Comparable)this.index.getExtractor().getValue(tuple.getFactHandle().getObject());
    }

    private Tuple getNext(Comparable key, boolean first) {
        return this.left ? this.getNextLeft(key, first) : this.getNextRight(key, first);
    }

    private Tuple getNextLeft(Comparable key, boolean first) {
        TupleRBTree.Node<Comparable<Comparable>> firstNode;
        switch (this.constraintType) {
            case LESS_THAN: {
                firstNode = this.tree.findNearestNode(key, false, TupleRBTree.Boundary.LOWER);
                break;
            }
            case LESS_OR_EQUAL: {
                firstNode = this.tree.findNearestNode(key, first, TupleRBTree.Boundary.LOWER);
                break;
            }
            case GREATER_THAN: {
                firstNode = this.tree.findNearestNode(key, false, TupleRBTree.Boundary.UPPER);
                break;
            }
            case GREATER_OR_EQUAL: {
                firstNode = this.tree.findNearestNode(key, first, TupleRBTree.Boundary.UPPER);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot call remove constraint of type: " + (Object)((Object)this.constraintType));
            }
        }
        return firstNode == null ? null : firstNode.getFirst();
    }

    private Tuple getNextRight(Comparable key, boolean first) {
        TupleRBTree.Node<Comparable<Comparable>> firstNode;
        switch (this.constraintType) {
            case LESS_THAN: {
                firstNode = this.tree.findNearestNode(key, false, TupleRBTree.Boundary.UPPER);
                break;
            }
            case LESS_OR_EQUAL: {
                firstNode = this.tree.findNearestNode(key, first, TupleRBTree.Boundary.UPPER);
                break;
            }
            case GREATER_THAN: {
                firstNode = this.tree.findNearestNode(key, false, TupleRBTree.Boundary.LOWER);
                break;
            }
            case GREATER_OR_EQUAL: {
                firstNode = this.tree.findNearestNode(key, first, TupleRBTree.Boundary.LOWER);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot call remove constraint of type: " + (Object)((Object)this.constraintType));
            }
        }
        return firstNode == null ? null : firstNode.getFirst();
    }

    @Override
    public void clear() {
        this.tree = new TupleRBTree();
    }

    @Override
    public TupleMemory.IndexType getIndexType() {
        return TupleMemory.IndexType.COMPARISON;
    }

    public class TupleFastIterator
    implements FastIterator {
        @Override
        public Entry next(Entry object) {
            if (object == null) {
                TupleRBTree.Node firstNode = TupleIndexRBTree.this.tree.first();
                return firstNode == null ? null : firstNode.getFirst();
            }
            Tuple tuple = (Tuple)object;
            Tuple next = (Tuple)tuple.getNext();
            if (next != null) {
                return next;
            }
            Comparable key = TupleIndexRBTree.this.getLeftIndexedValue(tuple);
            return TupleIndexRBTree.this.getNext(key, false);
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }
    }
}

