/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.util.IoUtils;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.csv.CsvLineParser;
import org.drools.template.parser.DataListener;
import org.drools.template.parser.DecisionTableParseException;

public class CsvParser
implements DecisionTableParser {
    private List<DataListener> _listeners;
    private CsvLineParser _lineParser;

    public CsvParser(DataListener listener, CsvLineParser lineParser) {
        this._listeners = new ArrayList<DataListener>();
        this._listeners.add(listener);
        this._lineParser = lineParser;
    }

    public CsvParser(List<DataListener> listeners, CsvLineParser lineParser) {
        this._listeners = listeners;
        this._lineParser = lineParser;
    }

    @Override
    public void parseFile(InputStream inStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, IoUtils.UTF8_CHARSET));
        try {
            this.startSheet();
            this.processRows(reader);
            this.finishSheet();
        }
        catch (IOException e) {
            throw new DecisionTableParseException("An error occurred reading the CSV data.", (Throwable)e);
        }
    }

    @Override
    public void parseFile(File file) {
        try {
            this.parseFile(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new DecisionTableParseException("An error occurred reading the CSV data.", (Throwable)e);
        }
    }

    private void startSheet() {
        for (DataListener listener : this._listeners) {
            listener.startSheet("csv");
        }
    }

    private void finishSheet() {
        for (DataListener listener : this._listeners) {
            listener.finishSheet();
        }
    }

    private void newRow(int row, int numCells) {
        for (DataListener listener : this._listeners) {
            listener.newRow(row, numCells);
        }
    }

    private void newCell(int row, int column, String value, int mergedColStart) {
        for (DataListener listener : this._listeners) {
            listener.newCell(row, column, value, mergedColStart);
        }
    }

    private void processRows(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        int row = 0;
        while (line != null) {
            List<String> cells = this._lineParser.parse(line);
            this.newRow(row, cells.size());
            int startMergeCol = -1;
            for (int col = 0; col < cells.size(); ++col) {
                String cell = cells.get(col);
                startMergeCol = this.calcStartMerge(startMergeCol, col, cell);
                cell = this.calcCellText(startMergeCol, cell);
                this.newCell(row, col, cell, startMergeCol);
            }
            ++row;
            line = reader.readLine();
        }
    }

    String calcCellText(int startMergeCol, String cell) {
        if (startMergeCol != -1) {
            cell = cell.substring(0, cell.length() - 3);
        }
        return cell;
    }

    int calcStartMerge(int startMergeCol, int col, String cell) {
        if (cell.endsWith("...") && startMergeCol == -1) {
            startMergeCol = col;
        } else if (!cell.endsWith("...")) {
            startMergeCol = -1;
        }
        return startMergeCol;
    }
}

