/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.scenariosimulation.backend.util.ImpossibleToFindDMNException;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;

public class DMNSimulationUtils {
    private static String delimiter = "/";

    private DMNSimulationUtils() {
    }

    public static DMNModel extractDMNModel(DMNRuntime dmnRuntime, String path) {
        List<String> pathSplit = Arrays.asList(new StringBuilder(path).reverse().toString().split(delimiter));
        List dmnModels = dmnRuntime.getModels();
        return DMNSimulationUtils.findDMNModel(dmnModels, pathSplit, 1);
    }

    public static DMNRuntime extractDMNRuntime(KieContainer kieContainer) {
        return (DMNRuntime)KieRuntimeFactory.of((KieBase)kieContainer.getKieBase()).get(DMNRuntime.class);
    }

    public static DMNModel findDMNModel(List<DMNModel> dmnModels, List<String> pathToFind, int step) {
        ArrayList<DMNModel> result = new ArrayList<DMNModel>();
        String pathToCompare = String.join((CharSequence)delimiter, pathToFind.subList(0, step));
        for (DMNModel dmnModel : dmnModels) {
            String modelPath = new StringBuilder(dmnModel.getResource().getSourcePath()).reverse().toString();
            if (!modelPath.startsWith(pathToCompare)) continue;
            result.add(dmnModel);
        }
        if (result.size() == 0) {
            throw new ImpossibleToFindDMNException("Retrieving the DMNModel has failed. Make sure the used DMN asset does not produce any compilation errors and that the project does not contain multiple DMN assets with the same name and namespace. In addition, check if the reference to the DMN file is correct in the Settings panel. After addressing the issues, build the project again.");
        }
        if (result.size() == 1) {
            return (DMNModel)result.get(0);
        }
        return DMNSimulationUtils.findDMNModel(dmnModels, pathToFind, step + 1);
    }
}

