/*
 * Decompiled with CFR 0.152.
 */
package org.drools.tms;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.definitions.rule.impl.QueryImpl;
import org.drools.tms.AbductiveQuery;
import org.drools.tms.TruthMaintenanceSystemImpl;
import org.drools.tms.beliefsystem.abductive.Abductive;

public class TruthMaintenanceSystemFactoryImpl
implements TruthMaintenanceSystemFactory {
    private final Map<InternalWorkingMemoryEntryPoint, TruthMaintenanceSystem> tmsForEntryPoints = Collections.synchronizedMap(new IdentityHashMap());

    public TruthMaintenanceSystem getOrCreateTruthMaintenanceSystem(ReteEvaluator reteEvaluator) {
        return this.getOrCreateTruthMaintenanceSystem((InternalWorkingMemoryEntryPoint)reteEvaluator.getDefaultEntryPoint());
    }

    public TruthMaintenanceSystem getOrCreateTruthMaintenanceSystem(InternalWorkingMemoryEntryPoint entryPoint) {
        return this.tmsForEntryPoints.computeIfAbsent(entryPoint, TruthMaintenanceSystemImpl::new);
    }

    public void clearTruthMaintenanceSystem(InternalWorkingMemoryEntryPoint entryPoint) {
        TruthMaintenanceSystem tms = this.tmsForEntryPoints.remove(entryPoint);
        if (tms != null) {
            tms.clear();
        }
    }

    public QueryImpl createTmsQuery(String name, Predicate<Class<? extends Annotation>> hasAnnotation) {
        return hasAnnotation.test(Abductive.class) ? new AbductiveQuery(name) : new QueryImpl(name);
    }

    public int getEntryPointsMapSize() {
        return this.tmsForEntryPoints.size();
    }

    public void clearEntryPointsMap() {
        this.tmsForEntryPoints.clear();
    }
}

