/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.model;

import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.utils.ScenarioSimulationI18nServerMessage;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class FactMappingValidationError {
    private String errorId;
    private String errorMessage;
    private ScenarioSimulationI18nServerMessage serverMessage;
    private String[] parameters;

    public static FactMappingValidationError createFieldChangedError(FactMapping factMapping, String newType) {
        return new FactMappingValidationError(FactMappingValidationError.extractFactMappingId(factMapping), ScenarioSimulationI18nServerMessage.SCENARIO_VALIDATION_FIELD_CHANGED_ERROR, factMapping.getClassName(), newType);
    }

    public static FactMappingValidationError createNodeChangedError(FactMapping factMapping, String newType) {
        return new FactMappingValidationError(FactMappingValidationError.extractFactMappingId(factMapping), ScenarioSimulationI18nServerMessage.SCENARIO_VALIDATION_NODE_CHANGED_ERROR, factMapping.getFactIdentifier().getClassName(), newType);
    }

    public static FactMappingValidationError createFieldAddedConstraintError(FactMapping factMapping) {
        return new FactMappingValidationError(FactMappingValidationError.extractFactMappingId(factMapping), ScenarioSimulationI18nServerMessage.SCENARIO_VALIDATION_FIELD_ADDED_CONSTRAINT_ERROR, new String[0]);
    }

    public static FactMappingValidationError createFieldRemovedConstraintError(FactMapping factMapping) {
        return new FactMappingValidationError(FactMappingValidationError.extractFactMappingId(factMapping), ScenarioSimulationI18nServerMessage.SCENARIO_VALIDATION_FIELD_REMOVED_CONSTRAINT_ERROR, new String[0]);
    }

    public static FactMappingValidationError createGenericError(FactMapping factMapping, String genericError) {
        return new FactMappingValidationError(FactMappingValidationError.extractFactMappingId(factMapping), genericError);
    }

    private static String extractFactMappingId(FactMapping factMapping) {
        return factMapping.getFactAlias() + "." + factMapping.getExpressionAlias();
    }

    public FactMappingValidationError() {
    }

    public FactMappingValidationError(String errorId, String errorMessage) {
        this.errorId = errorId;
        this.errorMessage = errorMessage;
    }

    public FactMappingValidationError(String errorId, ScenarioSimulationI18nServerMessage serverMessage, String ... parameters) {
        this.errorId = errorId;
        this.serverMessage = serverMessage;
        this.parameters = parameters;
    }

    public String getErrorId() {
        return this.errorId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ScenarioSimulationI18nServerMessage getServerMessage() {
        return this.serverMessage;
    }

    public String[] getParameters() {
        return this.parameters;
    }
}

