/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.importexport;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;

public class ScenarioCsvImportExport {
    public static final int HEADER_SIZE = 3;

    public String exportData(AbstractScesimModel<? extends AbstractScesimData> scesimModel) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        List factMappings = scesimModel.getScesimModelDescriptor().getUnmodifiableFactMappings();
        CSVPrinter printer = new CSVPrinter((Appendable)stringBuilder, CSVFormat.DEFAULT);
        this.generateHeader(factMappings, printer);
        for (AbstractScesimData scesimData : scesimModel.getUnmodifiableData()) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (FactMapping factMapping : factMappings) {
                Optional factMappingValue = scesimData.getFactMappingValue(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier());
                values.add(factMappingValue.map(FactMappingValue::getRawValue).orElse(""));
            }
            printer.printRecord(values.toArray());
        }
        printer.close();
        return stringBuilder.toString();
    }

    public <T extends AbstractScesimData> AbstractScesimModel<T> importData(String raw, AbstractScesimModel<T> originalScesimModel) throws IOException {
        CSVParser csvParser = CSVFormat.DEFAULT.parse((Reader)new StringReader(raw));
        AbstractScesimModel toReturn = originalScesimModel.cloneModel();
        toReturn.clearDatas();
        List factMappings = toReturn.getScesimModelDescriptor().getUnmodifiableFactMappings();
        List csvRecords = csvParser.getRecords();
        if (csvRecords.size() < 3) {
            throw new IllegalArgumentException("Malformed file, missing header");
        }
        csvRecords = csvRecords.subList(3, csvRecords.size());
        for (CSVRecord csvRecord : csvRecords) {
            AbstractScesimData scesimDataToFill = toReturn.addData();
            if (csvRecord.size() != factMappings.size()) {
                throw new IllegalArgumentException("Malformed row " + csvRecord);
            }
            for (int i = 0; i < factMappings.size(); ++i) {
                FactMapping factMapping = (FactMapping)factMappings.get(i);
                String valueToImport = "".equals(csvRecord.get(i)) ? null : csvRecord.get(i);
                scesimDataToFill.addMappingValue(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier(), (Object)valueToImport);
            }
        }
        return toReturn;
    }

    protected void generateHeader(List<FactMapping> factMappings, CSVPrinter printer) throws IOException {
        ArrayList<String> firstLineHeader = new ArrayList<String>();
        ArrayList<String> secondLineHeader = new ArrayList<String>();
        ArrayList<String> thirdLineHeader = new ArrayList<String>();
        for (FactMapping factMapping : factMappings) {
            if (FactMappingType.OTHER.equals((Object)factMapping.getExpressionIdentifier().getType())) {
                String factAlias = factMapping.getFactAlias();
                firstLineHeader.add(factAlias);
                secondLineHeader.add(factAlias);
                thirdLineHeader.add(factAlias);
                continue;
            }
            firstLineHeader.add(factMapping.getExpressionIdentifier().getType().name());
            secondLineHeader.add("#".equals(factMapping.getFactAlias()) ? "" : factMapping.getFactAlias());
            thirdLineHeader.add(factMapping.getExpressionAlias());
        }
        printer.printRecord(firstLineHeader.toArray());
        printer.printRecord(secondLineHeader.toArray());
        printer.printRecord(thirdLineHeader.toArray());
    }
}

