/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.testscenario.backend.server.indexing;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.models.testscenarios.backend.util.ScenarioXMLPersistence;
import org.drools.workbench.models.testscenarios.shared.Scenario;
import org.drools.workbench.screens.testscenario.backend.server.indexing.TestScenarioIndexVisitor;
import org.drools.workbench.screens.testscenario.type.TestScenarioResourceTypeDefinition;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class TestScenarioFileIndexer
extends AbstractFileIndexer {
    @Inject
    protected TestScenarioResourceTypeDefinition type;
    @Inject
    private DataModelService dataModelService;

    public boolean supportsPath(Path path) {
        return this.type.accept(Paths.convert((Path)path));
    }

    public DefaultIndexBuilder fillIndexBuilder(Path path) throws Exception {
        String content = this.ioService.readAllString(path);
        Scenario model = ScenarioXMLPersistence.getInstance().unmarshal(content);
        ModuleDataModelOracle dmo = this.getModuleDataModelOracle(path);
        Module project = this.moduleService.resolveModule(Paths.convert((Path)path));
        Package pkg = this.moduleService.resolvePackage(Paths.convert((Path)path));
        DefaultIndexBuilder builder = new DefaultIndexBuilder(Paths.convert((Path)path).getFileName(), project, pkg);
        TestScenarioIndexVisitor visitor = new TestScenarioIndexVisitor(dmo, builder, model);
        visitor.visit();
        this.addReferencedResourcesToIndexBuilder(builder, visitor);
        return builder;
    }

    protected String getPackageName(Path path) {
        return this.moduleService.resolvePackage(Paths.convert((Path)path)).getPackageName();
    }

    protected ModuleDataModelOracle getModuleDataModelOracle(Path path) {
        return this.dataModelService.getModuleDataModel(Paths.convert((Path)path));
    }
}

