/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.mining;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dmg.pmml.pmml_4_2.descr.SimplePredicate;
import org.kie.pmml.pmml_4_2.PMML4Helper;
import org.kie.pmml.pmml_4_2.model.mining.PredicateRuleProducer;

public class SimpleSegmentPredicate
implements PredicateRuleProducer {
    public static final String EQUAL = "equal";
    public static final String NOT_EQUAL = "notEqual";
    public static final String GREATER = "greaterThan";
    public static final String GREATER_EQUAL = "greaterOrEqual";
    public static final String LESSER = "lessThan";
    public static final String LESSER_EQUAL = "lessOrEqual";
    public static final String MISSING = "isMissing";
    public static final String NOT_MISSING = "isNotMissing";
    private String baseFieldName;
    private String operator;
    private String value;
    private boolean stringLiteralValue;
    private static PMML4Helper helper = new PMML4Helper();

    public SimpleSegmentPredicate() {
    }

    public SimpleSegmentPredicate(SimplePredicate predicate) {
        this.baseFieldName = predicate.getField();
        this.operator = predicate.getOperator();
        this.value = predicate.getValue();
        this.stringLiteralValue = this.checkValueForStringLiteral(this.value);
        if (this.operator == null) {
            throw new IllegalStateException("PMML - SimplePredicate: Missing operator");
        }
    }

    public String getBaseFieldName() {
        return this.baseFieldName;
    }

    public String getCapitalizedFieldName() {
        return helper.compactAsJavaId(this.baseFieldName, true);
    }

    public String getValueFieldName() {
        return "v".concat(this.getCapitalizedFieldName());
    }

    public String getMissingFieldName() {
        return "m".concat(this.getCapitalizedFieldName());
    }

    @Override
    public String getPredicateRule() {
        StringBuilder bldr = new StringBuilder();
        bldr.append("( ").append(this.getMissingFieldName()).append(" == false )").append(" && ( ").append(this.getValueFieldName());
        if (this.operator.equalsIgnoreCase(GREATER)) {
            bldr.append(" > ").append(this.getValue()).append(" )");
            return bldr.toString();
        }
        if (this.operator.equalsIgnoreCase(LESSER)) {
            bldr.append(" < ").append(this.getValue()).append(" )");
            return bldr.toString();
        }
        if (this.operator.equalsIgnoreCase(EQUAL)) {
            bldr.append(" == ").append(this.getValue()).append(" )");
            return bldr.toString();
        }
        if (this.operator.equalsIgnoreCase(NOT_EQUAL)) {
            bldr.append(" != ").append(this.getValue()).append(" )");
            return bldr.toString();
        }
        if (this.operator.equalsIgnoreCase(MISSING)) {
            return this.getMissingFieldName() + " == true";
        }
        if (this.operator.equalsIgnoreCase(NOT_MISSING)) {
            return this.getMissingFieldName() + " == false";
        }
        if (this.operator.equalsIgnoreCase(GREATER_EQUAL)) {
            bldr.append(" >= ").append(this.getValue()).append(" )");
            return bldr.toString();
        }
        if (this.operator.equalsIgnoreCase(LESSER_EQUAL)) {
            bldr.append(" <= ").append(this.getValue()).append(" )");
            return bldr.toString();
        }
        throw new IllegalStateException("PMML - SimplePredicate: Unknown operator (" + this.operator + ")");
    }

    private boolean checkValueForStringLiteral(String value) {
        Pattern p = Pattern.compile("[0-9]*\\.?+[0-9]*");
        Matcher m = p.matcher(value.trim());
        return !m.matches();
    }

    private String getValue() {
        return this.stringLiteralValue ? "\"" + this.value + "\"" : this.value;
    }

    public boolean isStringLiteralValue() {
        return this.stringLiteralValue;
    }

    public void setStringLiteralValue(boolean stringLiteralValue) {
        this.stringLiteralValue = stringLiteralValue;
    }

    @Override
    public List<String> getPredicateFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add(this.baseFieldName);
        return fieldNames;
    }

    @Override
    public List<String> getFieldMissingFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add(this.getMissingFieldName());
        return fieldNames;
    }

    @Override
    public boolean isAlwaysTrue() {
        return false;
    }

    @Override
    public boolean isAlwaysFalse() {
        return false;
    }
}

