/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.duckdb.DuckDBColumnType;
import org.duckdb.DuckDBNative;
import org.duckdb.DuckDBPreparedStatement;
import org.duckdb.DuckDBResultSetMetaData;
import org.duckdb.DuckDBVector;
import org.duckdb.JdbcUtils;
import org.duckdb.JsonNode;

public class DuckDBResultSet
implements ResultSet {
    private final DuckDBPreparedStatement stmt;
    private final DuckDBResultSetMetaData meta;
    private ByteBuffer result_ref;
    private DuckDBVector[] current_chunk = new DuckDBVector[0];
    private int chunk_idx = 0;
    private boolean finished = false;
    private boolean was_null;
    private final ByteBuffer conn_ref;

    public DuckDBResultSet(DuckDBPreparedStatement duckDBPreparedStatement, DuckDBResultSetMetaData duckDBResultSetMetaData, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws SQLException {
        this.stmt = Objects.requireNonNull(duckDBPreparedStatement);
        this.result_ref = Objects.requireNonNull(byteBuffer);
        this.meta = Objects.requireNonNull(duckDBResultSetMetaData);
        this.conn_ref = Objects.requireNonNull(byteBuffer2);
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet was closed");
        }
        return this.stmt;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet was closed");
        }
        return this.meta;
    }

    @Override
    public synchronized boolean next() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet was closed");
        }
        if (this.finished) {
            return false;
        }
        ++this.chunk_idx;
        if (this.current_chunk.length == 0 || this.chunk_idx > this.current_chunk[0].length) {
            this.current_chunk = DuckDBNative.duckdb_jdbc_fetch(this.result_ref, this.conn_ref);
            this.chunk_idx = 1;
        }
        if (this.current_chunk.length == 0) {
            this.finished = true;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.result_ref != null) {
            DuckDBNative.duckdb_jdbc_free_result(this.result_ref);
            this.result_ref = null;
            if (this.stmt.closeOnCompletion) {
                this.stmt.close();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.result_ref == null;
    }

    private void check(int n) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet was closed");
        }
        if (n < 1 || n > this.meta.column_count) {
            throw new SQLException("Column index out of bounds");
        }
    }

    public synchronized Object arrowExportStream(Object object, long l) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Result set is closed");
        }
        try {
            Class<?> clazz = Class.forName("org.apache.arrow.memory.BufferAllocator");
            if (!clazz.isInstance(object)) {
                throw new RuntimeException("Need to pass an Arrow BufferAllocator");
            }
            Long l2 = DuckDBNative.duckdb_jdbc_arrow_stream(this.result_ref, l);
            Class<?> clazz2 = Class.forName("org.apache.arrow.c.ArrowArrayStream");
            Object object2 = clazz2.getMethod("wrap", Long.TYPE).invoke(null, l2);
            Class<?> clazz3 = Class.forName("org.apache.arrow.c.Data");
            return clazz3.getMethod("importArrayStream", clazz, clazz2).invoke(null, object, object2);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Object getObject(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        return this.current_chunk[n - 1].getObject(this.chunk_idx - 1);
    }

    public Struct getStruct(int n) throws SQLException {
        return this.check_and_null(n) ? null : this.current_chunk[n - 1].getStruct(this.chunk_idx - 1);
    }

    public OffsetTime getOffsetTime(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        return this.current_chunk[n - 1].getOffsetTime(this.chunk_idx - 1);
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet was closed");
        }
        return this.was_null;
    }

    private boolean check_and_null(int n) throws SQLException {
        this.check(n);
        try {
            this.was_null = this.current_chunk[n - 1].check_and_null(this.chunk_idx - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException("No row in context", arrayIndexOutOfBoundsException);
        }
        return this.was_null;
    }

    public JsonNode getJsonObject(int n) throws SQLException {
        String string = this.getLazyString(n);
        return string == null ? null : new JsonNode(string);
    }

    public String getLazyString(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        return this.current_chunk[n - 1].getLazyString(this.chunk_idx - 1);
    }

    @Override
    public String getString(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return false;
        }
        return this.current_chunk[n - 1].getBoolean(this.chunk_idx - 1);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0;
        }
        return this.current_chunk[n - 1].getByte(this.chunk_idx - 1);
    }

    @Override
    public short getShort(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0;
        }
        return this.current_chunk[n - 1].getShort(this.chunk_idx - 1);
    }

    @Override
    public int getInt(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0;
        }
        return this.current_chunk[n - 1].getInt(this.chunk_idx - 1);
    }

    private short getUint8(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0;
        }
        return this.current_chunk[n - 1].getUint8(this.chunk_idx - 1);
    }

    private int getUint16(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0;
        }
        return this.current_chunk[n - 1].getUint16(this.chunk_idx - 1);
    }

    private long getUint32(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0L;
        }
        return this.current_chunk[n - 1].getUint32(this.chunk_idx - 1);
    }

    private BigInteger getUint64(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return BigInteger.ZERO;
        }
        return this.current_chunk[n - 1].getUint64(this.chunk_idx - 1);
    }

    @Override
    public long getLong(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return 0L;
        }
        return this.current_chunk[n - 1].getLong(this.chunk_idx - 1);
    }

    public BigInteger getHugeint(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return BigInteger.ZERO;
        }
        return this.current_chunk[n - 1].getHugeint(this.chunk_idx - 1);
    }

    public BigInteger getUhugeint(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return BigInteger.ZERO;
        }
        return this.current_chunk[n - 1].getUhugeint(this.chunk_idx - 1);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return Float.NaN;
        }
        return this.current_chunk[n - 1].getFloat(this.chunk_idx - 1);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return Double.NaN;
        }
        return this.current_chunk[n - 1].getDouble(this.chunk_idx - 1);
    }

    @Override
    public int findColumn(String string) throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet was closed");
        }
        for (int i = 0; i < this.meta.column_count; ++i) {
            if (!this.meta.column_names[i].contentEquals(string)) continue;
            return i + 1;
        }
        throw new SQLException("Could not find column with label " + string);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBigDecimal");
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBytes");
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.check_and_null(n) ? null : this.current_chunk[n - 1].getDate(this.chunk_idx - 1);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.check_and_null(n) ? null : this.current_chunk[n - 1].getTime(this.chunk_idx - 1);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        return this.current_chunk[n - 1].getTimestamp(this.chunk_idx - 1);
    }

    private LocalDateTime getLocalDateTime(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        return this.current_chunk[n - 1].getLocalDateTime(this.chunk_idx - 1);
    }

    private OffsetDateTime getOffsetDateTime(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        return this.current_chunk[n - 1].getOffsetDateTime(this.chunk_idx - 1);
    }

    public UUID getUuid(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        return this.current_chunk[n - 1].getUuid(this.chunk_idx - 1);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        return this.current_chunk[n - 1].getBlob(this.chunk_idx - 1);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBinaryStream");
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBigDecimal");
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBytes");
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getBinaryStream");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLFeatureNotSupportedException("getWarnings");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLFeatureNotSupportedException("clearWarnings");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException("getCursorName");
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getCharacterStream");
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getCharacterStream");
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        return this.current_chunk[n - 1].getBigDecimal(this.chunk_idx - 1);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("isBeforeFirst");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("isAfterLast");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("isFirst");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("isLast");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("beforeFirst");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("afterLast");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLFeatureNotSupportedException("first");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException("last");
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("getRow");
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("absolute");
    }

    @Override
    public boolean relative(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("relative");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException("previous");
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000 && n != 1002) {
            throw new SQLFeatureNotSupportedException("setFetchDirection");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Fetch size has to be >= 0");
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return DuckDBNative.duckdb_jdbc_fetch_size();
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowUpdated");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowInserted");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException("rowDeleted");
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRow");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("deleteRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("refreshRow");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("cancelRowUpdates");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("moveToInsertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("moveToCurrentRow");
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getClob");
    }

    @Override
    public Array getArray(int n) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        return this.current_chunk[n - 1].getArray(this.chunk_idx - 1);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getClob");
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.check_and_null(n)) {
            return null;
        }
        return this.current_chunk[n - 1].getTimestamp(this.chunk_idx - 1, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getURL");
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getURL");
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("getHoldability");
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNString");
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNString");
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNCharacterStream");
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw new SQLFeatureNotSupportedException("getNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("updateNClob");
    }

    private boolean isTimestamp(DuckDBColumnType duckDBColumnType) {
        return duckDBColumnType == DuckDBColumnType.TIMESTAMP || duckDBColumnType == DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        if (clazz == null) {
            throw new SQLException("type is null");
        }
        DuckDBColumnType duckDBColumnType = this.meta.column_types[n - 1];
        if (clazz == BigDecimal.class) {
            if (duckDBColumnType == DuckDBColumnType.DECIMAL) {
                return clazz.cast(this.getBigDecimal(n));
            }
            throw new SQLException("Can't convert value to BigDecimal " + clazz.toString());
        }
        if (clazz == String.class) {
            if (duckDBColumnType == DuckDBColumnType.VARCHAR || duckDBColumnType == DuckDBColumnType.ENUM) {
                return clazz.cast(this.getString(n));
            }
            throw new SQLException("Can't convert value to String " + clazz.toString());
        }
        if (clazz == Boolean.class) {
            if (duckDBColumnType == DuckDBColumnType.BOOLEAN) {
                return clazz.cast(this.getBoolean(n));
            }
            throw new SQLException("Can't convert value to boolean " + clazz.toString());
        }
        if (clazz == Short.class) {
            if (duckDBColumnType == DuckDBColumnType.SMALLINT) {
                return clazz.cast(this.getShort(n));
            }
            throw new SQLException("Can't convert value to short " + clazz.toString());
        }
        if (clazz == Integer.class) {
            if (duckDBColumnType == DuckDBColumnType.INTEGER) {
                return clazz.cast(this.getInt(n));
            }
            if (duckDBColumnType == DuckDBColumnType.SMALLINT) {
                return clazz.cast(this.getShort(n));
            }
            if (duckDBColumnType == DuckDBColumnType.TINYINT) {
                return clazz.cast(this.getByte(n));
            }
            if (duckDBColumnType == DuckDBColumnType.USMALLINT) {
                throw new SQLException("Can't convert value to integer " + clazz.toString());
            }
            if (duckDBColumnType == DuckDBColumnType.UTINYINT) {
                throw new SQLException("Can't convert value to integer " + clazz.toString());
            }
            throw new SQLException("Can't convert value to integer " + clazz.toString());
        }
        if (clazz == Long.class) {
            if (duckDBColumnType == DuckDBColumnType.BIGINT || this.isTimestamp(duckDBColumnType)) {
                return clazz.cast(this.getLong(n));
            }
            if (duckDBColumnType == DuckDBColumnType.UINTEGER) {
                throw new SQLException("Can't convert value to long " + clazz.toString());
            }
            throw new SQLException("Can't convert value to long " + clazz.toString());
        }
        if (clazz == Float.class) {
            if (duckDBColumnType == DuckDBColumnType.FLOAT) {
                return clazz.cast(Float.valueOf(this.getFloat(n)));
            }
            throw new SQLException("Can't convert value to float " + clazz.toString());
        }
        if (clazz == Double.class) {
            if (duckDBColumnType == DuckDBColumnType.DOUBLE) {
                return clazz.cast(this.getDouble(n));
            }
            throw new SQLException("Can't convert value to float " + clazz.toString());
        }
        if (clazz == Date.class) {
            if (duckDBColumnType == DuckDBColumnType.DATE) {
                return clazz.cast(this.getDate(n));
            }
            throw new SQLException("Can't convert value to Date " + clazz.toString());
        }
        if (clazz == Time.class) {
            if (duckDBColumnType == DuckDBColumnType.TIME) {
                return clazz.cast(this.getTime(n));
            }
            throw new SQLException("Can't convert value to Time " + clazz.toString());
        }
        if (clazz == Timestamp.class) {
            if (this.isTimestamp(duckDBColumnType)) {
                return clazz.cast(this.getTimestamp(n));
            }
            throw new SQLException("Can't convert value to Timestamp " + clazz.toString());
        }
        if (clazz == LocalDateTime.class) {
            if (this.isTimestamp(duckDBColumnType)) {
                return clazz.cast(this.getLocalDateTime(n));
            }
            throw new SQLException("Can't convert value to LocalDateTime " + clazz.toString());
        }
        if (clazz == BigInteger.class) {
            if (duckDBColumnType == DuckDBColumnType.HUGEINT) {
                throw new SQLException("Can't convert value to BigInteger " + clazz.toString());
            }
            if (duckDBColumnType == DuckDBColumnType.UHUGEINT) {
                throw new SQLException("Can't convert value to BigInteger " + clazz.toString());
            }
            if (duckDBColumnType == DuckDBColumnType.UBIGINT) {
                throw new SQLException("Can't convert value to BigInteger " + clazz.toString());
            }
            throw new SQLException("Can't convert value to BigInteger " + clazz.toString());
        }
        if (clazz == OffsetDateTime.class) {
            if (duckDBColumnType == DuckDBColumnType.TIMESTAMP_WITH_TIME_ZONE) {
                return clazz.cast(this.getOffsetDateTime(n));
            }
            throw new SQLException("Can't convert value to OffsetDateTime " + clazz.toString());
        }
        if (clazz == Blob.class) {
            if (duckDBColumnType == DuckDBColumnType.BLOB) {
                throw new SQLException("Can't convert value to Blob " + clazz.toString());
            }
            throw new SQLException("Can't convert value to Blob " + clazz.toString());
        }
        throw new SQLException("Can't convert value to " + clazz + " " + clazz.toString());
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException("getObject");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return JdbcUtils.unwrap(this, clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    boolean isFinished() {
        return this.finished;
    }

    public static class DuckDBBlobResult
    implements Blob {
        private ByteBuffer buffer;

        public DuckDBBlobResult(ByteBuffer byteBuffer) {
            byteBuffer.position(0);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.buffer = byteBuffer;
        }

        @Override
        public InputStream getBinaryStream() {
            return this.getBinaryStream(0L, this.length());
        }

        @Override
        public InputStream getBinaryStream(long l, long l2) {
            return new ByteBufferBackedInputStream(this.buffer);
        }

        @Override
        public byte[] getBytes(long l, int n) throws SQLException {
            if (l < 1L || n < 0) {
                throw new SQLException("Invalid position or length");
            }
            byte[] byArray = new byte[n];
            this.buffer.position((int)l - 1);
            this.buffer.get(byArray, 0, n);
            return byArray;
        }

        @Override
        public long position(Blob blob, long l) throws SQLException {
            throw new SQLFeatureNotSupportedException("position");
        }

        @Override
        public long position(byte[] byArray, long l) throws SQLException {
            throw new SQLFeatureNotSupportedException("position");
        }

        @Override
        public long length() {
            return this.buffer.capacity();
        }

        @Override
        public void free() {
        }

        @Override
        public OutputStream setBinaryStream(long l) throws SQLException {
            throw new SQLFeatureNotSupportedException("setBinaryStream");
        }

        @Override
        public void truncate(long l) throws SQLException {
            throw new SQLFeatureNotSupportedException("truncate");
        }

        @Override
        public int setBytes(long l, byte[] byArray) throws SQLException {
            throw new SQLFeatureNotSupportedException("setBytes");
        }

        @Override
        public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
            throw new SQLFeatureNotSupportedException("setBytes");
        }

        public String toString() {
            return "DuckDBBlobResult{buffer=" + this.buffer + '}';
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DuckDBBlobResult duckDBBlobResult = (DuckDBBlobResult)object;
            return Objects.equals(this.buffer, duckDBBlobResult.buffer);
        }

        public int hashCode() {
            return Objects.hash(this.buffer);
        }

        static class ByteBufferBackedInputStream
        extends InputStream {
            ByteBuffer buf;

            public ByteBufferBackedInputStream(ByteBuffer byteBuffer) {
                this.buf = byteBuffer;
            }

            @Override
            public int read() throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                return this.buf.get() & 0xFF;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                n2 = Math.min(n2, this.buf.remaining());
                this.buf.get(byArray, n, n2);
                return n2;
            }
        }
    }
}

