/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.error.ShouldBeExactlyInstanceOf;
import org.fest.assertions.error.ShouldContainString;
import org.fest.assertions.error.ShouldEndWith;
import org.fest.assertions.error.ShouldHaveMessage;
import org.fest.assertions.error.ShouldHaveNoCause;
import org.fest.assertions.error.ShouldStartWith;
import org.fest.assertions.internal.Diff;
import org.fest.assertions.internal.Failures;
import org.fest.assertions.internal.Objects;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Throwables {
    private static final Throwables INSTANCE = new Throwables();
    @VisibleForTesting
    Diff diff = new Diff();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Throwables instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Throwables() {
    }

    public void assertIsExactlyInstanceOf(AssertionInfo info, Throwable actual, Class<? extends Throwable> type) {
        Throwables.assertNotNull(info, actual);
        if (type == null) {
            throw new NullPointerException("The given type should not be null");
        }
        Class<?> current = actual.getClass();
        if (type.equals(current)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeExactlyInstanceOf.shouldBeExactlyInstance(actual, type));
    }

    public void assertHasMessage(AssertionInfo info, Throwable actual, String message) {
        Throwables.assertNotNull(info, actual);
        if (org.fest.util.Objects.areEqual((Object)actual.getMessage(), (Object)message)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveMessage.shouldHaveMessage(actual, message));
    }

    public void assertHasNoCause(AssertionInfo info, Throwable actual) {
        Throwables.assertNotNull(info, actual);
        Throwable actualCause = actual.getCause();
        if (actualCause == null) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveNoCause.shouldHaveNoCause(actual));
    }

    public void assertHasMessageStartingWith(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().startsWith(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldStartWith.shouldStartWith(actual.getMessage(), description));
    }

    public void assertHasMessageContaining(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().contains(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldContainString.shouldContain(actual.getMessage(), description));
    }

    public void assertHasMessageEndingWith(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().endsWith(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldEndWith.shouldEndWith(actual.getMessage(), description));
    }

    private static void assertNotNull(AssertionInfo info, Throwable actual) {
        Objects.instance().assertNotNull(info, actual);
    }
}

