/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayWrapperList
extends AbstractList<Object> {
    private final Object array;

    public static ArrayWrapperList wrap(Object array) {
        if (array == null) {
            return null;
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("The object to wrap should be an array");
        }
        return new ArrayWrapperList(array);
    }

    @VisibleForTesting
    ArrayWrapperList(Object array) {
        this.array = array;
    }

    @Override
    public Object get(int index) {
        this.checkIsInRange(index);
        return Array.get(this.array, index);
    }

    private void checkIsInRange(int index) {
        int size = this.size();
        if (index >= 0 && index < this.size()) {
            return;
        }
        String message = String.format("Index should be between 0 and %d (inclusive,) but was %d", size - 1, index);
        throw new IndexOutOfBoundsException(message);
    }

    @Override
    public int size() {
        return Array.getLength(this.array);
    }

    public Class<?> getComponentType() {
        return this.array.getClass().getComponentType();
    }

    @VisibleForTesting
    Object array() {
        return this.array;
    }
}

