/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.ant;

import junit.framework.Test;
import org.fest.swing.junit.ant.StackTraceFilter;
import org.fest.swing.junit.ant.Tests;
import org.fest.swing.junit.xml.XmlAttribute;
import org.fest.swing.junit.xml.XmlAttributes;
import org.fest.swing.junit.xml.XmlNode;
import org.fest.util.Strings;

class TestXmlNodeWriter {
    private final StackTraceFilter stackTraceFilter;

    TestXmlNodeWriter() {
        this(new StackTraceFilter());
    }

    TestXmlNodeWriter(StackTraceFilter stackTraceFilter) {
        this.stackTraceFilter = stackTraceFilter;
    }

    XmlNode addNewTestXmlNode(XmlNode target, Test test) {
        String methodName = Tests.testMethodNameFrom(test);
        if (methodName == null) {
            methodName = "unknown";
        }
        return target.addNewNode("testcase", XmlAttributes.attributes(XmlAttribute.name("name").value(methodName), XmlAttribute.name("classname").value(Tests.testClassNameFrom(test))));
    }

    TestXmlNodeWriter writeTestExecutionTime(XmlNode target, long startTime) {
        double executionTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        target.addAttribute(XmlAttribute.name("time").value(executionTime));
        return this;
    }

    TestXmlNodeWriter writeErrorAndStackTrace(XmlNode target, Throwable error) {
        return this.writeError(target, error).writeStackTrace(target, error);
    }

    TestXmlNodeWriter writeError(XmlNode target, Throwable error) {
        String message = error.getMessage();
        if (!Strings.isEmpty((String)message)) {
            target.addAttribute(XmlAttribute.name("message").value(message));
        }
        target.addAttribute(XmlAttribute.name("type").value(error.getClass().getName()));
        return this;
    }

    TestXmlNodeWriter writeStackTrace(XmlNode target, Throwable error) {
        String stackTrace = this.stackTraceFilter.filter(error);
        target.addText(stackTrace);
        return this;
    }
}

