/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import com.ibm.icu.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.EllipsisHelper;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.LegendLayoutHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.SeriesNameFormat;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.util.ChartUtil;

public final class LegendBuilder
implements IConstants {
    private Size sz;

    private void initAvailableSize(LegendData lgData) throws ChartException {
        Block bl = lgData.cm.getBlock();
        Position lgPosition = lgData.lg.getPosition();
        Bounds boFull = bl.getBounds().scaledInstance(lgData.dScale);
        Insets ins = bl.getInsets().scaledInstance(lgData.dScale);
        Insets lgIns = lgData.lg.getInsets().scaledInstance(lgData.dScale);
        boolean titleWPos = false;
        boolean titleHPos = false;
        TitleBlock titleBlock = lgData.cm.getTitle();
        Bounds titleBounds = titleBlock.getBounds().scaledInstance(lgData.dScale);
        if (titleBlock.isVisible()) {
            switch (titleBlock.getAnchor().getValue()) {
                case 2: 
                case 6: {
                    titleWPos = true;
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    titleHPos = true;
                }
            }
        }
        lgData.dAvailableWidth = boFull.getWidth() - ins.getLeft() - ins.getRight() - lgIns.getLeft() - lgIns.getRight() - titleBounds.getWidth() * (double)titleWPos;
        lgData.dAvailableHeight = boFull.getHeight() - ins.getTop() - ins.getBottom() - lgIns.getTop() - lgIns.getBottom() - titleBounds.getHeight() * (double)titleHPos;
        double dMaxPercent = lgData.lg.getMaxPercent();
        if (dMaxPercent < 0.0 || dMaxPercent > 1.0) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, Messages.getString("exception.legend.orientation.InvalidMaxPercent"), Messages.getResourceBundle(lgData.xs.getULocale()));
        }
        double dMaxLegendWidth = boFull.getWidth() * dMaxPercent;
        double dMaxLegendHeight = boFull.getHeight() * dMaxPercent;
        switch (lgPosition.getValue()) {
            case 2: 
            case 3: 
            case 5: {
                if (!(lgData.dAvailableWidth > dMaxLegendWidth)) break;
                lgData.dAvailableWidth = dMaxLegendWidth;
                break;
            }
            case 0: 
            case 1: {
                if (!(lgData.dAvailableHeight > dMaxLegendHeight)) break;
                lgData.dAvailableHeight = dMaxLegendHeight;
            }
        }
    }

    private static Size getTitleSize(LegendData lgData) throws ChartException {
        Size size = null;
        Label laTitle = lgData.lg.getTitle();
        if (laTitle != null && laTitle.isSetVisible() && laTitle.isVisible()) {
            laTitle = LabelImpl.copyInstance(laTitle);
            String sTitle = laTitle.getCaption().getValue();
            laTitle.getCaption().setValue(lgData.rtc.externalizedMessage(sTitle));
            int iTitlePos = lgData.lg.getTitlePosition().getValue();
            double shadow = lgData.dShadowness;
            double space = 2.0 * shadow;
            double percent = lgData.lg.getTitlePercent();
            if (iTitlePos == 0 || iTitlePos == 1) {
                double dMaxTWidth = lgData.dAvailableWidth - shadow;
                double dMaxTHeight = lgData.dAvailableHeight * percent - space;
                Size maxTitleSize = SizeImpl.create(dMaxTWidth, dMaxTHeight);
                size = Methods.computeLimitedLabelSize(lgData.xs, laTitle, maxTitleSize, null);
                LegendData legendData = lgData;
                legendData.dAvailableHeight = legendData.dAvailableHeight - (size.getHeight() + space);
            } else {
                double dMaxTWidth = lgData.dAvailableWidth * percent - space;
                double dMaxTHeight = lgData.dAvailableHeight - shadow;
                Size maxTitleSize = SizeImpl.create(dMaxTWidth, dMaxTHeight);
                size = Methods.computeLimitedLabelSize(lgData.xs, laTitle, maxTitleSize, null);
                LegendData legendData = lgData;
                legendData.dAvailableWidth = legendData.dAvailableWidth - (size.getWidth() + space);
            }
            size.setWidth(size.getWidth() + space);
            size.setHeight(size.getHeight() + space);
        }
        lgData.laTitle = laTitle;
        return size;
    }

    public final Size compute(IDisplayServer xs, Chart cm, SeriesDefinition[] seda, RunTimeContext rtc) throws ChartException {
        LegendItemHints lih;
        Legend lg = cm.getLegend();
        if (!lg.isSetOrientation()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.legend.orientation.horzvert", Messages.getResourceBundle(xs.getULocale()));
        }
        if (!lg.isSetDirection()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.legend.direction.tblr", Messages.getResourceBundle(xs.getULocale()));
        }
        LegendData lgData = new LegendData(xs, cm, seda, rtc);
        this.initAvailableSize(lgData);
        boolean bMinSliceDefined = false;
        if (cm instanceof ChartWithoutAxes) {
            bMinSliceDefined = ((ChartWithoutAxes)cm).isSetMinSlice();
            lgData.sMinSliceLabel = ((ChartWithoutAxes)cm).getMinSliceLabel();
            if (lgData.sMinSliceLabel == null || lgData.sMinSliceLabel.length() == 0) {
                lgData.sMinSliceLabel = "";
            } else {
                lgData.sMinSliceLabel = rtc.externalizedMessage(lgData.sMinSliceLabel);
            }
        }
        if (bMinSliceDefined && lgData.bPaletteByCategory && cm instanceof ChartWithoutAxes) {
            this.calculateExtraLegend(cm, rtc, lgData);
        }
        Size titleSize = LegendBuilder.getTitleSize(lgData);
        double[] size = null;
        ContentProvider cProvider = ContentProvider.newInstance(lgData);
        ContentPlacer cPlacer = ContentPlacer.newInstance(lgData);
        while ((lih = cProvider.nextContent()) != null) {
            if (!cPlacer.placeContent(lih)) break;
        }
        cPlacer.finishPlacing();
        size = cPlacer.getSize();
        if (size == null) {
            return SizeImpl.create(0.0, 0.0);
        }
        double dWidth = size[0];
        double dHeight = size[1];
        if (titleSize != null) {
            int iTitlePos = lgData.lg.getTitlePosition().getValue();
            if (iTitlePos == 0 || iTitlePos == 1) {
                dWidth = Math.max(dWidth, titleSize.getWidth());
                dHeight += titleSize.getHeight();
            } else {
                dWidth += titleSize.getWidth();
                dHeight = Math.max(dHeight, titleSize.getHeight());
            }
        }
        if (rtc != null) {
            List legendItems = lgData.legendItems;
            LegendItemHints[] liha = legendItems.toArray(new LegendItemHints[legendItems.size()]);
            LegendLayoutHints lilh = new LegendLayoutHints(SizeImpl.create(dWidth, dHeight), titleSize, lgData.laTitle, lgData.bMinSliceApplied, lgData.sMinSliceLabel, liha);
            rtc.setLegendLayoutHints(lilh);
        }
        this.sz = SizeImpl.create(dWidth, dHeight);
        return this.sz;
    }

    private void calculateExtraLegend(Chart cm, RunTimeContext rtc, LegendData legendData) throws ChartException {
        Map renders = rtc.getSeriesRenderers();
        if (renders != null && !((ChartWithoutAxes)cm).getSeriesDefinitions().isEmpty()) {
            List<SeriesDefinition> sedList = ChartUtil.getAllOrthogonalSeriesDefinitions(cm);
            boolean started = false;
            for (SeriesDefinition sed : sedList) {
                List<Series> sdRuntimeSA = sed.getRunTimeSeries();
                for (Series seRuntime : sdRuntimeSA) {
                    try {
                        DataSetIterator dsiOrtho = new DataSetIterator(seRuntime.getDataSet());
                        LegendItemRenderingHints lirh = (LegendItemRenderingHints)renders.get(seRuntime);
                        if (lirh == null) {
                            return;
                        }
                        BaseRenderer br = lirh.getRenderer();
                        Collection<Integer> fsa = br.getFilteredMinSliceEntry(dsiOrtho);
                        if (fsa.size() > 0) {
                            legendData.bMinSliceApplied = true;
                        }
                        if (!started) {
                            started = true;
                            legendData.filteredMinSliceEntry = fsa;
                            continue;
                        }
                        legendData.filteredMinSliceEntry.retainAll(fsa);
                        if (legendData.filteredMinSliceEntry.size() != 0) continue;
                        return;
                    }
                    catch (Exception ex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, ex);
                    }
                }
            }
        }
    }

    private static Object getNonEmptyValue(Object value, Object defaultValue) {
        if (value == null || value.toString().length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public final Size getSize() {
        return this.sz;
    }

    private static String getValueText(Chart cm, Series se) throws ChartException {
        DataSetIterator dsiBase;
        String strValueText = null;
        if (cm.getLegend().isShowValue() && (dsiBase = LegendBuilder.createDataSetIterator(se, cm)).hasNext()) {
            Object obj = dsiBase.next();
            while (!LegendBuilder.isValidValue(obj) && dsiBase.hasNext()) {
                obj = dsiBase.next();
            }
            strValueText = String.valueOf(obj);
        }
        return strValueText;
    }

    private static double[] getItemSize(LabelItem laiLegend, LabelItem laiValue, boolean bIsShowValue, LegendData legendData, double dX) throws ChartException {
        double dWidth = 0.0;
        double dHeight = 0.0;
        laiLegend.checkEllipsis(LegendBuilder.getWidthLimit(dX, legendData));
        dWidth = laiLegend.getWidth() + legendData.dHorizonalReservedSpace;
        dHeight = legendData.insCa.getTop() + laiLegend.getHeight() + legendData.insCa.getBottom();
        if (bIsShowValue) {
            laiValue.checkEllipsis(legendData.dAvailableWidth - dX);
            dWidth = Math.max(dWidth, laiValue.getWidth());
            dHeight += laiValue.getHeight() + 2.0 * legendData.dScale;
        }
        return new double[]{dWidth, dHeight};
    }

    private static double[] getItemSizeGN(LabelItem laiLegend, LegendData legendData, double dX) throws ChartException {
        double dWidth = 0.0;
        double dHeight = 0.0;
        laiLegend.checkEllipsis(legendData.dAvailableWidth - dX);
        dWidth = laiLegend.getWidth();
        dHeight = laiLegend.getHeight();
        return new double[]{dWidth, dHeight};
    }

    private static double getWidthLimit(double dX, LegendData legendData) {
        return legendData.dAvailableWidth - legendData.dHorizonalReservedSpace - dX;
    }

    private static boolean isValidValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Double) {
            return !((Double)obj).isNaN() && !((Double)obj).isInfinite();
        }
        if (obj instanceof String) {
            return ((String)obj).length() != 0;
        }
        return true;
    }

    private static boolean isStacked(SeriesDefinition[] seda) {
        boolean bIsStack = true;
        int i = 0;
        while (i < seda.length) {
            if (bIsStack) {
                for (Series series : seda[i].getSeries()) {
                    if (series.isStacked()) continue;
                    bIsStack = false;
                    break;
                }
            }
            ++i;
        }
        return bIsStack;
    }

    private static DataSetIterator createDataSetIterator(Series se, Chart cm) throws ChartException {
        DataSetIterator dsi = null;
        try {
            dsi = new DataSetIterator(se.getDataSet());
            if (cm instanceof ChartWithAxes) {
                dsi.reverse(((ChartWithAxes)cm).isReverseCategory());
            }
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
        }
        return dsi;
    }

    private static class CategoryContentProvider
    extends ContentProvider {
        private SeriesDefinition sdBase = null;
        private DataSetIterator dsiBase = null;
        private Series seBase = null;
        private int pos = -1;
        private boolean bMinSliceCreated = false;

        protected CategoryContentProvider(LegendData lgData) throws ChartException {
            super(lgData);
            this.sdBase = (SeriesDefinition)ChartUtil.getBaseSeriesDefinitions(lgData.cm).get(0);
            this.seBase = this.sdBase.getRunTimeSeries().get(0);
            this.dsiBase = LegendBuilder.createDataSetIterator(this.seBase, lgData.cm);
            if (this.sdBase != null) {
                this.fs = this.sdBase.getFormatSpecifier();
            }
            boolean bDataReverse = this.bNeedInvert;
            if (lgData.cm instanceof ChartWithAxes) {
                ChartWithAxes cwa = (ChartWithAxes)lgData.cm;
                bDataReverse = ChartUtil.XOR(this.bNeedInvert, cwa.isReverseCategory());
            }
            this.dsiBase.reverse(bDataReverse);
        }

        public LegendItemHints nextContent() throws ChartException {
            if (this.dsiBase.hasNext()) {
                Object obj = this.dsiBase.next();
                obj = LegendBuilder.getNonEmptyValue(obj, " ");
                while (!LegendBuilder.isValidValue(obj) && this.dsiBase.hasNext()) {
                    obj = this.dsiBase.next();
                }
                ++this.pos;
                if (this.lgData.bMinSliceApplied && this.lgData.filteredMinSliceEntry.contains(this.pos)) {
                    return this.nextContent();
                }
                int index = this.bNeedInvert ? this.dsiBase.size() - 1 - this.pos : this.pos;
                return LegendItemHints.newCategoryEntry(this.format(obj), this.sdBase, this.seBase, index);
            }
            if (this.lgData.bMinSliceApplied && !this.bMinSliceCreated) {
                ++this.pos;
                int index = this.bNeedInvert ? this.dsiBase.size() - 1 - this.pos : this.pos;
                this.bMinSliceCreated = true;
                return LegendItemHints.newMinSliceEntry(this.lgData.sMinSliceLabel, this.sdBase, this.seBase, index);
            }
            return null;
        }
    }

    private static abstract class ContentPlacer {
        protected LabelItem laiItem = null;
        protected LabelItem laiValue = null;
        protected final LegendData lgData;
        protected final boolean bIsShowValue;
        protected final boolean bIsLeftRight;
        protected double dSepThick = 0.0;
        protected final boolean bCategory;
        protected double dX = 0.0;
        protected double dY = 0.0;
        protected double dMaxW = 0.0;
        protected double dMaxH = 0.0;
        protected List<LegendItemHints> columnList = new ArrayList<LegendItemHints>();
        protected List<LegendItemHints> gnList = new ArrayList<LegendItemHints>();
        private SeriesDefinition sed = null;

        public static ContentPlacer newInstance(LegendData legendData) throws ChartException {
            Orientation orientation = legendData.lg.getOrientation();
            if (orientation.getValue() == 1) {
                return new VerticalPlacer(legendData);
            }
            if (orientation.getValue() == 0) {
                return new HorizontalPlacer(legendData);
            }
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.illegal.rendering.orientation", new Object[]{orientation}, Messages.getResourceBundle(legendData.rtc.getULocale()));
        }

        protected ContentPlacer(LegendData lgData) {
            this.lgData = lgData;
            this.bCategory = lgData.lg.getItemType().getValue() == 1;
            this.bIsShowValue = !this.bCategory && lgData.lg.isShowValue();
            this.bIsLeftRight = lgData.lg.getDirection().getValue() == 0;
            this.laiItem = new LabelItem(lgData.xs, lgData.rtc, lgData.la, lgData.maxWrappingSize);
            if (!this.bCategory) {
                this.dSepThick = lgData.dSeparatorThickness + (this.bIsLeftRight ? lgData.dHorizontalSpacing : lgData.dVerticalSpacing);
            }
        }

        public void dispose() {
            if (this.laiItem != null) {
                this.laiItem.dispose();
            }
            if (this.laiValue != null) {
                this.laiValue.dispose();
            }
        }

        public abstract boolean placeContent(LegendItemHints var1) throws ChartException;

        public abstract void finishPlacing();

        public abstract double[] getSize();

        protected Point computeContentSize(LegendItemHints lih) throws ChartException {
            Point size = null;
            if (lih.getType() == LegendItemHints.Type.LG_GROUPNAME) {
                this.laiItem.setText(lih.getItemText());
                double[] dsize = LegendBuilder.getItemSizeGN(this.laiItem, this.lgData, this.dX);
                size = new Point(dsize[0], dsize[1]);
            } else if (lih.getType() == LegendItemHints.Type.LG_ENTRY || lih.getType() == LegendItemHints.Type.LG_MINSLICE) {
                this.laiItem.setText(lih.getItemText());
                if (this.bIsShowValue) {
                    this.checkValueLabel(lih);
                    this.laiValue.setText(lih.getValueText());
                }
                double[] dsize = LegendBuilder.getItemSize(this.laiItem, this.laiValue, this.bIsShowValue, this.lgData, this.dX);
                size = new Point(dsize[0], dsize[1]);
            }
            return size;
        }

        private void checkValueLabel(LegendItemHints lih) {
            if (this.sed != lih.getSeriesDefinition()) {
                if (this.laiValue != null) {
                    this.laiValue.dispose();
                }
                Series series = (Series)lih.getSeriesDefinition().getSeries().get(0);
                Label laValue = LabelImpl.copyInstance(series.getLabel());
                laValue.setEllipsis(1);
                this.laiValue = new LabelItem(this.lgData.xs, this.lgData.rtc, laValue, this.lgData.maxWrappingSize);
            }
        }

        protected static boolean hasPlaceForOneItem(Point itemSize, LegendData legendData) {
            return itemSize.getX() <= legendData.dAvailableWidth && itemSize.getY() <= legendData.dAvailableHeight;
        }
    }

    private static abstract class ContentProvider {
        private ChartUtil.CacheDecimalFormat dfCache = new ChartUtil.CacheDecimalFormat();
        protected final LegendData lgData;
        protected final boolean bNeedInvert;
        protected FormatSpecifier fs = null;

        protected ContentProvider(LegendData lgData) {
            this.lgData = lgData;
            this.bNeedInvert = ContentProvider.needInvert(lgData.bPaletteByCategory, lgData.cm, lgData.seda);
        }

        public static ContentProvider newInstance(LegendData lgData) throws ChartException {
            LegendItemType itemType = lgData.lg.getItemType();
            if (itemType.getValue() == 1) {
                return new CategoryContentProvider(lgData);
            }
            if (itemType.getValue() == 0) {
                return new ValueContentProvider(lgData);
            }
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.illegal.rendering.legend.itemtype", new Object[]{itemType}, Messages.getResourceBundle(lgData.rtc.getULocale()));
        }

        public abstract LegendItemHints nextContent() throws ChartException;

        protected String format(Object oText) throws ChartException {
            DecimalFormat df = null;
            if (this.fs == null && oText instanceof Number) {
                String sPattern = ValueFormatter.getNumericPattern(((Number)oText).doubleValue());
                df = (DecimalFormat)this.dfCache.get(sPattern);
            }
            try {
                return ValueFormatter.format(oText, this.fs, this.lgData.rtc.getULocale(), df);
            }
            catch (ChartException chartException) {
                return oText.toString();
            }
        }

        private static boolean needInvert(boolean bPaletteByCategory, Chart cm, SeriesDefinition[] seda) {
            boolean bNeedInvert = false;
            if (!(cm instanceof ChartWithAxes)) {
                return false;
            }
            boolean bIsStacked = LegendBuilder.isStacked(seda);
            boolean bIsFliped = ((ChartWithAxes)cm).isTransposed();
            bNeedInvert = bPaletteByCategory ? bIsFliped : bIsStacked && !bIsFliped || !bIsStacked && bIsFliped;
            return bNeedInvert;
        }
    }

    private static class HorizontalPlacer
    extends ContentPlacer {
        public HorizontalPlacer(LegendData legendData) {
            super(legendData);
        }

        public void finishPlacing() {
            this.flushColumnList();
        }

        public double[] getSize() {
            double dHeight = this.bIsLeftRight ? this.dMaxH + this.dY : this.dY;
            double dWidth = Math.max(this.dMaxW, this.dX);
            return new double[]{dWidth, dHeight};
        }

        public boolean placeContent(LegendItemHints lih) throws ChartException {
            if (lih.getType() == LegendItemHints.Type.LG_SEPERATOR) {
                if (this.bIsLeftRight) {
                    this.dX += this.dSepThick;
                    lih.left(this.dX - this.dSepThick * 0.5);
                    lih.top(this.dY);
                    lih.itemHeight(this.dMaxH - this.lgData.dVerticalSpacing);
                } else {
                    this.flushColumnList();
                    this.dY += this.dSepThick;
                    lih.top(this.dY - this.dSepThick * 0.5);
                    lih.width(this.dMaxW);
                }
                this.columnList.add(lih);
                return true;
            }
            Point size = this.computeContentSize(lih);
            return this.placeContentWithSize(lih, size);
        }

        private boolean placeContentWithSize(LegendItemHints lih, Point size) throws ChartException {
            if (!HorizontalPlacer.hasPlaceForOneItem(size, this.lgData)) {
                return false;
            }
            if (this.dY + size.getY() > this.lgData.dAvailableHeight + this.lgData.dSafeSpacing) {
                this.columnList.clear();
                return false;
            }
            if (this.dX + size.getX() > this.lgData.dAvailableWidth + this.lgData.dSafeSpacing) {
                this.flushColumnList();
                size = this.computeContentSize(lih);
                return this.placeContentWithSize(lih, size);
            }
            this.dMaxH = Math.max(size.getY(), this.dMaxH);
            this.dX += size.getX();
            lih.validItemLen(this.laiItem.getValidTextLen());
            lih.left(this.dX - size.getX());
            lih.top(this.dY);
            if (lih.getType() == LegendItemHints.Type.LG_GROUPNAME) {
                this.gnList.add(lih);
                lih.width(size.getX());
                lih.itemHeight(size.getY() - this.lgData.dVerticalSpacing);
            } else {
                lih.width(size.getX() - this.lgData.dHorizonalReservedSpace);
                lih.itemHeight(this.laiItem.getHeight());
                if (this.bIsShowValue) {
                    lih.valueHeight(this.laiValue.getHeight());
                    lih.validValueLen(this.laiValue.getValidTextLen());
                }
            }
            this.columnList.add(lih);
            return true;
        }

        private void flushColumnList() {
            if (this.columnList.size() > 0) {
                this.lgData.legendItems.addAll(this.columnList);
                this.processColumnList();
                this.columnList.clear();
                this.dMaxW = Math.max(this.dMaxW, this.dX);
                this.dY += this.dMaxH;
                this.dMaxH = 0.0;
                this.dX = 0.0;
            }
        }

        private void processColumnList() {
            for (LegendItemHints lih : this.gnList) {
                lih.itemHeight(this.dMaxH);
            }
            this.gnList.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InvertibleIterator<T>
    implements Iterator<T> {
        private boolean isInverse_ = false;
        private ListIterator<T> lit_ = null;
        private int index_ = -1;

        public InvertibleIterator(List<T> tList, boolean isInverse, int index) {
            this.lit_ = tList.listIterator(index);
            this.isInverse_ = isInverse;
            this.index_ = isInverse ? this.lit_.previousIndex() : this.lit_.nextIndex();
        }

        public InvertibleIterator(List<T> tList, boolean isInverse) {
            this(tList, isInverse, isInverse ? tList.size() : 0);
        }

        @Override
        public boolean hasNext() {
            return this.isInverse_ ? this.lit_.hasPrevious() : this.lit_.hasNext();
        }

        @Override
        public final T next() throws NoSuchElementException {
            if (this.isInverse_) {
                this.index_ = this.lit_.previousIndex();
                return this.lit_.previous();
            }
            this.index_ = this.lit_.nextIndex();
            return this.lit_.next();
        }

        @Override
        public void remove() {
        }

        public int getIndex() {
            return this.index_;
        }

        public boolean getInverse() {
            return this.isInverse_;
        }

        public void setInverse(boolean isInverse) {
            this.isInverse_ = isInverse;
        }
    }

    public static class LabelItem
    implements EllipsisHelper.ITester {
        private final IDisplayServer xs;
        private final RunTimeContext rtc;
        private final double maxWrappingSize;
        private final Label la;
        private final Double fontHeight;
        private String text;
        private double dEllipsisWidth;
        private BoundingBox bb = null;
        private EllipsisHelper eHelper = null;
        private int iValidLen = 0;

        public LabelItem(IDisplayServer xs, RunTimeContext rtc, Label la, double maxWrappingSize) {
            this.xs = xs;
            this.rtc = rtc;
            this.la = la;
            this.maxWrappingSize = maxWrappingSize;
            ITextMetrics itm = xs.getTextMetrics(la);
            this.updateEllipsisWidth(itm);
            this.fontHeight = itm.getHeight();
            itm.dispose();
            this.eHelper = new EllipsisHelper(this, la.getEllipsis());
        }

        public LabelItem(IDisplayServer xs, RunTimeContext rtc, Label la) {
            this(xs, rtc, la, 0.0);
        }

        public static LabelItem copyOf(LabelItem original) {
            return new LabelItem(original.xs, original.rtc, LabelImpl.copyInstance(original.la), original.maxWrappingSize);
        }

        public void dispose() {
        }

        public void setText(String sText) throws ChartException {
            this.text = sText;
            this.updateLabel(sText);
        }

        public String getFullText() {
            return this.text;
        }

        public int getValidTextLen() {
            return this.iValidLen;
        }

        public boolean testLabelVisible(String strNew, Object oPara) throws ChartException {
            double dWidthLimit = (Double)oPara;
            this.updateLabel(strNew);
            return this.getWidth() <= dWidthLimit;
        }

        public boolean checkEllipsis(double dWidthLimit) throws ChartException {
            if (dWidthLimit < this.dEllipsisWidth) {
                this.iValidLen = 0;
                return false;
            }
            double dWidth = this.getWidth();
            if (dWidth <= dWidthLimit) {
                this.iValidLen = 0;
                return true;
            }
            boolean rst = this.eHelper.checkLabelEllipsis(this.text, new Double(dWidthLimit));
            if (!rst) {
                this.updateLabel(this.text);
            }
            this.iValidLen = this.eHelper.getVisibleCharCount();
            return rst;
        }

        public double getWidth() throws ChartException {
            return this.bb.getWidth();
        }

        public double getHeight() throws ChartException {
            return this.bb.getHeight();
        }

        public String getCaption() {
            return this.la.getCaption().getValue();
        }

        private void updateLabel(String strText) throws ChartException {
            this.la.getCaption().setValue(strText);
            this.bb = Methods.computeLabelSize(this.xs, this.la, this.maxWrappingSize, this.fontHeight);
        }

        private void updateEllipsisWidth(ITextMetrics itm) {
            this.la.getCaption().setValue("...");
            itm.reuse(this.la);
            this.dEllipsisWidth = itm.getFullWidth();
        }
    }

    private class LegendData {
        private final IDisplayServer xs;
        private final Chart cm;
        private final Legend lg;
        private final SeriesDefinition[] seda;
        private final RunTimeContext rtc;
        private final boolean bPaletteByCategory;
        private final double dItemHeight;
        private final Label la;
        private final double dSeparatorThickness;
        private final double dScale;
        private final Insets insCa;
        private final double maxWrappingSize;
        private final double dHorizontalSpacing;
        private final double dVerticalSpacing;
        private final double dSafeSpacing;
        private final double dHorizonalReservedSpace;
        private final double dShadowness;
        private boolean bMinSliceApplied;
        private Collection<Integer> filteredMinSliceEntry = Collections.emptySet();
        private double dAvailableWidth;
        private double dAvailableHeight;
        private List<LegendItemHints> legendItems = new ArrayList<LegendItemHints>();
        private String sMinSliceLabel;
        private Label laTitle;

        public LegendData(IDisplayServer xs, Chart cm, SeriesDefinition[] seda, RunTimeContext rtc) {
            this.xs = xs;
            this.cm = cm;
            this.lg = cm.getLegend();
            this.seda = seda;
            this.rtc = rtc;
            this.bPaletteByCategory = this.lg.getItemType().getValue() == 1;
            this.la = LabelImpl.create();
            this.la.setEllipsis(1);
            this.la.setCaption(TextImpl.copyInstance(this.lg.getText()));
            this.la.getCaption().setValue("X");
            ITextMetrics itm = xs.getTextMetrics(this.la);
            this.dItemHeight = itm.getFullHeight();
            itm.dispose();
            ClientArea ca = this.lg.getClientArea();
            this.dSeparatorThickness = this.lg.getSeparator() != null ? this.lg.getSeparator().getThickness() : ca.getOutline().getThickness();
            this.dScale = (double)xs.getDpiResolution() / 72.0;
            this.insCa = ca.getInsets().scaledInstance(this.dScale);
            this.maxWrappingSize = this.lg.getWrappingSize() * this.dScale;
            this.dHorizontalSpacing = 3.0 * this.dScale;
            this.dVerticalSpacing = 3.0 * this.dScale;
            this.dSafeSpacing = 3.0 * this.dScale;
            this.dShadowness = 3.0 * this.dScale;
            this.dHorizonalReservedSpace = this.insCa.getLeft() + this.insCa.getRight() + 1.5 * this.dItemHeight + this.dHorizontalSpacing;
        }
    }

    private static class ValueContentProvider
    extends ContentProvider {
        private final boolean bShowValue;
        private final boolean bSeparator;
        private List<SeriesDefinition> alSed = null;
        private Iterator<SeriesDefinition> itSed = null;
        private List<Series> alSeries = null;
        private InvertibleIterator<Series> itSeries = null;
        private SeriesDefinition sed = null;
        private SeriesNameFormat snFormat = SeriesNameFormat.DEFAULT_FORMAT;
        private Status status;

        protected ValueContentProvider(LegendData lgData) {
            super(lgData);
            Legend lg = lgData.cm.getLegend();
            this.bSeparator = lg.getSeparator() == null || lg.getSeparator().isVisible();
            this.alSed = Arrays.asList(lgData.seda);
            this.bShowValue = lg.isShowValue();
            this.itSed = new InvertibleIterator<SeriesDefinition>(this.alSed, this.bNeedInvert);
            this.status = Status.WAIT_SD;
        }

        public LegendItemHints nextContent() throws ChartException {
            switch (this.status) {
                case WAIT_SD: {
                    return this.visitSed();
                }
                case WAIT_SERIES: {
                    return this.visitSeries();
                }
            }
            return null;
        }

        private LegendItemHints visitSed() throws ChartException {
            if (this.itSed.hasNext()) {
                this.sed = this.itSed.next();
                this.snFormat = SeriesNameFormat.getSeriesNameFormat(this.sed, this.lgData.rtc.getULocale());
                this.alSeries = this.sed.getRunTimeSeries();
                this.itSeries = new InvertibleIterator<Series>(this.alSeries, this.bNeedInvert);
                this.fs = this.sed.getFormatSpecifier();
                this.status = Status.WAIT_SERIES;
                if (this.needToShowGroupName(this.sed)) {
                    return LegendItemHints.newGroupNameEntry(this.getGroupName(this.sed));
                }
                return this.visitSeries();
            }
            return null;
        }

        private LegendItemHints visitSeries() throws ChartException {
            if (this.itSeries.hasNext()) {
                Series se = this.itSeries.next();
                String sItem = this.formatItemText(se.getSeriesIdentifier());
                String sValue = this.bShowValue ? LegendBuilder.getValueText(this.lgData.cm, se) : null;
                return LegendItemHints.newEntry(sItem, sValue, this.sed, se, this.itSeries.getIndex());
            }
            this.status = Status.WAIT_SD;
            if (this.bSeparator && this.alSeries.size() > 0 && this.itSed.hasNext()) {
                return LegendItemHints.createSeperator();
            }
            return this.visitSed();
        }

        private String formatItemText(Object oText) throws ChartException {
            String str = this.snFormat != SeriesNameFormat.DEFAULT_FORMAT ? this.snFormat.format(oText) : this.format(oText);
            return this.lgData.rtc.externalizedMessage(str);
        }

        private boolean needToShowGroupName(SeriesDefinition sed) {
            if (this.alSed == null || this.alSed.size() <= 1 || sed.getQuery() == null || sed.getQuery().getDefinition() == null || sed.getQuery().getDefinition().trim() == "") {
                return false;
            }
            List<Series> alRun = sed.getRunTimeSeries();
            if (alRun.size() < 1) {
                return false;
            }
            Series seDesign = sed.getDesignTimeSeries();
            Series seRun = alRun.get(0);
            if (seDesign == null || alRun.size() > 1) {
                return true;
            }
            return !seDesign.getSeriesIdentifier().equals(seRun.getSeriesIdentifier());
        }

        private String getGroupName(SeriesDefinition sed) throws ChartException {
            String sGN = "";
            Series seDesign = sed.getDesignTimeSeries();
            if (seDesign != null) {
                sGN = this.formatItemText(seDesign.getSeriesIdentifier());
            }
            return sGN;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Status {
            WAIT_SD,
            WAIT_SERIES;

        }
    }

    private static class VerticalPlacer
    extends ContentPlacer {
        public VerticalPlacer(LegendData legendData) {
            super(legendData);
        }

        public boolean placeContent(LegendItemHints lih) throws ChartException {
            if (lih.getType() == LegendItemHints.Type.LG_SEPERATOR) {
                if (this.bIsLeftRight) {
                    this.flushColumnList();
                    this.dX += this.dSepThick;
                    lih.left(this.dX - this.dSepThick * 0.5);
                    lih.itemHeight(this.dMaxH);
                } else {
                    this.dY += this.dSepThick;
                    lih.left(this.dX);
                    lih.top(this.dY - this.dSepThick * 0.5);
                    lih.width(this.dMaxW - this.lgData.dHorizontalSpacing);
                }
                this.columnList.add(lih);
                return true;
            }
            Point size = this.computeContentSize(lih);
            return this.placeContentWithSize(lih, size);
        }

        private void flushColumnList() {
            if (this.columnList.size() > 0) {
                this.lgData.legendItems.addAll(this.columnList);
                this.columnList.clear();
                this.dMaxH = Math.max(this.dMaxH, this.dY);
                this.dX += this.dMaxW;
                this.dY = 0.0;
                this.dMaxW = 0.0;
            }
        }

        public void finishPlacing() {
            this.flushColumnList();
        }

        private boolean placeContentWithSize(LegendItemHints lih, Point size) throws ChartException {
            if (!VerticalPlacer.hasPlaceForOneItem(size, this.lgData)) {
                return false;
            }
            if (this.dX + size.getX() > this.lgData.dAvailableWidth + this.lgData.dSafeSpacing) {
                this.columnList.clear();
                return false;
            }
            if (this.dY + size.getY() > this.lgData.dAvailableHeight + this.lgData.dSafeSpacing) {
                this.flushColumnList();
                return this.placeContentWithSize(lih, size);
            }
            this.dMaxW = Math.max(size.getX(), this.dMaxW);
            this.dY += size.getY();
            lih.validItemLen(this.laiItem.getValidTextLen());
            lih.left(this.dX);
            lih.itemHeight(this.laiItem.getHeight());
            if (lih.getType() == LegendItemHints.Type.LG_GROUPNAME) {
                this.gnList.add(lih);
                lih.top(this.dY - size.getY() + this.lgData.insCa.getTop());
                lih.width(size.getX());
            } else {
                lih.top(this.dY - size.getY());
                lih.width(size.getX() - this.lgData.dHorizonalReservedSpace);
                if (this.bIsShowValue) {
                    lih.valueHeight(this.laiValue.getHeight()).validValueLen(this.laiValue.getValidTextLen());
                }
            }
            this.columnList.add(lih);
            return true;
        }

        public double[] getSize() {
            double dWidth = this.dX;
            double dHeight = Math.max(this.dMaxH, this.dY);
            return new double[]{dWidth, dHeight};
        }
    }
}

