/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import java.util.Date;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;

public class ScaleContext
extends Methods {
    private Object oMinAuto;
    private Object oMaxAuto;
    private Object oMinFixed;
    private Object oMaxFixed;
    private Integer oStepNumber;
    private final int iMarginPercent;
    private final int iType;
    private int iUnit;
    private Object oMin;
    private Object oMax;
    private Object oStep;
    private boolean bMinimumFixed = false;
    private boolean bMaximumFixed = false;
    private boolean bStepFixed = false;
    private boolean bMargin = false;
    private boolean bShared = false;

    public ScaleContext(int iMarginPercent, int iType, int iUnit, Object oMinValue, Object oMaxValue, Object oStep) {
        this.iMarginPercent = iMarginPercent;
        this.iType = iType;
        this.iUnit = iUnit;
        this.oMinAuto = oMinValue;
        this.oMaxAuto = oMaxValue;
        this.oStep = oStep;
        this.bMargin = iMarginPercent > 0;
    }

    public ScaleContext(int iMarginPercent, int iType, Object oMinAuto, Object oMaxAuto, Object oStep) {
        this(iMarginPercent, iType, 0, oMinAuto, oMaxAuto, oStep);
    }

    public void updateShared(ScaleContext that) {
        this.iUnit = that.iUnit;
        this.oStep = that.oStep;
    }

    public static ScaleContext createSimpleScale(Object oMin, Object oMax) {
        ScaleContext scale = new ScaleContext(0, 0, oMin, oMax, null);
        if (oMin instanceof Date) {
            scale.oMin = new CDateTime((Date)oMin);
            scale.oMax = new CDateTime((Date)oMax);
        } else {
            scale.oMin = oMin;
            scale.oMax = oMax;
        }
        return scale;
    }

    public void setFixedValue(boolean bMinimumFixed, boolean bMaximumFixed, Object oMinFixed, Object oMaxFixed) {
        this.oMinFixed = oMinFixed;
        this.oMaxFixed = oMaxFixed;
        this.bMinimumFixed = bMinimumFixed;
        this.bMaximumFixed = bMaximumFixed;
        this.oMin = oMinFixed;
        this.oMax = oMaxFixed;
    }

    public void setFixedStep(boolean bStepFixed, Integer oStepNumber) {
        this.oStepNumber = oStepNumber;
        this.bStepFixed = bStepFixed || oStepNumber != null;
    }

    public Object getMin() {
        return this.oMin;
    }

    public Object getMax() {
        return this.oMax;
    }

    public Object getMinWithMargin() {
        return this.oMinAuto;
    }

    public Object getMaxWithMargin() {
        return this.oMaxAuto;
    }

    public Object getStep() {
        return this.oStep;
    }

    public void computeMinMax() {
        if ((this.iType & 2) == 2) {
            this.computeLinearMinMax();
        } else if ((this.iType & 8) == 8) {
            this.computeDateTimeMinMax();
        } else if ((this.iType & 4) == 4) {
            this.computeLogMinMax();
        }
    }

    private void computeLinearMinMax() {
        double dMargin = 0.0;
        if (this.bMargin) {
            dMargin = Math.abs(ScaleContext.asDouble(this.oMaxAuto) - ScaleContext.asDouble(this.oMinAuto)) * (double)this.iMarginPercent / 100.0;
        }
        double dMinReal = ScaleContext.asDouble(this.oMinAuto) - dMargin;
        double dMaxReal = ScaleContext.asDouble(this.oMaxAuto) + dMargin;
        double dMinValue = this.bMinimumFixed ? ScaleContext.asDouble(this.oMinFixed) : dMinReal;
        double dMaxValue = this.bMaximumFixed ? ScaleContext.asDouble(this.oMaxFixed) : dMaxReal;
        double dMinAxis = dMinValue;
        double dMaxAxis = dMaxValue;
        double dStep = 0.0;
        if (this.bStepFixed && this.oStepNumber != null) {
            this.oStep = new Double(Math.abs(dMaxValue - dMinValue) / (double)this.oStepNumber.intValue());
            dStep = ScaleContext.asDouble(this.oStep);
        } else {
            dStep = ScaleContext.asDouble(this.oStep);
            if (this.bMargin) {
                dMinAxis = (dStep >= 1.0 ? Math.floor(dMinAxis / dStep) : (double)Math.round(dMinAxis / dStep)) * dStep;
                dMaxAxis = ((dStep >= 1.0 ? Math.floor(dMaxAxis / dStep) : (double)Math.round(dMaxAxis / dStep)) + 1.0) * dStep;
                if (dMaxAxis - dMaxValue >= dStep) {
                    dMaxAxis -= dStep;
                }
            } else {
                double dAbsMax = Math.abs(dMaxValue);
                double dAbsMin = Math.abs(dMinValue);
                dMinAxis = (dStep > 1.0 ? Math.floor(dAbsMin / dStep) : (double)Math.round(dAbsMin / dStep)) * dStep;
                dMaxAxis = (dStep > 1.0 ? Math.floor(dAbsMax / dStep) : (double)Math.round(dAbsMax / dStep)) * dStep;
                if (dMinAxis == dAbsMin) {
                    dMinAxis += dStep;
                    if (dMinValue < 0.0) {
                        dMinAxis = -dMinAxis;
                    } else if (dMinValue == 0.0) {
                        dMinAxis = 0.0;
                    }
                } else if (dMinValue < 0.0) {
                    dMinAxis = -(dMinAxis + dStep);
                } else if (dMinAxis >= dMinValue && dMinAxis != 0.0) {
                    dMinAxis -= dStep;
                }
                if (dMaxAxis == dAbsMax) {
                    dMaxAxis += dStep;
                    if (dMaxValue < 0.0) {
                        dMaxAxis = -dMaxAxis;
                    } else if (dMaxValue == 0.0) {
                        dMaxAxis = 0.0;
                    }
                } else if (dMinAxis != dMaxValue) {
                    if (dMaxValue < 0.0) {
                        dMaxAxis = -(dMaxAxis - dStep);
                    } else if (dMaxValue > 0.0 && dMaxAxis < dMaxValue) {
                        dMaxAxis += dStep;
                    }
                }
                if (dMinValue < 0.0 && dMaxValue < 0.0 && dMaxAxis <= dMaxValue - dStep) {
                    dMaxAxis += 2.0 * dStep;
                }
                if (dMinValue > 0.0 && dMaxValue > 0.0 && dMinAxis >= dMinValue + dStep) {
                    dMinAxis -= 2.0 * dStep;
                }
            }
        }
        if (dMinValue == 0.0 && dMaxValue == 0.0) {
            if (dMinAxis >= 0.0) {
                dMinAxis = -1.0;
            }
            if (dMaxAxis <= 0.0) {
                dMaxAxis = 1.0;
            }
        }
        if ((this.iType & 0x20) == 32) {
            if (dMaxAxis > 0.0) {
                dMaxAxis = 100.0;
            }
            if (dMinAxis < 0.0) {
                dMinAxis = -100.0;
            }
        }
        if (!this.bMaximumFixed) {
            this.oMax = new Double(dMaxAxis);
        }
        if (!this.bMinimumFixed) {
            this.oMin = new Double(dMinAxis);
        }
        if (this.bMargin) {
            this.oMinAuto = this.bMinimumFixed && dMinValue > dMinReal ? new Double(dMinReal) : null;
            this.oMaxAuto = this.bMaximumFixed && dMaxValue < dMaxReal ? new Double(dMaxReal) : null;
        } else {
            this.oMinAuto = null;
            this.oMaxAuto = null;
        }
    }

    private void computeDateTimeMinMax() {
        CDateTime cdtMaxValue;
        int iStep = ScaleContext.asInteger(this.oStep);
        CDateTime cdtMinValue = this.bMinimumFixed ? ScaleContext.asDateTime(this.oMinFixed) : ScaleContext.asDateTime(this.oMinAuto);
        CDateTime cDateTime = cdtMaxValue = this.bMaximumFixed ? ScaleContext.asDateTime(this.oMaxFixed) : ScaleContext.asDateTime(this.oMaxAuto);
        if (this.bMaximumFixed && !this.bMinimumFixed) {
            this.oMax = cdtMaxValue;
            double diff = CDateTime.computeDifference(cdtMaxValue, cdtMinValue, this.iUnit) / (double)iStep;
            int count = (int)diff * iStep;
            if (!ChartUtil.mathEqual(diff, Math.floor(diff))) {
                count += iStep;
            }
            CDateTime cdtMinValue_new = (CDateTime)((Object)cdtMaxValue.clone());
            cdtMinValue_new.add(this.iUnit, -count);
            this.oMin = cdtMinValue_new;
        } else {
            if (!this.bMinimumFixed) {
                cdtMinValue = cdtMinValue.backward(this.iUnit, iStep);
                cdtMinValue.clearBelow(this.iUnit);
                if (!this.bMaximumFixed) {
                    cdtMaxValue = cdtMaxValue.forward(this.iUnit, 1);
                    cdtMaxValue.clearBelow(this.iUnit);
                }
            }
            this.oMin = cdtMinValue;
            double diff = CDateTime.computeDifference(cdtMaxValue, cdtMinValue, this.iUnit) / (double)iStep;
            int count = (int)diff * iStep;
            if (!ChartUtil.mathEqual(diff, Math.floor(diff))) {
                count += iStep;
            }
            CDateTime cdtMaxValue_new = (CDateTime)((Object)cdtMinValue.clone());
            cdtMaxValue_new.add(this.iUnit, count);
            this.oMax = cdtMaxValue_new;
        }
        this.oMinAuto = null;
        this.oMaxAuto = null;
    }

    private void computeLogMinMax() {
        double dMinValue = ScaleContext.asDouble(this.oMinAuto);
        double dMaxValue = ScaleContext.asDouble(this.oMaxAuto);
        double dAbsMax = Math.abs(dMaxValue);
        double dAbsMin = Math.abs(dMinValue);
        double dStep = ScaleContext.asDouble(this.oStep);
        double dStepLog = Math.log(dStep);
        int iPow = (int)Math.floor(Math.log(dAbsMax) / dStepLog) + 1;
        double dMaxAxis = Math.pow(dStep, iPow);
        iPow = (int)Math.floor(Math.log(dAbsMin) / dStepLog) - 1;
        double dMinAxis = Math.pow(dStep, iPow + 1);
        if (!this.bMaximumFixed) {
            this.oMax = new Double(dMaxAxis);
        }
        if (!this.bMinimumFixed) {
            this.oMin = new Double(dMinAxis);
        }
        this.oMinAuto = null;
        this.oMaxAuto = null;
    }

    public void setShared(boolean bShared) {
        this.bShared = bShared;
    }

    public boolean isShared() {
        return this.bShared;
    }

    public int getUnit() {
        return this.iUnit;
    }
}

