/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;

public class ArchiveEntryOutputStream
extends RAOutputStream {
    protected ArchiveWriter writer;
    protected ArchiveEntry entry;
    protected byte[] buffer;
    protected int buffer_offset;
    protected int buffer_size;
    private long offset;

    ArchiveEntryOutputStream(ArchiveWriter writer, ArchiveEntry entry) {
        this.writer = writer;
        this.entry = entry;
        this.offset = 0L;
        this.buffer_offset = 0;
        this.buffer_size = 4096;
        this.buffer = new byte[4096];
    }

    public long getOffset() throws IOException {
        return this.offset + (long)this.buffer_offset;
    }

    public void seek(long localPos) throws IOException {
        if (localPos < 0L) {
            throw new IOException("Invalid seek offset " + localPos);
        }
        if (localPos > this.entry.getLength()) {
            this.entry.setLength(localPos);
        }
        if (this.offset + (long)this.buffer_offset != localPos) {
            this.flushBuffer();
            this.offset = localPos;
        }
    }

    public void write(int b) throws IOException {
        if (this.buffer_offset >= this.buffer_size) {
            this.flushBuffer();
        }
        this.buffer[this.buffer_offset] = (byte)b;
        ++this.buffer_offset;
    }

    public void writeInt(int value) throws IOException {
        if (this.buffer_offset + 4 >= this.buffer_size) {
            this.flushBuffer();
        }
        ArchiveUtil.integerToBytes(value, this.buffer, this.buffer_offset);
        this.buffer_offset += 4;
    }

    public void writeLong(long value) throws IOException {
        if (this.buffer_offset + 8 >= this.buffer_size) {
            this.flushBuffer();
        }
        ArchiveUtil.longToBytes(value, this.buffer, this.buffer_offset);
        this.buffer_offset += 8;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buffer_offset + len <= this.buffer_size) {
            System.arraycopy(b, off, this.buffer, this.buffer_offset, len);
            this.buffer_offset += len;
            return;
        }
        this.flushBuffer();
        this.entry.write(this.offset, b, off, len);
        this.offset += (long)len;
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.entry.flush();
        super.flush();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        this.writer.unregisterStream(this);
        try {
            this.flush();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.close();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.close();
    }

    private void flushBuffer() throws IOException {
        if (this.buffer_offset != 0) {
            this.entry.write(this.offset, this.buffer, 0, this.buffer_offset);
            this.offset += (long)this.buffer_offset;
            this.buffer_offset = 0;
        }
    }

    public long length() throws IOException {
        long length = this.entry.getLength();
        long offset = this.getOffset();
        if (offset > length) {
            return offset;
        }
        return length;
    }
}

