/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.format;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.sql.Time;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DateFormatter {
    private static final String UNFORMATTED = "Unformatted";
    public static final String DATETIME_UNFORMATTED = "DateTimeUnformatted";
    public static final String DATE_UNFORMATTED = "DateUnformatted";
    public static final String TIME_UNFORMATTED = "TimeUnformatted";
    private String formatPattern;
    DateFormat dateTimeFormat;
    DateFormat timeFormat;
    DateFormat dateFormat;
    private ULocale locale = ULocale.getDefault();
    protected static Logger logger;
    protected static final int LOCALE_CACHE_SIZE = 10;
    protected static final int PATTERN_CACHE_SIZE = 20;
    static CacheHashMap localeCache;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.core.format.DateFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        localeCache = new CacheHashMap(10);
    }

    protected static synchronized void putCachedFormat(ULocale locale, String pattern, DateFormat[] formats) {
        Map map = (Map)localeCache.get(locale);
        if (map == null) {
            map = new CacheHashMap(20);
            localeCache.put(locale, map);
        }
        map.put(pattern, formats);
    }

    protected static synchronized DateFormat[] getCachedFormat(ULocale locale, String pattern) {
        Map map = (Map)localeCache.get(locale);
        if (map == null && map == null) {
            map = new CacheHashMap(20);
            localeCache.put(locale, map);
        }
        return (DateFormat[])map.get(pattern);
    }

    public DateFormatter() {
        this.applyPattern(null);
    }

    public DateFormatter(String pattern) {
        this.applyPattern(pattern);
    }

    public DateFormatter(ULocale localeLoc) {
        if (localeLoc != null) {
            this.locale = localeLoc;
        }
        this.applyPattern(null);
    }

    public DateFormatter(Locale localeLoc) {
        this(ULocale.forLocale((Locale)localeLoc));
    }

    public DateFormatter(String pattern, ULocale localeLoc) {
        if (localeLoc != null) {
            this.locale = localeLoc;
        }
        this.applyPattern(pattern);
    }

    public DateFormatter(String pattern, Locale localeLoc) {
        this(pattern, ULocale.forLocale((Locale)localeLoc));
    }

    public String getPattern() {
        return this.formatPattern;
    }

    public void applyPattern(String formatString) {
        DateFormat[] formats;
        this.formatPattern = formatString;
        this.dateTimeFormat = null;
        this.dateFormat = null;
        this.timeFormat = null;
        if (formatString == null || UNFORMATTED.equals(formatString)) {
            this.formatPattern = UNFORMATTED;
        }
        if ((formats = DateFormatter.getCachedFormat(this.locale, formatString)) != null) {
            this.dateTimeFormat = formats[0];
            this.dateFormat = formats[1];
            this.timeFormat = formats[2];
        } else {
            this.doApplyPattern(this.formatPattern);
            formats = new DateFormat[]{this.dateTimeFormat, this.dateFormat, this.timeFormat};
            DateFormatter.putCachedFormat(this.locale, formatString, formats);
        }
    }

    protected void doApplyPattern(String formatString) {
        try {
            if (UNFORMATTED == formatString) {
                this.dateTimeFormat = DateFormat.getDateTimeInstance((int)2, (int)3, (ULocale)this.locale);
                this.dateFormat = DateFormat.getDateInstance((int)2, (ULocale)this.locale);
                this.timeFormat = DateFormat.getTimeInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.equals(DATETIME_UNFORMATTED)) {
                this.dateTimeFormat = DateFormat.getDateTimeInstance((int)2, (int)3, (ULocale)this.locale);
                return;
            }
            if (formatString.equals(DATE_UNFORMATTED)) {
                this.dateTimeFormat = DateFormat.getDateInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.equals(TIME_UNFORMATTED)) {
                this.dateTimeFormat = DateFormat.getTimeInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.length() == 1) {
                char patternTemp = formatString.charAt(0);
                switch (patternTemp) {
                    case 'G': {
                        this.dateTimeFormat = DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
                        this.dateFormat = DateFormat.getDateInstance((int)1, (ULocale)this.locale);
                        this.timeFormat = DateFormat.getTimeInstance((int)1, (ULocale)this.locale);
                        return;
                    }
                    case 'D': {
                        this.dateTimeFormat = DateFormat.getDateInstance((int)1, (ULocale)this.locale);
                        return;
                    }
                    case 'd': {
                        this.dateTimeFormat = DateFormat.getDateInstance((int)3, (ULocale)this.locale);
                        return;
                    }
                    case 'T': {
                        this.dateTimeFormat = DateFormat.getTimeInstance((int)1, (ULocale)this.locale);
                        return;
                    }
                    case 't': {
                        this.dateTimeFormat = new SimpleDateFormat("HH:mm", this.locale);
                        return;
                    }
                    case 'f': {
                        this.dateTimeFormat = DateFormat.getDateTimeInstance((int)1, (int)3, (ULocale)this.locale);
                        return;
                    }
                    case 'F': {
                        this.dateTimeFormat = DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
                        return;
                    }
                    case 'I': 
                    case 'i': {
                        int timeForm = patternTemp == 'i' ? 2 : 1;
                        this.timeFormat = DateFormat.getTimeInstance((int)timeForm, (ULocale)this.locale);
                        DateFormat factoryFormat = DateFormat.getDateInstance((int)3, (ULocale)this.locale);
                        this.dateFormat = this.hackYear(factoryFormat);
                        factoryFormat = DateFormat.getDateTimeInstance((int)3, (int)timeForm, (ULocale)this.locale);
                        this.dateTimeFormat = this.hackYear(factoryFormat);
                        return;
                    }
                    case 'g': {
                        this.dateTimeFormat = DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)this.locale);
                        return;
                    }
                    case 'M': 
                    case 'm': {
                        this.dateTimeFormat = new SimpleDateFormat("MM/dd", this.locale);
                        return;
                    }
                    case 'R': 
                    case 'r': {
                        this.dateTimeFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss a", this.locale);
                        this.dateTimeFormat.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                        return;
                    }
                    case 's': {
                        this.dateTimeFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss", this.locale);
                        return;
                    }
                    case 'u': {
                        this.dateTimeFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss  Z", this.locale);
                        return;
                    }
                    case 'Y': 
                    case 'y': {
                        this.dateTimeFormat = new SimpleDateFormat("yyyy/mm", this.locale);
                        return;
                    }
                }
                this.dateTimeFormat = new SimpleDateFormat(formatString, this.locale);
                return;
            }
            if (formatString.equals("General Date")) {
                this.dateTimeFormat = DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Long Date")) {
                this.dateTimeFormat = DateFormat.getDateInstance((int)1, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Medium Date")) {
                this.dateTimeFormat = DateFormat.getDateInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Short Date")) {
                this.dateTimeFormat = DateFormat.getDateInstance((int)3, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Long Time")) {
                this.dateTimeFormat = DateFormat.getTimeInstance((int)1, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Medium Time")) {
                this.dateTimeFormat = DateFormat.getTimeInstance((int)2, (ULocale)this.locale);
                return;
            }
            if (formatString.equals("Short Time")) {
                this.dateTimeFormat = new SimpleDateFormat("kk:mm", this.locale);
                return;
            }
            this.dateTimeFormat = new SimpleDateFormat(formatString, this.locale);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private DateFormat hackYear(DateFormat factoryFormat) {
        if (factoryFormat instanceof SimpleDateFormat) {
            int idx;
            SimpleDateFormat factorySimpleFormat = (SimpleDateFormat)factoryFormat;
            String pattern = factorySimpleFormat.toPattern();
            if (pattern.indexOf("yyyy") == -1 && (idx = pattern.indexOf("yy")) >= 0) {
                StringBuffer strBuf = new StringBuffer(pattern);
                strBuf.insert(idx, 'y');
                pattern = strBuf.toString();
            }
            return new SimpleDateFormat(pattern, this.locale);
        }
        return factoryFormat;
    }

    public String format(Date date) {
        try {
            if (date instanceof java.sql.Date) {
                if (this.dateFormat != null) {
                    return this.dateFormat.format(date);
                }
            } else if (date instanceof Time && this.timeFormat != null) {
                return this.timeFormat.format(date);
            }
            return this.dateTimeFormat.format(date);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    public String getFormatCode() {
        SimpleDateFormat dateFormat;
        String formatCode = null;
        if (this.formatPattern.equals("General Date")) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (this.formatPattern.equals("Long Date")) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance((int)1, (ULocale)this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (this.formatPattern.equals("Medium Date")) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance((int)2, (ULocale)this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (this.formatPattern.equals("Short Date")) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance((int)3, (ULocale)this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (this.formatPattern.equals("Long Time")) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getTimeInstance((int)1, (ULocale)this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (this.formatPattern.equals("Medium Time")) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getTimeInstance((int)2, (ULocale)this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (this.formatPattern.equals("Short Time")) {
            dateFormat = new SimpleDateFormat("kk:mm", this.locale);
            formatCode = dateFormat.toPattern();
        }
        if (UNFORMATTED.equals(this.formatPattern) || DATETIME_UNFORMATTED.equals(this.formatPattern) || DATE_UNFORMATTED.equals(this.formatPattern) || TIME_UNFORMATTED.equals(this.formatPattern)) {
            formatCode = "";
        }
        return formatCode;
    }

    public Date parse(String date) throws ParseException {
        return this.dateTimeFormat.parse(date);
    }

    static class CacheHashMap
    extends LinkedHashMap {
        private static final long serialVersionUID = -2740310231997296948L;
        int maxEntry;

        public CacheHashMap(int maxEntry) {
            super(maxEntry, 0.75f, true);
            this.maxEntry = maxEntry;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxEntry;
        }
    }
}

