/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.sql.Date;
import java.sql.Time;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class JavascriptEvalUtil {
    private static Logger logger = Logger.getLogger(JavascriptEvalUtil.class.getName());
    protected static final int SCRIPT_CACHE_SIZE = 200;
    protected static Map compiledScriptCache = Collections.synchronizedMap(new LinkedHashMap(200, 0.75f, true){
        private static final long serialVersionUID = 5787175209573500620L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 200;
        }
    });

    public static Object evaluateRawScript(Context cx, Scriptable scope, String scriptText, String source, int lineNo) throws BirtException {
        boolean enterContext;
        Object result = null;
        boolean bl = enterContext = cx == null;
        if (enterContext) {
            cx = Context.enter();
        }
        try {
            try {
                Script compiledScript = JavascriptEvalUtil.getCompiledScript(cx, scope, scriptText, source, lineNo);
                result = compiledScript.exec(cx, scope);
            }
            catch (RhinoException e) {
                throw JavascriptEvalUtil.wrapRhinoException(e, scriptText, source, lineNo);
            }
        }
        finally {
            if (enterContext) {
                Context.exit();
            }
        }
        return result;
    }

    public static Object evaluateScript(Context cx, Scriptable scope, String scriptText, String source, int lineNo) throws BirtException {
        return JavascriptEvalUtil.convertJavascriptValue(JavascriptEvalUtil.evaluateRawScript(cx, scope, scriptText, source, lineNo));
    }

    protected static Script getCompiledScript(Context cx, Scriptable scope, String scriptText, String source, int lineNo) {
        assert (scriptText != null);
        Script compiledScript = (Script)compiledScriptCache.get(scriptText);
        if (compiledScript == null) {
            compiledScript = cx.compileString(scriptText, source, lineNo, null);
            compiledScriptCache.put(scriptText, compiledScript);
        }
        return compiledScript;
    }

    public static Object convertToJavascriptValue(Object value, Scriptable scope) {
        if (value instanceof java.util.Date) {
            Context cx = Context.enter();
            try {
                if (scope == null) {
                    scope = new ImporterTopLevel(cx);
                }
                if (value instanceof Time || value instanceof Date) {
                    Object object = Context.javaToJS((Object)value, (Scriptable)scope);
                    return object;
                }
                Long timeVal = new Long(((java.util.Date)value).getTime());
                Scriptable scriptable = ScriptRuntime.newObject((Context)cx, (Scriptable)scope, (String)"Date", (Object[])new Object[]{timeVal});
                return scriptable;
            }
            finally {
                Context.exit();
            }
        }
        return value;
    }

    public static Object convertToJavascriptValue(Object value) {
        return JavascriptEvalUtil.convertToJavascriptValue(value, null);
    }

    public static Object convertJavascriptValue(Object inputObj) {
        if (inputObj instanceof Undefined) {
            return null;
        }
        if (inputObj instanceof IdScriptableObject) {
            String jsClass = ((Scriptable)inputObj).getClassName();
            if ("Date".equals(jsClass)) {
                return Context.toType((Object)inputObj, java.util.Date.class);
            }
            if ("Boolean".equals(jsClass)) {
                return new Boolean(Context.toBoolean((Object)inputObj));
            }
            if ("Number".equals(jsClass)) {
                return new Double(Context.toNumber((Object)inputObj));
            }
            if ("String".equals(jsClass)) {
                return inputObj.toString();
            }
            if ("Array".equals(jsClass)) {
                Object[] obj = new Object[(int)((NativeArray)inputObj).getLength()];
                int i = 0;
                while (i < obj.length) {
                    obj[i] = JavascriptEvalUtil.convertJavascriptValue(((NativeArray)inputObj).get(i, null));
                    ++i;
                }
                return obj;
            }
        } else if (inputObj instanceof Wrapper) {
            return ((Wrapper)inputObj).unwrap();
        }
        return inputObj;
    }

    public static BirtException wrapRhinoException(RhinoException e, String scriptText, String source, int lineNo) {
        if (source == null) {
            source = e.sourceName();
            lineNo = e.lineNumber();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Unexpected RhinoException. Source=" + source + ", line=" + lineNo + ", Script=\n" + scriptText + "\n", e);
        }
        return new CoreException("birt.core.JavascriptError", new Object[]{e.getLocalizedMessage(), source, new Integer(lineNo), scriptText}, (Throwable)e);
    }

    public static Object[] convertToJavaObjects(Object[] args) {
        int i = 0;
        while (i < args.length) {
            args[i] = JavascriptEvalUtil.convertJavascriptValue(args[i]);
            ++i;
        }
        return args;
    }

    public static String transformToJsConstants(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\"': {
                    buffer.append("\\\"");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

