/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api.querydefn;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IQueryExecutionHints;
import org.eclipse.birt.data.engine.api.querydefn.BaseTransform;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryExecutionHints;
import org.eclipse.birt.data.engine.core.DataException;

public abstract class BaseQueryDefinition
extends BaseTransform
implements IBaseQueryDefinition {
    protected List groups = new ArrayList();
    protected boolean hasDetail = true;
    protected IBaseQueryDefinition parentQuery;
    protected int maxRowCount = 0;
    protected int startingRow = 0;
    protected boolean distinctValue = false;
    private boolean cacheQueryResults = false;
    private Map resultExprsMap = new LinkedHashMap();
    private Map bindingMap = new LinkedHashMap();
    private IQueryExecutionHints queryExecutionHints = new QueryExecutionHints();
    private String name;

    BaseQueryDefinition(IBaseQueryDefinition parent) {
        this.parentQuery = parent;
    }

    public List getGroups() {
        return this.groups;
    }

    public void addGroup(GroupDefinition group) {
        this.groups.add(group);
    }

    public boolean usesDetails() {
        return this.hasDetail;
    }

    public void setUsesDetails(boolean usesDetails) {
        this.hasDetail = usesDetails;
    }

    public IBaseQueryDefinition getParentQuery() {
        return this.parentQuery;
    }

    public int getMaxRows() {
        return this.maxRowCount;
    }

    public void setMaxRows(int maxRows) {
        this.maxRowCount = maxRows;
    }

    public void setStartingRow(int startingRow) {
        this.startingRow = startingRow;
    }

    public int getStartingRow() {
        return this.startingRow;
    }

    public void setDistinctValue(boolean distinctValue) {
        this.distinctValue = distinctValue;
    }

    public boolean getDistinctValue() {
        return this.distinctValue;
    }

    public void addResultSetExpression(String name, IBaseExpression expression) {
        Binding binding = new Binding(name);
        binding.setExpression(expression);
        if (expression != null) {
            binding.setDataType(expression.getDataType());
        }
        this.bindingMap.put(name, binding);
    }

    public void addBinding(IBinding binding) throws DataException {
        String bindingName;
        if (binding.getExpression() != null && binding.getExpression().getGroupName().equals("Total.OVERALL")) {
            binding.getExpression().setGroupName(null);
        }
        if (this.bindingMap.containsKey(bindingName = binding.getBindingName())) {
            throw new DataException("data.engine.DuplicatedBindingName", bindingName);
        }
        this.bindingMap.put(bindingName, binding);
    }

    public Map getBindings() {
        Iterator it = this.resultExprsMap.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            IBaseExpression expr = (IBaseExpression)this.resultExprsMap.get(key);
            if (this.bindingMap.get(key) != null) continue;
            Binding binding = new Binding(key);
            binding.setExpression(expr);
            this.bindingMap.put(key, binding);
        }
        return this.bindingMap;
    }

    public Map getResultSetExpressions() {
        return this.resultExprsMap;
    }

    public boolean cacheQueryResults() {
        return this.cacheQueryResults;
    }

    public void setCacheQueryResults(boolean cacheQueryResults) {
        this.cacheQueryResults = cacheQueryResults;
    }

    public void setQueryExecutionHints(IQueryExecutionHints hints) {
        this.queryExecutionHints = hints;
    }

    public IQueryExecutionHints getQueryExecutionHints() {
        return this.queryExecutionHints;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

