/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ExportManifestUtils {
    static final String[] API_JAR_PATTERNS = new String[]{"chartengineapi.jar", "com.ibm.icu.*.jar", "org.apache.commons.codec_.*.jar", "coreapi.jar", "dataadapterapi.jar", "dteapi.jar", "engineapi.jar", "flute.jar", "js.jar", "modelapi.jar", "org.eclipse.emf.common_.*.jar", "org.eclipse.emf.ecore.xmi_.*.jar", "org.eclipse.emf.ecore_.*.jar", "org.w3c.css.sac_.*.jar", "scriptapi.jar", "modelodaapi.jar", "odadesignapi.jar", "javax.servlet_.*.jar", "javax.servlet.jsp_.*.jar"};

    public static void main(String[] args) throws IOException {
        String jarFolder = ".";
        if (args.length > 0) {
            jarFolder = args[0];
        }
        File[] jarFiles = new File(jarFolder).listFiles();
        int i = 0;
        while (i < jarFiles.length) {
            if (ExportManifestUtils.isApiJar(jarFiles[i])) {
                ExportManifestUtils.exportPackages(jarFiles[i]);
            }
            ++i;
        }
    }

    static boolean isApiJar(File jarFile) {
        String name = jarFile.getName();
        int i = 0;
        while (i < API_JAR_PATTERNS.length) {
            if (name.matches(API_JAR_PATTERNS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static void exportPackages(File jarFile) throws IOException {
        System.out.println("#" + jarFile.getName());
        JarFile jar = new JarFile(jarFile);
        Entry root = new Entry();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            ExportManifestUtils.createEntry(root, entry);
        }
        int i = 0;
        while (i < root.children.size()) {
            ExportManifestUtils.outputEntry((Entry)root.children.get(i), "");
            ++i;
        }
    }

    static void outputEntry(Entry entry, String prefix) {
        if (entry.hasFiles) {
            System.out.println(" " + prefix + "." + entry.name + ",");
        }
        prefix = prefix != null && prefix.length() != 0 ? String.valueOf(prefix) + "." + entry.name : entry.name;
        int i = 0;
        while (i < entry.children.size()) {
            ExportManifestUtils.outputEntry((Entry)entry.children.get(i), prefix);
            ++i;
        }
    }

    static void createEntry(Entry root, JarEntry entry) {
        if (entry.isDirectory()) {
            String name = entry.getName();
            String[] names = name.split("/");
            int i = 0;
            while (i < names.length) {
                root = ExportManifestUtils.createEntry(root, names[i]);
                ++i;
            }
        } else {
            String name = entry.getName();
            String[] names = name.split("/");
            int i = 0;
            while (i < names.length - 1) {
                root = ExportManifestUtils.createEntry(root, names[i]);
                ++i;
            }
            root.hasFiles = true;
        }
    }

    static Entry createEntry(Entry parent, String name) {
        int i = 0;
        while (i < parent.children.size()) {
            Entry entry = (Entry)parent.children.get(i);
            if (name.equals(entry.name)) {
                return entry;
            }
            ++i;
        }
        Entry entry = new Entry();
        entry.name = name;
        parent.children.add(entry);
        return entry;
    }

    static class Entry {
        String name;
        boolean hasFiles;
        ArrayList children = new ArrayList();

        Entry() {
        }
    }
}

