/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.validators.AbstractPropertyValidator;

public class StructureListValidator
extends AbstractPropertyValidator {
    public static final String NAME = "StructureListValidator";
    private static StructureListValidator instance;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.validators.StructureListValidator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        instance = new StructureListValidator();
    }

    public static StructureListValidator getInstance() {
        return instance;
    }

    public List validateForAdding(DesignElementHandle element, IPropertyDefn propDefn, List list, IStructure toAdd) {
        return this.doCheckStructureList(element.getModule(), element.getElement(), propDefn, list, toAdd);
    }

    public List validate(Module module, DesignElement element, String propName) {
        ElementPropertyDefn propDefn = element.getPropertyDefn(propName);
        if (!($assertionsDisabled || propDefn.getTypeCode() == 16 && propDefn.isList())) {
            throw new AssertionError();
        }
        List list = (List)element.getLocalProperty(module, propDefn);
        return this.doCheckStructureList(module, element, propDefn, list, null);
    }

    private List doCheckStructureList(Module module, DesignElement element, IPropertyDefn propDefn, List list, IStructure toAdd) {
        boolean checkList = toAdd == null;
        ArrayList<PropertyValueException> errorList = new ArrayList<PropertyValueException>();
        if (list == null || list.size() == 0) {
            return errorList;
        }
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && propDefn.getTypeCode() != 16) {
            throw new AssertionError();
        }
        boolean checkID = propDefn.getStructDefn().getName().equals("PropertyBinding");
        if (!checkID) {
            String value;
            StructPropertyDefn uniqueMember = null;
            Iterator iter = propDefn.getStructDefn().propertiesIterator();
            while (iter.hasNext()) {
                StructPropertyDefn memberDefn = (StructPropertyDefn)iter.next();
                if (memberDefn.getTypeCode() != 13 && memberDefn.getTypeCode() != 22) continue;
                uniqueMember = memberDefn;
                break;
            }
            HashSet<String> values = new HashSet<String>();
            int i = 0;
            while (i < list.size()) {
                Structure struct = (Structure)list.get(i);
                if (checkList) {
                    errorList.addAll(struct.validate(module, element));
                }
                if (uniqueMember != null) {
                    String value2 = (String)struct.getProperty(module, uniqueMember);
                    if (values.contains(value2)) {
                        if (checkList) {
                            errorList.add(new PropertyValueException(element, propDefn, (Object)value2, "Error.PropertyValueException.VALUE_EXISTS"));
                        }
                    } else {
                        values.add(value2);
                    }
                }
                ++i;
            }
            if (uniqueMember != null && toAdd != null && values.contains(value = (String)toAdd.getProperty(module, uniqueMember))) {
                errorList.add(new PropertyValueException(element, propDefn.getName(), (Object)value, "Error.PropertyValueException.VALUE_EXISTS"));
            }
        } else {
            HashMap values = new HashMap();
            int i = 0;
            while (i < list.size()) {
                PropertyBinding struct = (PropertyBinding)list.get(i);
                if (checkList) {
                    errorList.addAll(struct.validate(module, element));
                }
                String name = struct.getName();
                BigDecimal id = struct.getID();
                ArrayList<String> names = (ArrayList<String>)values.get(id);
                if (names != null) {
                    if (names.contains(name)) {
                        if (checkList) {
                            errorList.add(new PropertyValueException(element, propDefn, (Object)name, "Error.PropertyValueException.VALUE_EXISTS"));
                        }
                    } else {
                        names.add(name);
                    }
                } else {
                    names = new ArrayList<String>();
                    names.add(name);
                    values.put(id, names);
                }
                ++i;
            }
            if (toAdd != null) {
                if (!$assertionsDisabled && !(toAdd instanceof PropertyBinding)) {
                    throw new AssertionError();
                }
                String name = ((PropertyBinding)toAdd).getName();
                BigDecimal id = ((PropertyBinding)toAdd).getID();
                List names = (List)values.get(id);
                if (names != null && names.contains(name)) {
                    errorList.add(new PropertyValueException(element, propDefn, (Object)name, "Error.PropertyValueException.VALUE_EXISTS"));
                }
            }
        }
        return errorList;
    }

    public List validateForRenaming(DesignElementHandle element, IPropertyDefn propDefn, List list, IStructure toRenamed, IPropertyDefn memberDefn, String newName) {
        ArrayList<PropertyValueException> errorList = new ArrayList<PropertyValueException>();
        if (list == null || list.size() == 0) {
            return errorList;
        }
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && propDefn.getTypeCode() != 16) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && memberDefn == null) {
            throw new AssertionError();
        }
        Module module = element.getModule();
        int i = 0;
        while (i < list.size()) {
            Structure struct = (Structure)list.get(i);
            String value = (String)struct.getProperty(module, (PropertyDefn)memberDefn);
            if (value.equals(newName) && struct != toRenamed) {
                errorList.add(new PropertyValueException(element.getElement(), propDefn, (Object)value, "Error.PropertyValueException.VALUE_EXISTS"));
                break;
            }
            ++i;
        }
        return errorList;
    }
}

