/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.ReferencableStructure;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class PropertyListRecord
extends SimpleRecord {
    private final DesignElement element;
    private final ElementPropertyDefn propDefn;
    private final StructureContext context;
    private final List list;
    private final Object value;
    protected final boolean isAdd;
    private final int posn;

    public PropertyListRecord(DesignElement element, StructureContext context, Object toRemove) {
        this.element = element;
        this.isAdd = false;
        this.context = context;
        this.value = toRemove;
        this.propDefn = (ElementPropertyDefn)context.getElementProp();
        Object valueContainer = context.getValueContainer();
        this.list = valueContainer instanceof Structure ? (List)((Structure)valueContainer).getLocalProperty(null, (PropertyDefn)context.getPropDefn()) : (List)((DesignElement)valueContainer).getLocalProperty(null, (ElementPropertyDefn)context.getPropDefn());
        this.posn = this.list.indexOf(toRemove);
        this.label = ModelMessages.getMessage("Message.ChangeProperty", new String[]{context.getElementProp().getDisplayName()});
    }

    public PropertyListRecord(DesignElement element, StructureContext context, Object toAdd, int posn) {
        this.element = element;
        this.isAdd = true;
        this.context = context;
        this.value = toAdd;
        this.propDefn = (ElementPropertyDefn)context.getElementProp();
        Object valueContainer = context.getValueContainer();
        this.list = valueContainer instanceof Structure ? (List)((Structure)valueContainer).getLocalProperty(null, (PropertyDefn)context.getPropDefn()) : (List)((DesignElement)valueContainer).getLocalProperty(null, (ElementPropertyDefn)context.getPropDefn());
        this.posn = posn;
        this.label = ModelMessages.getMessage("Message.ChangeProperty", new String[]{context.getElementProp().getDisplayName()});
    }

    public PropertyListRecord(DesignElement element, ElementPropertyDefn propDefn, List theList, Object toAdd, int posn) {
        this.element = element;
        this.isAdd = true;
        this.value = toAdd;
        this.list = theList;
        this.context = null;
        this.propDefn = propDefn;
        this.posn = posn;
        this.label = ModelMessages.getMessage("Message.ChangeProperty", new String[]{propDefn.getDisplayName()});
    }

    public PropertyListRecord(DesignElement element, ElementPropertyDefn propDefn, List theList, Object toRemove) {
        this.element = element;
        this.isAdd = false;
        this.value = toRemove;
        this.list = theList;
        this.posn = this.list.indexOf(toRemove);
        this.context = null;
        this.propDefn = propDefn;
        this.label = ModelMessages.getMessage("Message.ChangeProperty", new String[]{propDefn.getDisplayName()});
    }

    protected void perform(boolean undo) {
        boolean doAdd;
        boolean bl = doAdd = undo && !this.isAdd || !undo && this.isAdd;
        if (doAdd) {
            if (!(this.value instanceof Structure)) {
                this.list.add(this.posn, this.value);
                return;
            }
            this.context.add(this.posn, (Structure)this.value);
        } else {
            if (!(this.value instanceof Structure)) {
                this.list.remove(this.posn);
                return;
            }
            this.context.remove(this.posn);
        }
    }

    public DesignElement getTarget() {
        if (this.eventTarget != null) {
            return this.eventTarget.getElement();
        }
        return this.element;
    }

    public NotificationEvent getEvent() {
        if (this.eventTarget != null) {
            return new PropertyEvent(this.eventTarget.getElement(), this.eventTarget.getPropName());
        }
        return new PropertyEvent(this.element, this.propDefn.getName());
    }

    protected List getPostTasks() {
        ArrayList<NotificationRecordTask> retList = new ArrayList<NotificationRecordTask>();
        retList.addAll(super.getPostTasks());
        retList.add(new NotificationRecordTask(this.element, this.getEvent()));
        if (this.value != null && this.value instanceof IStructure && ((IStructure)this.value).isReferencable()) {
            ReferencableStructure refValue = (ReferencableStructure)this.value;
            retList.add(new NotificationRecordTask(refValue, this.getEvent()));
        }
        return retList;
    }
}

