/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.i18n;

import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.model.i18n.ModelResourceHandle;

public class ThreadResources {
    private Map resourceMap = new HashMap();
    private static ThreadLocal threadLocal = new ThreadLocal();

    public static void setLocale(ULocale locale) {
        if (locale == null) {
            threadLocal.set(ULocale.getDefault());
        } else {
            threadLocal.set(locale);
        }
    }

    public static ULocale getLocale() {
        ULocale locale = (ULocale)threadLocal.get();
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        return locale;
    }

    public String getMessage(String key) {
        ModelResourceHandle resourceHandle = this.getResourceHandle();
        if (resourceHandle != null) {
            return resourceHandle.getMessage(key);
        }
        return key;
    }

    public String getMessage(String key, Object[] arguments) {
        ModelResourceHandle resourceHandle = this.getResourceHandle();
        if (resourceHandle != null) {
            return resourceHandle.getMessage(key, arguments);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelResourceHandle getResourceHandle() {
        ULocale locale = ThreadResources.getLocale();
        ModelResourceHandle resourceHandle = (ModelResourceHandle)((Object)this.resourceMap.get(locale));
        if (resourceHandle != null) {
            return resourceHandle;
        }
        Map map = this.resourceMap;
        synchronized (map) {
            if (this.resourceMap.get(locale) != null) {
                return (ModelResourceHandle)((Object)this.resourceMap.get(locale));
            }
            resourceHandle = new ModelResourceHandle(locale);
            this.resourceMap.put(locale, resourceHandle);
        }
        return resourceHandle;
    }
}

