/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ElementStructureUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.util.ElementStructureUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static boolean updateStructureFromParent(Module childModule, DesignElement child, DesignElement parent) {
        if (child == null || parent == null) {
            return false;
        }
        if (child.getExtendsElement() != parent) {
            return false;
        }
        Map overriddenValues = ElementStructureUtil.collectPropertyValues(childModule, child);
        boolean retValue = ElementStructureUtil.duplicateStructure(parent, child, childModule);
        ElementStructureUtil.distributeValues(childModule, child, overriddenValues);
        return retValue;
    }

    public static void distributeValues(Module module, DesignElement element, Map overriddenValues) {
        if (element == null) {
            return;
        }
        ContentIterator contentIterator = new ContentIterator(module, element);
        while (contentIterator.hasNext()) {
            List values;
            DesignElement content = (DesignElement)contentIterator.next();
            Long baseId = new Long(content.getID());
            if (overriddenValues == null || overriddenValues.isEmpty() || (values = (List)overriddenValues.get(baseId)) == null || values.isEmpty()) continue;
            int i = 0;
            while (i < values.size()) {
                Property prop = (Property)values.get(i);
                Object value = prop.getValue();
                if ("style".equals(prop.getName())) {
                    ((StyledElement)content).setStyleName((String)prop.getValue());
                } else if (value instanceof ReferenceValue) {
                    Object newValue = ((ReferenceValue)value).copy();
                    content.setProperty(prop.getName(), newValue);
                } else {
                    content.setProperty(prop.getName(), prop.getValue());
                }
                ++i;
            }
        }
    }

    public static Map collectPropertyValues(Module module, DesignElement element) {
        if (element == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap map = new HashMap();
        Module root = element.getRoot();
        ContentIterator contentIterator = new ContentIterator(module, element);
        while (contentIterator.hasNext()) {
            DesignElement content = (DesignElement)contentIterator.next();
            Long baseId = new Long(content.getBaseId());
            ArrayList<Property> values = (ArrayList<Property>)map.get(baseId);
            if (values == null) {
                values = new ArrayList<Property>();
                map.put(baseId, values);
            }
            List propDefns = null;
            propDefns = content instanceof ExtendedItem ? ((ExtendedItem)content).getExtDefn().getProperties() : content.getPropertyDefns();
            int i = 0;
            while (i < propDefns.size()) {
                String propName;
                Object propValue;
                PropertyDefn propDefn = (PropertyDefn)propDefns.get(i);
                if (!("name".equalsIgnoreCase(propDefn.getName()) || "extends".equalsIgnoreCase(propDefn.getName()) || propDefn.getTypeCode() == 23 || content instanceof ExtendedItem && "extensionName".equalsIgnoreCase(propDefn.getName()) || (propValue = content.getLocalProperty(root, propName = propDefn.getName())) == null)) {
                    if ("style".equals(propName)) {
                        ReferenceValue refValue = (ReferenceValue)propValue;
                        propValue = refValue.getName();
                    }
                    values.add(new Property(propName, propValue));
                }
                ++i;
            }
        }
        return map;
    }

    public static boolean duplicateStructure(DesignElement source, DesignElement target, Module targetModule) {
        if (source == null || target == null) {
            throw new IllegalArgumentException("Element can not be null.");
        }
        ElementDefn defn = (ElementDefn)source.getDefn();
        if (defn != target.getDefn()) {
            throw new IllegalArgumentException("Two element are not the same type.");
        }
        if (!defn.isContainer()) {
            return true;
        }
        int i = 0;
        while (i < defn.getSlotCount()) {
            ElementStructureUtil.duplicateStructure(new ContainerContext(source, i), new ContainerContext(target, i), targetModule);
            ++i;
        }
        List properties = defn.getContents();
        int i2 = 0;
        while (i2 < properties.size()) {
            PropertyDefn propDefn = (PropertyDefn)properties.get(i2);
            ElementStructureUtil.duplicateStructure(new ContainerContext(source, propDefn.getName()), new ContainerContext(target, propDefn.getName()), targetModule);
            ++i2;
        }
        if (target instanceof Cube) {
            Cube targetCube = (Cube)target;
            Cube sourceCube = (Cube)source;
            DesignElement group = sourceCube.getDefaultMeasureGroup(sourceCube.getRoot());
            if (group != null) {
                int index = group.getIndex(sourceCube.getRoot());
                if (!$assertionsDisabled && index <= -1) {
                    throw new AssertionError();
                }
                targetCube.setDefaultMeasureGroup(index);
            }
        } else if (target instanceof Dimension) {
            Dimension targetDimension = (Dimension)target;
            Dimension sourceDimension = (Dimension)source;
            DesignElement hierarchy = sourceDimension.getDefaultHierarchy(sourceDimension.getRoot());
            if (hierarchy != null) {
                int index = hierarchy.getIndex(sourceDimension.getRoot());
                if (!$assertionsDisabled && index <= -1) {
                    throw new AssertionError();
                }
                targetDimension.setDefaultHierarchy(index);
            }
        }
        return true;
    }

    private static void duplicateStructure(ContainerContext sourceInfor, ContainerContext targetInfor, Module targetModule) {
        targetInfor.clearContents();
        int j = 0;
        while (j < sourceInfor.getContentCount(null)) {
            DesignElement sourceContent = sourceInfor.getContent(null, j);
            DesignElement targetContent = null;
            if (sourceContent instanceof ExtendedItem) {
                ExtendedItem extendedItem = (ExtendedItem)sourceContent;
                targetContent = new ExtendedItem(sourceContent.getName());
                targetContent.setProperty("extensionName", extendedItem.getProperty(extendedItem.getRoot(), "extensionName"));
            } else if (!(sourceContent instanceof OdaDataSet) && !(sourceContent instanceof OdaDataSource)) {
                targetContent = ModelUtil.newElement(sourceContent.getElementName(), sourceContent.getName());
            }
            if (targetContent != null) {
                targetContent.setID(sourceContent.getID());
                targetContent.setBaseId(sourceContent.getID());
                targetInfor.add(targetModule, targetContent);
                ElementStructureUtil.duplicateStructure(sourceContent, targetContent, targetModule);
                if (targetContent instanceof TableItem) {
                    ((TableItem)targetContent).refreshRenderModel(targetModule);
                }
            }
            ++j;
        }
    }

    public static void clearStructure(DesignElement element) {
        if (element == null) {
            return;
        }
        ElementDefn defn = (ElementDefn)element.getDefn();
        if (!defn.isContainer()) {
            return;
        }
        int i = 0;
        while (i < defn.getSlotCount()) {
            new ContainerContext(element, i).clearContents();
            ++i;
        }
        List properties = defn.getContents();
        int i2 = 0;
        while (i2 < properties.size()) {
            PropertyDefn propDefn = (PropertyDefn)properties.get(i2);
            new ContainerContext(element, propDefn.getName()).clearContents();
            ++i2;
        }
    }

    public static void addTheVirualElementsToNamesapce(DesignElement element, Module module) {
        ContentIterator contentIter = new ContentIterator(module, element);
        while (contentIter.hasNext()) {
            DesignElement virtualElement = (DesignElement)contentIter.next();
            if (virtualElement.getName() == null) continue;
            module.makeUniqueName(virtualElement);
            NameSpace ns = new NameExecutor(element).getNameSpace(module);
            if (ns == null) continue;
            ns.insert(virtualElement);
        }
    }

    public static boolean refreshStructureFromParent(Module module, DesignElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Parent element can not be null.");
        }
        DesignElement parent = element.getExtendsElement();
        if (parent == null) {
            return false;
        }
        boolean result = ElementStructureUtil.updateStructureFromParent(module, element, parent);
        if (element instanceof TableItem) {
            ((TableItem)element).refreshRenderModel(module);
        }
        return result;
    }

    public static Map getIdMap(Module module, DesignElement element) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        DesignElement parent = element.getExtendsElement();
        if (parent == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, DesignElement> idMap = new HashMap<Long, DesignElement>();
        ContentIterator parentIter = new ContentIterator(module, parent);
        ContentIterator childIter = new ContentIterator(module, element);
        while (childIter.hasNext()) {
            DesignElement virtualParent = (DesignElement)parentIter.next();
            DesignElement virtualChild = (DesignElement)childIter.next();
            if (!$assertionsDisabled && virtualChild.getDefn().getName() != virtualChild.getDefn().getName()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && virtualParent.getID() <= 0L) {
                throw new AssertionError();
            }
            idMap.put(new Long(virtualParent.getID()), virtualChild);
        }
        return idMap;
    }

    public static void localizeElement(Module module, DesignElement element) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        DesignElement parent = element.getExtendsElement();
        if (parent == null) {
            return;
        }
        ElementStructureUtil.duplicateProperties(parent, element);
        ContentIterator iter1 = new ContentIterator(module, parent);
        ContentIterator iter2 = new ContentIterator(module, element);
        while (iter1.hasNext()) {
            DesignElement virtualParent = (DesignElement)iter1.next();
            DesignElement virtualChild = (DesignElement)iter2.next();
            ElementStructureUtil.duplicateProperties(virtualParent, virtualChild);
        }
    }

    private static void duplicateProperties(DesignElement from, DesignElement to) {
        Iterator iter;
        if (from.getDefn().allowsUserProperties()) {
            iter = from.getUserProperties().iterator();
            while (iter.hasNext()) {
                UserPropertyDefn userPropDefn = (UserPropertyDefn)iter.next();
                to.addUserPropertyDefn(userPropDefn);
            }
        }
        iter = from.getDefn().getProperties().iterator();
        while (iter.hasNext()) {
            ElementPropertyDefn propDefn = (ElementPropertyDefn)iter.next();
            String propName = propDefn.getName();
            if ("style".equals(propName) || "extends".equals(propName) || "userProperties".equals(propName) || "refTemplateParameter".equals(propName)) continue;
            Object localValue = to.getLocalProperty(from.getRoot(), propDefn);
            Object parentValue = from.getStrategy().getPropertyFromElement(from.getRoot(), from, propDefn);
            if (localValue != null || parentValue == null) continue;
            Object valueToSet = ModelUtil.copyValue(propDefn, parentValue);
            to.setProperty(propDefn, valueToSet);
        }
    }

    private static class Property {
        private String name;
        private Object value;

        Property(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        Object getValue() {
            return this.value;
        }
    }
}

