/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.AggregationArgument;

public class ComputedColumnHandle
extends StructureHandle {
    public ComputedColumnHandle(SimpleValueHandle valueHandle, int index) {
        super(valueHandle, index);
    }

    public String getColumnName() {
        return this.getName();
    }

    public String getDisplayName() {
        return this.getStringProperty("displayName");
    }

    public String getName() {
        return this.getStringProperty("name");
    }

    public void setColumnName(String columnName) {
    }

    public void setDisplayName(String columnDisplayName) throws SemanticException {
        this.setProperty("displayName", columnDisplayName);
    }

    public void setName(String columnName) throws SemanticException {
        this.setProperty("name", columnName);
    }

    public String getExpression() {
        return this.getStringProperty("expression");
    }

    public void setExpression(String expression) throws SemanticException {
        this.setProperty("expression", expression);
    }

    public String getAggregrateOn() {
        return this.getAggregateOn();
    }

    public void setAggregrateOn(String aggregateOn) {
        this.setAggregateOn(aggregateOn);
    }

    public String getDataType() {
        return this.getStringProperty("dataType");
    }

    public void setDataType(String dataType) throws SemanticException {
        this.setProperty("dataType", dataType);
    }

    public void addAggregateOn(String aggreValue) throws SemanticException {
        MemberHandle aggreHandle = this.getMember("aggregateOn");
        aggreHandle.addItem(aggreValue);
    }

    public AggregationArgumentHandle addArgument(AggregationArgument argument) throws SemanticException {
        MemberHandle aggreHandle = this.getMember("arguments");
        return (AggregationArgumentHandle)aggreHandle.addItem(argument);
    }

    public String getAggregateFunction() {
        return this.getStringProperty("aggregateFunction");
    }

    public String getAggregateOn() {
        List aggres = this.getAggregateOnList();
        if (aggres == null || aggres.isEmpty()) {
            return null;
        }
        return (String)aggres.get(0);
    }

    public List getAggregateOnList() {
        List aggregateOns = (List)this.getProperty("aggregateOn");
        if (aggregateOns == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(aggregateOns);
    }

    public Iterator argumentsIterator() {
        MemberHandle propHandle = this.getMember("arguments");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public String getFilterExpression() {
        return this.getStringProperty("filterExpr");
    }

    public void removeAggregateOn(String aggreValue) throws SemanticException {
        MemberHandle aggreHandle = this.getMember("aggregateOn");
        aggreHandle.removeItem(aggreValue);
    }

    public void removeArgument(AggregationArgument argument) throws SemanticException {
        MemberHandle aggreHandle = this.getMember("arguments");
        aggreHandle.removeItem(argument);
    }

    public void setAggregateFunction(String expression) throws SemanticException {
        this.setProperty("aggregateFunction", expression);
    }

    public void setAggregateOn(String aggregateOn) {
        block6: {
            MemberHandle aggreHandle = this.getMember("aggregateOn");
            if (aggregateOn == null) {
                block5: {
                    try {
                        aggreHandle.clearValue();
                    }
                    catch (SemanticException semanticException) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
                return;
            }
            ArrayList<String> newValue = new ArrayList<String>();
            newValue.add(aggregateOn);
            try {
                aggreHandle.setValue(newValue);
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public void setFilterExpression(String expression) throws SemanticException {
        this.setProperty("filterExpr", expression);
    }

    public void clearAggregateOnList() throws SemanticException {
        this.setProperty("aggregateOn", null);
    }

    public void clearArgumentList() throws SemanticException {
        this.setProperty("arguments", null);
    }
}

