/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.BundleFactory;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.core.BundleHelper;
import org.eclipse.birt.report.model.util.SecurityUtil;
import org.eclipse.birt.report.model.util.URIUtilImpl;

public class DefaultResourceLocator
implements IResourceLocator {
    protected static Logger logger = Logger.getLogger(DefaultResourceLocator.class.getName());

    public URL findResource(ModuleHandle moduleHandle, String fileName, int type) {
        URL u = null;
        if (fileName == null) {
            return u;
        }
        switch (type) {
            case 5: {
                u = this.getMessageFile(moduleHandle, fileName);
                break;
            }
            default: {
                u = this.getResource(moduleHandle, fileName);
            }
        }
        return u;
    }

    private URL getMessageFile(ModuleHandle moduleHandle, String fileName) {
        if (moduleHandle == null) {
            return null;
        }
        ULocale locale = moduleHandle.getModule().getSession().getLocale();
        List possibleFiles = BundleHelper.getHelper(moduleHandle.getModule(), fileName).getMessageFilenames(locale);
        int i = 0;
        while (i < possibleFiles.size()) {
            String filename = (String)possibleFiles.get(i);
            URL url = this.getResource(moduleHandle, filename);
            if (url != null) {
                return url;
            }
            ++i;
        }
        return null;
    }

    private URL getResource(ModuleHandle moduleHandle, String fileName) {
        URL retURL = this.tryDiskFileSearch(null, fileName);
        if (retURL != null) {
            return retURL;
        }
        try {
            retURL = this.tryURLSearch(new URL(fileName));
            if (retURL != null) {
                return retURL;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        if (moduleHandle == null) {
            return this.tryFragmentSearch(fileName);
        }
        String resourcePath = moduleHandle.getModule().getSession().getResourceFolder();
        if (StringUtil.isBlank(resourcePath)) {
            resourcePath = moduleHandle.getResourceFolder();
        }
        if (resourcePath != null) {
            retURL = this.tryDiskFileSearch(resourcePath, fileName);
            if (retURL != null) {
                return retURL;
            }
            try {
                URL baseURL = new URL(resourcePath);
                retURL = this.tryURLSearch(new URL(baseURL, URIUtil.convertFileNameToURLString(fileName)));
            }
            catch (MalformedURLException malformedURLException) {}
            if (retURL != null) {
                return retURL;
            }
        }
        if ((retURL = this.tryFragmentSearch(fileName)) != null) {
            return retURL;
        }
        URL systemId = moduleHandle.getModule().getSystemId();
        if (systemId == null) {
            return null;
        }
        try {
            return this.tryURLSearch(new URL(systemId, URIUtil.convertFileNameToURLString(fileName)));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private boolean isGlobalResource(URL url) {
        if ("ftp".equalsIgnoreCase(url.getProtocol()) || "http".equalsIgnoreCase(url.getProtocol())) {
            return true;
        }
        return url.getFile().toLowerCase().startsWith("ftp") || url.getFile().toLowerCase().startsWith("http");
    }

    private URL tryURLSearch(URL url) {
        boolean networkProtocol = this.isGlobalResource(url);
        if (networkProtocol) {
            return url;
        }
        InputStream in = null;
        try {
            try {
                in = url.openStream();
            }
            catch (IOException iOException) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException2) {}
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return url;
    }

    private URL tryFragmentSearch(String fileName) {
        return BundleFactory.getBundleFactory().getBundleResource("org.eclipse.birt.resources", fileName);
    }

    private URL tryDiskFileSearch(String fileDir, String filePath) {
        block5: {
            File f = null;
            String tmpFilePath = URIUtilImpl.toUniversalFileFormat(filePath);
            f = StringUtil.isBlank(fileDir) ? new File(tmpFilePath) : new File(fileDir, tmpFilePath);
            try {
                if (SecurityUtil.exists(f) && SecurityUtil.isFile(f)) {
                    return SecurityUtil.fileToURI(SecurityUtil.getCanonicalFile(f)).toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                assert (false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        return null;
    }
}

