/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.command;

import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ModelMessages;

public class LibraryException
extends SemanticException {
    private static final long serialVersionUID = 5124358913518651257L;
    public static final String DESIGN_EXCEPTION_LIBRARY_NOT_FOUND = "Error.LibraryException.LIBRARY_NOT_FOUND";
    public static final String DESIGN_EXCEPTION_DUPLICATE_LIBRARY_NAMESPACE = "Error.LibraryException.DUPLICATE_LIBRARY_NAMESPACE";
    public static final String DESIGN_EXCEPTION_LIBRARY_INCLUDED_RECURSIVELY = "Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY";
    public static final String DESIGN_EXCEPTION_LIBRARY_HAS_DESCENDENTS = "Error.LibraryException.LIBRARY_HAS_DESCENDENTS";
    public static final String DESIGN_EXCEPTION_LIBRARY_ALREADY_INCLUDED = "Error.LibraryException.LIBRARY_ALREADY_INCLUDED";

    public LibraryException(Module module, String errCode) {
        super(module, errCode);
    }

    public LibraryException(Module module, String[] values, String errCode) {
        super((DesignElement)module, values, errCode);
    }

    public String getLocalizedMessage() {
        if (DESIGN_EXCEPTION_LIBRARY_NOT_FOUND == this.sResourceKey || DESIGN_EXCEPTION_LIBRARY_INCLUDED_RECURSIVELY == this.sResourceKey) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{(String)this.oaMessageArguments[0]});
        }
        if (DESIGN_EXCEPTION_DUPLICATE_LIBRARY_NAMESPACE == this.sResourceKey || DESIGN_EXCEPTION_LIBRARY_ALREADY_INCLUDED == this.sResourceKey) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{(String)this.oaMessageArguments[0]});
        }
        if (DESIGN_EXCEPTION_LIBRARY_HAS_DESCENDENTS == this.sResourceKey) {
            LibraryHandle libHandle = (LibraryHandle)this.element.getHandle((Module)this.element);
            return ModelMessages.getMessage(this.sResourceKey, new String[]{libHandle.getNamespace(), (String)this.oaMessageArguments[0]});
        }
        return ModelMessages.getMessage(this.sResourceKey);
    }
}

