/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.io.IOException;
import java.util.List;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.util.ElementExporter;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.StructureListValidator;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ElementExportUtil {
    public static void exportElement(DesignElementHandle elementToExport, String libraryFileName, boolean canOverride) throws DesignFileException, SemanticException, IOException {
        ElementExporter.checkElementToExport(elementToExport, true);
        DesignSession session = elementToExport.getModule().getSession();
        LibraryHandle libraryHandle = ElementExportUtil.openOrCreateLibrary(session, libraryFileName);
        assert (libraryHandle != null);
        ElementExportUtil.exportElement(elementToExport, libraryHandle, canOverride);
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportElements(List elementsToExport, String libraryFileName, boolean canOverride) throws DesignFileException, SemanticException, IOException {
        DesignSession session = null;
        for (DesignElementHandle elementToExport : elementsToExport) {
            ElementExporter.checkElementToExport(elementToExport, true);
            if (session != null) continue;
            session = elementToExport.getModule().getSession();
        }
        if (session == null) {
            return;
        }
        LibraryHandle libraryHandle = ElementExportUtil.openOrCreateLibrary(session, libraryFileName);
        assert (libraryHandle != null);
        for (DesignElementHandle elementToExport : elementsToExport) {
            ElementExportUtil.exportElement(elementToExport, libraryHandle, canOverride);
        }
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportElement(DesignElementHandle elementToExport, LibraryHandle targetLibraryHandle, boolean canOverride) throws SemanticException {
        ElementExporter.checkElementToExport(elementToExport, true);
        ElementExporter exporter = new ElementExporter(targetLibraryHandle);
        exporter.exportElement(elementToExport, canOverride);
    }

    public static void exportStructure(StructureHandle structToExport, String libraryFileName, boolean canOverride) throws DesignFileException, SemanticException, IOException {
        ElementExporter.checkStructureToExport(structToExport, true);
        DesignSession session = structToExport.getElementHandle().getModule().getSession();
        LibraryHandle libraryHandle = ElementExportUtil.openOrCreateLibrary(session, libraryFileName);
        assert (libraryHandle != null);
        ElementExportUtil.exportStructure(structToExport, libraryHandle, canOverride);
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportStructures(List structsToExport, String libraryFileName, boolean canOverride) throws DesignFileException, SemanticException, IOException {
        DesignSession session = null;
        for (StructureHandle structToExport : structsToExport) {
            ElementExporter.checkStructureToExport(structToExport, true);
            if (session != null) continue;
            session = structToExport.getElementHandle().getModule().getSession();
        }
        if (session == null) {
            return;
        }
        LibraryHandle libraryHandle = ElementExportUtil.openOrCreateLibrary(session, libraryFileName);
        assert (libraryHandle != null);
        for (StructureHandle structToExport : structsToExport) {
            ElementExportUtil.exportStructure(structToExport, libraryHandle, canOverride);
        }
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportStructure(StructureHandle structToExport, LibraryHandle targetLibraryHandle, boolean canOverride) throws SemanticException {
        ElementExporter.checkStructureToExport(structToExport, true);
        ElementExporter exporter = new ElementExporter(targetLibraryHandle);
        exporter.exportStructure(structToExport, canOverride);
    }

    public static void exportDesign(ReportDesignHandle designToExport, String libraryFileName, boolean canOverride, boolean genDefaultName) throws DesignFileException, SemanticException, IOException {
        DesignSession session = designToExport.getModule().getSession();
        LibraryHandle libraryHandle = ElementExportUtil.openOrCreateLibrary(session, libraryFileName);
        assert (libraryHandle != null);
        ElementExportUtil.exportDesign(designToExport, libraryHandle, canOverride, genDefaultName);
        String designVersion = designToExport.getVersion();
        String libVersion = libraryHandle.getVersion();
        if (StringUtil.isBlank(libVersion)) {
            libraryHandle.getModule().getVersionManager().setVersion(designVersion);
        }
        libraryHandle.save();
        libraryHandle.close();
    }

    public static void exportDesign(ReportDesignHandle designToExport, LibraryHandle targetLibraryHandle, boolean canOverride, boolean genDefaultName) throws SemanticException {
        if (ModelUtil.hasLibrary(designToExport, targetLibraryHandle)) {
            throw new SemanticException(designToExport.getElement(), "Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY");
        }
        ElementExporter exporter = new ElementExporter(targetLibraryHandle);
        exporter.exportDesign(designToExport, canOverride, genDefaultName);
    }

    private static LibraryHandle openOrCreateLibrary(DesignSession session, String libraryFileName) throws DesignFileException {
        try {
            Library library = session.openLibrary(libraryFileName);
            return library.handle();
        }
        catch (DesignFileException e) {
            List errorList;
            ErrorDetail error;
            if ("Error.DesignFileException.SYNTAX_ERROR" == e.getErrorCode() && "Error.DesignParserException.FILE_NOT_FOUND" == (error = (ErrorDetail)(errorList = e.getErrorList()).get(0)).getErrorCode()) {
                Library library = session.createLibrary();
                LibraryHandle libraryHandle = library.handle();
                libraryHandle.setFileName(libraryFileName);
                return libraryHandle;
            }
            throw e;
        }
    }

    public static boolean canExport(DesignElementHandle elementToExport, LibraryHandle targetLibraryHandle, boolean canOverride) {
        if (!ElementExportUtil.canExport(elementToExport)) {
            return false;
        }
        if (targetLibraryHandle == null) {
            return false;
        }
        String name = elementToExport.getName();
        if (elementToExport instanceof ExtendedItemHandle && !ElementExportUtil.checkExportedExtendedItem((ExtendedItemHandle)elementToExport)) {
            return false;
        }
        if (elementToExport instanceof ReportItemHandle) {
            if (canOverride) {
                return true;
            }
            return targetLibraryHandle.findElement(name) == null;
        }
        if (elementToExport instanceof CubeHandle) {
            if (canOverride) {
                return true;
            }
            return targetLibraryHandle.findCube(name) == null;
        }
        if (elementToExport instanceof DataSourceHandle) {
            if (canOverride) {
                return true;
            }
            return targetLibraryHandle.findDataSource(name) == null;
        }
        if (elementToExport instanceof DataSetHandle) {
            if (canOverride) {
                return true;
            }
            return targetLibraryHandle.findDataSet(name) == null;
        }
        if (elementToExport instanceof ParameterHandle || elementToExport instanceof ParameterGroupHandle) {
            if (canOverride) {
                return true;
            }
            return targetLibraryHandle.findParameter(name) == null;
        }
        return false;
    }

    public static boolean canExport(StructureHandle structToExport, LibraryHandle targetLibraryHandle, boolean canOverride) {
        if (!ElementExportUtil.canExport(structToExport)) {
            return false;
        }
        if (targetLibraryHandle == null) {
            return false;
        }
        IElementPropertyDefn propDefn = null;
        String structName = structToExport.getDefn().getName();
        if ("EmbeddedImage".equals(structName)) {
            propDefn = targetLibraryHandle.getPropertyDefn("images");
        } else if ("CustomColor".equals(structName)) {
            propDefn = targetLibraryHandle.getPropertyDefn("colorPalette");
        } else if ("ConfigVar".equals(structName)) {
            propDefn = targetLibraryHandle.getPropertyDefn("configVars");
        } else {
            return false;
        }
        if (canOverride) {
            return true;
        }
        List results = StructureListValidator.getInstance().validateForAdding(targetLibraryHandle, propDefn, targetLibraryHandle.getListProperty(propDefn.getName()), structToExport.getStructure());
        return results.isEmpty();
    }

    public static boolean canExport(DesignElementHandle elementToExport) {
        return ElementExportUtil.canExport(elementToExport, true);
    }

    public static boolean canExport(StructureHandle structToExport) {
        return ElementExportUtil.canExport(structToExport, true);
    }

    public static boolean canExport(DesignElementHandle elementToExport, boolean ignoreName) {
        if (elementToExport == null) {
            return false;
        }
        try {
            ElementExporter.checkElementToExport(elementToExport, ignoreName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (elementToExport instanceof CubeHandle) {
            return true;
        }
        if (elementToExport instanceof DataSourceHandle) {
            return true;
        }
        if (elementToExport instanceof DataSetHandle) {
            return true;
        }
        if (elementToExport instanceof ParameterHandle || elementToExport instanceof ParameterGroupHandle) {
            return true;
        }
        if (elementToExport instanceof ExtendedItemHandle && !ElementExportUtil.checkExportedExtendedItem((ExtendedItemHandle)elementToExport)) {
            return false;
        }
        return elementToExport instanceof ReportItemHandle;
    }

    public static boolean canExport(StructureHandle structToExport, boolean ignoreName) {
        if (structToExport == null) {
            return false;
        }
        try {
            ElementExporter.checkStructureToExport(structToExport, ignoreName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    private static boolean checkExportedExtendedItem(ExtendedItemHandle elementToExport) {
        try {
            IReportItem item = elementToExport.getReportItem();
            return item == null || item.canExport();
        }
        catch (ExtendedElementException extendedElementException) {
            return false;
        }
    }
}

