/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class CellOverlappingValidator
extends AbstractElementValidator {
    private static final CellOverlappingValidator instance = new CellOverlappingValidator();

    public static CellOverlappingValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof TableRow)) {
            return Collections.EMPTY_LIST;
        }
        if (element.getContainer() == null) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, (TableRow)element);
    }

    private List doValidate(Module module, TableRow toValidate) {
        ArrayList<SemanticError> list = new ArrayList<SemanticError>();
        int slotId = toValidate.getContainer().findSlotOf(toValidate);
        ContainerSlot slot = toValidate.getContainer().getSlot(slotId);
        int colCount = toValidate.getColumnCount(module);
        if (colCount <= 0) {
            return list;
        }
        boolean ok = true;
        boolean[] cols = new boolean[colCount];
        int rowPosn = slot.findPosn(toValidate);
        int rowCount = slot.getCount();
        int cellCount = toValidate.getContentsSlot().size();
        int impliedPosn = 0;
        int i = 0;
        while (i < cellCount) {
            Cell cell = (Cell)toValidate.getContentsSlot().get(i);
            int colPosn = cell.getColumn(module);
            int colSpan = cell.getColSpan(module);
            int rowSpan = cell.getRowSpan(module);
            colPosn = colPosn > 0 ? --colPosn : impliedPosn;
            if (!this.checkColSpan(cols, colPosn, colSpan) || !this.checkRowSpan(rowCount, rowPosn, rowSpan)) {
                ok = false;
            }
            impliedPosn = colPosn + colSpan;
            ++i;
        }
        if (!ok) {
            DesignElement container = toValidate.getContainer();
            if (container instanceof TableGroup) {
                container = container.getContainer();
            } else assert (container instanceof TableItem || container instanceof GridItem);
            list.add(new SemanticError((DesignElement)toValidate, new String[]{container.getElementName(), container.getFullName()}, "Error.SemanticError.OVERLAPPING_CELLS"));
        }
        return list;
    }

    private boolean checkColSpan(boolean[] cols, int colPosn, int colSpan) {
        boolean ok = true;
        int j = 0;
        while (j < colSpan) {
            if (cols[colPosn + j]) {
                ok = false;
            }
            cols[colPosn + j] = true;
            ++j;
        }
        return ok;
    }

    private boolean checkRowSpan(int rowCount, int rowPosn, int rowSpan) {
        return rowCount - rowPosn - rowSpan >= 0;
    }
}

