/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.IEventFilter;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.activity.TransactionOption;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.command.AbstractContentCommand;
import org.eclipse.birt.report.model.command.ContentElementInfo;
import org.eclipse.birt.report.model.command.ContentRecord;
import org.eclipse.birt.report.model.command.ElementRefRecord;
import org.eclipse.birt.report.model.command.PropertyListRecord;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ModelUtil;

class ContentElementCommand
extends AbstractContentCommand {
    public ContentElementCommand(Module module, ContainerContext containerInfo) {
        super(module, containerInfo);
    }

    public ContentElementCommand(Module module, DesignElement element, ContentElementInfo eventTarget) {
        super(module, element);
        this.eventTarget = eventTarget;
    }

    private DesignElement makeLocalCompositeValue(DesignElement content) {
        String propName = this.focus.getPropertyName();
        ElementPropertyDefn prop = this.element.getPropertyDefn(propName);
        return this.makeLocalCompositeValue(this.element, prop, content);
    }

    private DesignElement makeLocalCompositeValue(DesignElement topElement, ElementPropertyDefn prop, DesignElement content) {
        Object localValue = topElement.getLocalProperty(this.module, prop);
        if (localValue != null) {
            return content;
        }
        Object inherited = topElement.getProperty(this.module, prop);
        if (inherited == null) {
            return null;
        }
        int index = -1;
        if (content != null && inherited instanceof List) {
            index = ((List)inherited).indexOf(content);
        }
        Object newValue = ModelUtil.copyValue(prop, inherited);
        ActivityStack activityStack = this.module.getActivityStack();
        ContainerContext context = new ContainerContext(topElement, prop.getName());
        if (newValue instanceof List) {
            List list = new ArrayList();
            PropertyRecord propRecord = new PropertyRecord(topElement, prop, list);
            activityStack.execute(propRecord);
            list = (List)newValue;
            int i = 0;
            while (i < list.size()) {
                DesignElement tmpContent = (DesignElement)list.get(i);
                ContentRecord addRecord = new ContentRecord(this.module, context, tmpContent, i);
                activityStack.execute(addRecord);
                ++i;
            }
        } else {
            PropertyRecord propRecord = new PropertyRecord(topElement, prop, newValue);
            activityStack.execute(propRecord);
        }
        if (index != -1) {
            return (DesignElement)((List)newValue).get(index);
        }
        return content;
    }

    protected void doAdd(int newPos, DesignElement content) throws ContentException, NameException {
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.AddElement"), this.getTransOption());
        this.makeLocalCompositeValue(content);
        super.doAdd(newPos, content);
        stack.commit();
    }

    protected void doDelectAction(DesignElement content) throws SemanticException {
        DesignElement toRemove = this.makeLocalCompositeValue(content);
        super.doDelectAction(toRemove);
    }

    protected void doMove(DesignElement content, ContainerContext toContainerInfor, int newPos) {
        ActivityStack stack = this.getActivityStack();
        String label = CommandLabelFactory.getCommandLabel("Message.MoveElement");
        stack.startTrans(label, this.getTransOption());
        DesignElement toMove = this.makeLocalCompositeValue(content);
        super.doMove(toMove, toContainerInfor, newPos);
        stack.commit();
    }

    protected void doMovePosition(DesignElement content, int newPosn) throws ContentException {
        if (!this.focus.isContainerMultipleCardinality()) {
            return;
        }
        ActivityStack stack = this.getActivityStack();
        String label = CommandLabelFactory.getCommandLabel("Message.MoveElement");
        stack.startTrans(label, this.getTransOption());
        DesignElement toMove = this.makeLocalCompositeValue(content);
        super.doMovePosition(toMove, newPosn);
        stack.commit();
    }

    protected void doSetProperty(ElementPropertyDefn prop, Object value) {
        ActivityStack stack = this.getActivityStack();
        TransactionOption options = this.getTransOption();
        stack.startTrans(null, options);
        DesignElement tmpElement = this.copyTopCompositeValue();
        PropertyRecord propRecord = new PropertyRecord(tmpElement, prop, value);
        this.getActivityStack().execute(propRecord);
        stack.commit();
    }

    private DesignElement copyTopCompositeValue() {
        if (!(this.element instanceof ContentElement)) {
            return null;
        }
        DesignElement topElement = this.eventTarget.getElement();
        String propName = this.eventTarget.getPropName();
        ElementPropertyDefn prop = topElement.getPropertyDefn(propName);
        this.makeLocalCompositeValue(topElement, prop, null);
        return this.matchElement(topElement);
    }

    private DesignElement matchElement(DesignElement topElement) {
        List steps = this.eventTarget.stepIterator();
        DesignElement tmpElement = topElement;
        int i = steps.size() - 1;
        while (i >= 0) {
            ContentElementInfo.Step step = (ContentElementInfo.Step)steps.get(i);
            PropertyDefn stepPropDefn = step.stepPropDefn;
            int index = step.index;
            Object stepValue = tmpElement.getLocalProperty(this.module, (ElementPropertyDefn)stepPropDefn);
            tmpElement = stepPropDefn.isListType() ? (DesignElement)((List)stepValue).get(index) : (DesignElement)stepValue;
            --i;
        }
        return tmpElement;
    }

    protected void addItem(MemberRef ref, Object value) {
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.AddItem"), this.getTransOption());
        DesignElement tmpElement = this.copyTopCompositeValue();
        List list = ref.getList(this.module, tmpElement);
        SimpleRecord record = null;
        if (value instanceof Structure) {
            assert (false);
        } else {
            record = new PropertyListRecord(tmpElement, ref.getPropDefn(), list, value, list.size());
        }
        assert (record != null);
        stack.execute(record);
        record.setEventTarget(this.eventTarget);
        stack.commit();
    }

    protected void removeItem(MemberRef ref) {
        ElementRefValue refValue;
        ActivityStack stack = this.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.RemoveItem"), this.getTransOption());
        DesignElement tmpElement = this.copyTopCompositeValue();
        List list = ref.getList(this.module, tmpElement);
        PropertyDefn propDefn = ref.getPropDefn();
        if (ref.getMemberDefn() != null) {
            propDefn = ref.getMemberDefn();
        }
        Object value = list.get(ref.getIndex());
        PropertyListRecord record = null;
        if (value instanceof Structure) {
            assert (false);
        } else {
            record = new PropertyListRecord(tmpElement, ref.getPropDefn(), list, value);
        }
        assert (record != null);
        stack.execute(record);
        record.setEventTarget(this.eventTarget);
        if (value instanceof ElementRefValue && (refValue = (ElementRefValue)value).isResolved()) {
            ElementRefRecord refRecord = new ElementRefRecord(this.element, refValue.getTargetElement(), propDefn.getName(), false);
            stack.execute(refRecord);
        }
        stack.commit();
    }

    private TransactionOption getTransOption() {
        TransactionOption options = new TransactionOption();
        options.setSendTime(1);
        options.setEventfilter(new EventFilter(this.eventTarget.getElement(), this.eventTarget.getPropName()));
        return options;
    }

    private static class EventFilter
    implements IEventFilter {
        private final NotificationEvent ev;

        private EventFilter(DesignElement target, String propName) {
            this.ev = new PropertyEvent(target, propName);
        }

        public List filter(List events) {
            ArrayList<NotificationRecordTask> retList = new ArrayList<NotificationRecordTask>();
            retList.add(new NotificationRecordTask(this.ev.getTarget(), this.ev));
            return retList;
        }
    }
}

