/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.ElementDeletedEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.Parameter;
import org.eclipse.birt.report.model.elements.ParameterGroup;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.SimpleDataSet;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.validators.ValidationExecutor;

public class ContentRecord
extends SimpleRecord {
    protected ContainerContext containerInfo = null;
    protected DesignElement content = null;
    protected boolean add = true;
    protected int oldPosn = -1;
    protected final Module module;

    public ContentRecord(Module module, ContainerContext containerInfor, DesignElement contentObj, boolean isAdd) {
        this.init(containerInfor, contentObj, -1, isAdd);
        this.module = module;
        assert (module != null);
    }

    public ContentRecord(Module module, ContainerContext containerInfo, DesignElement contentObj, int newPos) {
        this.init(containerInfo, contentObj, newPos, true);
        this.module = module;
        assert (module != null);
    }

    private void init(ContainerContext theContainerInfo, DesignElement contentObj, int newPos, boolean isAdd) {
        this.containerInfo = theContainerInfo;
        this.content = contentObj;
        this.add = isAdd;
        assert (newPos >= -1);
        assert (this.containerInfo != null);
        assert (this.content != null);
        assert (isAdd && this.content.getContainer() == null || !isAdd && this.content.getContainer() != null);
        assert (this.containerInfo.getContainerDefn().canContain(this.content));
        if (isAdd) {
            int count = this.containerInfo.getContentCount(this.module);
            this.oldPosn = newPos == -1 || count < newPos ? count : newPos;
        } else {
            this.oldPosn = this.containerInfo.indexOf(this.module, this.content);
            assert (this.oldPosn != -1);
        }
        this.label = this.add ? CommandLabelFactory.getCommandLabel("Message.AddElement") : CommandLabelFactory.getCommandLabel("Message.DropElement");
    }

    public DesignElement getTarget() {
        if (this.eventTarget != null) {
            return this.eventTarget.getElement();
        }
        return this.containerInfo.getElement();
    }

    public NotificationEvent getEvent() {
        return null;
    }

    protected void perform(boolean undo) {
        if (this.add && !undo || !this.add && undo) {
            this.containerInfo.add(this.module, this.content, this.oldPosn);
            if (this.content.getRoot() != null) {
                this.module.manageId(this.content, true);
            }
        } else {
            if (this.content.getRoot() != null) {
                this.module.manageId(this.content, false);
            }
            this.oldPosn = this.containerInfo.indexOf(this.module, this.content);
            this.containerInfo.remove(this.module, this.content);
        }
    }

    private boolean isSelector(DesignElement content) {
        if (!(content instanceof StyleElement)) {
            return false;
        }
        return MetaDataDictionary.getInstance().getPredefinedStyle(content.getName()) != null;
    }

    public List getValidators() {
        List list = ValidationExecutor.getValidationNodes(this.containerInfo.getElement(), this.containerInfo.getTriggerSetForContainerDefn(), false);
        if (this.add && this.state != 2 || !this.add && this.state == 2) {
            ElementDefn contentDefn = (ElementDefn)this.content.getDefn();
            list.addAll(ValidationExecutor.getValidationNodes(this.content, contentDefn.getTriggerDefnSet(), false));
        }
        return list;
    }

    protected List getPostTasks() {
        ReportItem compoundElement;
        ArrayList<RecordTask> retValue = new ArrayList<RecordTask>();
        retValue.addAll(super.getPostTasks());
        DesignElement container = this.containerInfo.getElement();
        if (this.eventTarget != null) {
            PropertyEvent event = new PropertyEvent(this.eventTarget.getElement(), this.eventTarget.getPropName());
            retValue.add(new NotificationRecordTask(container, (NotificationEvent)event));
            this.content.clearListeners();
            return retValue;
        }
        if ((container instanceof TableItem || container instanceof GridItem || container instanceof TableGroup || container instanceof TableRow) && (compoundElement = LayoutUtil.getCompoundContainer(container)) != null) {
            retValue.add(new LayoutRecordTask(this.module, compoundElement));
        }
        NotificationEvent event = null;
        event = this.add && this.state != 2 || !this.add && this.state == 2 ? new ContentEvent(this.containerInfo, this.content, 1) : new ContentEvent(this.containerInfo, this.content, 2);
        if (this.state == 1) {
            event.setSender(this.sender);
        }
        retValue.add(new NotificationRecordTask(container, event));
        if (this.add && this.state != 2 || !this.add && this.state == 2) {
            if (this.isSelector(this.content)) {
                retValue.add(new NotificationRecordTask(this.content, event, container.getRoot()));
            }
            return retValue;
        }
        if (this.content instanceof Parameter || this.content instanceof ParameterGroup || this.content instanceof SimpleDataSet || this.content instanceof StyleElement) {
            event = new ElementDeletedEvent(container, this.content);
            if (this.state == 1) {
                event.setSender(this.sender);
            }
            retValue.add(new NotificationRecordTask(this.content, event, container.getRoot()));
        } else {
            this.content.clearListeners();
        }
        return retValue;
    }
}

