/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class MoveListItemRecord
extends SimpleRecord {
    protected DesignElement element = null;
    protected MemberRef itemRef = null;
    protected List list = null;
    protected int oldPosn = 0;
    protected int newPosn = 0;

    public MoveListItemRecord(DesignElement obj, MemberRef ref, List theList, int from, int to) {
        assert (obj != null);
        assert (ref != null);
        assert (theList != null);
        assert (from >= 0 && from < theList.size());
        assert (to >= 0 && to < theList.size());
        assert (obj.getPropertyDefn(ref.getPropDefn().getName()) == ref.getPropDefn());
        this.element = obj;
        this.itemRef = ref;
        this.list = theList;
        this.oldPosn = from;
        this.newPosn = to;
        this.label = CommandLabelFactory.getCommandLabel("Message.MoveItem");
    }

    protected void perform(boolean undo) {
        int from = undo ? this.newPosn : this.oldPosn;
        int to = undo ? this.oldPosn : this.newPosn;
        Object value = this.list.remove(from);
        this.list.add(to, value);
    }

    public DesignElement getTarget() {
        if (this.eventTarget != null) {
            return this.eventTarget.getElement();
        }
        return this.element;
    }

    public NotificationEvent getEvent() {
        if (this.eventTarget != null) {
            return new PropertyEvent(this.eventTarget.getElement(), this.eventTarget.getPropName());
        }
        return new PropertyEvent(this.element, this.itemRef.getPropDefn().getName());
    }
}

