/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.elements.structures.LevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.OdaLevelAttribute;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.GroupNameValidator;
import org.eclipse.birt.report.model.command.AbstractPropertyCommand;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.ContentCommand;
import org.eclipse.birt.report.model.command.ContentElementCommand;
import org.eclipse.birt.report.model.command.ExtendsCommand;
import org.eclipse.birt.report.model.command.GroupElementCommand;
import org.eclipse.birt.report.model.command.MemberRecord;
import org.eclipse.birt.report.model.command.NameCommand;
import org.eclipse.birt.report.model.command.PropertyRecord;
import org.eclipse.birt.report.model.command.StyleCommand;
import org.eclipse.birt.report.model.command.ThemeCommand;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.elements.olap.OdaLevel;
import org.eclipse.birt.report.model.elements.olap.TabularLevel;
import org.eclipse.birt.report.model.elements.strategy.GroupPropSearchStrategy;
import org.eclipse.birt.report.model.elements.strategy.ReportItemPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public class PropertyCommand
extends AbstractPropertyCommand {
    public PropertyCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    public void setProperty(String propName, Object value) throws SemanticException {
        this.checkAllowedOperation();
        propName = StringUtil.trimString(propName);
        ElementPropertyDefn prop = this.element.getPropertyDefn(propName);
        if (prop == null) {
            throw new PropertyNameException(this.element, propName);
        }
        this.setProperty(prop, value);
    }

    public void setProperty(ElementPropertyDefn prop, Object value) throws SemanticException {
        this.checkAllowedOperation();
        if (prop.isElementType()) {
            this.setElementTypeProperty(prop, value);
            return;
        }
        String propName = prop.getName();
        if (("toc".equals(propName) || "toc".equals(propName)) && value instanceof String) {
            Object oldValue = this.element.getLocalProperty(this.module, prop);
            if (oldValue != null) {
                CachedMemberRef ref = new CachedMemberRef(prop, "expressionValue");
                this.setMember(ref, value);
                return;
            }
            value = StructureFactory.createTOC((String)value);
        }
        if ("extensionName".equals(prop.getName())) {
            throw new PropertyValueException(this.element, "extensionName", value, "Error.PropertyValueException.EXTENSION_SETTING_FORBIDDEN");
        }
        String mask = this.element.getPropertyMask(this.module, prop.getName());
        if ("lock".equalsIgnoreCase(mask)) {
            throw new PropertyValueException(this.element, prop, value, "Error.PropertyValueException.VALUE_LOCKED");
        }
        if (this.element.isVirtualElement() && this.element instanceof Cell && ("colSpan".equalsIgnoreCase(propName = prop.getName()) || "rowSpan".equalsIgnoreCase(propName) || "drop".equalsIgnoreCase(propName) || "column".equalsIgnoreCase(propName))) {
            throw new PropertyValueException(this.element, prop, value, "Error.PropertyValueException.PROPERTY_CHANGE_FORBIDDEN");
        }
        if (this.element instanceof MasterPage) {
            propName = prop.getName();
            if (!((MasterPage)this.element).isCustomType(this.module) && ("width".equals(propName) || "height".equals(propName))) {
                throw new SemanticError(this.element, "Error.SemanticError.CANNOT_SPECIFY_PAGE_SIZE");
            }
        }
        if ((value = this.validateValue(prop, value)) instanceof ElementRefValue && prop.getTypeCode() == 15) {
            this.checkRecursiveElementReference(prop, (ElementRefValue)value);
            this.checkDataBindingReference(prop, (ElementRefValue)value);
        }
        if (this.element instanceof GroupElement && "groupName".equals(prop.getName()) && !this.isGroupNameValidInContext((String)value)) {
            throw new NameException(this.element, (String)value, "Error.NameException.DUPLICATE");
        }
        if (prop.isIntrinsic()) {
            this.setIntrinsicProperty(prop, value);
            return;
        }
        if ("refTemplateParameter".equals(prop.getName()) && value == null) {
            this.clearRefTemplateParameterProp(prop, value);
            return;
        }
        if (this.element instanceof ContentElement && !((ContentElement)this.element).isLocal()) {
            ContentElementCommand attrCmd = new ContentElementCommand(this.module, this.element, ((ContentElement)this.element).getValueContainer());
            attrCmd.doSetProperty(prop, value);
            return;
        }
        this.doSetProperty(prop, value);
    }

    private void setElementTypeProperty(ElementPropertyDefn prop, Object value) throws SemanticException {
        ContainerContext context = new ContainerContext(this.element, prop.getName());
        ActivityStack stack = this.getActivityStack();
        PropertyRecord record = new PropertyRecord(this.element, prop, value);
        stack.startTrans(record.getLabel());
        ContentCommand cmd = new ContentCommand(this.module, context);
        List contents = context.getContents(this.module);
        try {
            int i;
            if (contents != null) {
                i = 0;
                while (i < contents.size()) {
                    DesignElement content = (DesignElement)contents.get(i);
                    cmd.remove(content);
                    ++i;
                }
            }
            if (value instanceof DesignElement) {
                cmd.add((DesignElement)value);
            } else if (value instanceof DesignElementHandle) {
                cmd.add(((DesignElementHandle)value).getElement());
            } else if (value instanceof List) {
                contents = (List)value;
                i = 0;
                while (i < contents.size()) {
                    Object item = contents.get(i);
                    if (item instanceof DesignElement) {
                        cmd.add((DesignElement)item);
                    } else if (item instanceof DesignElementHandle) {
                        cmd.add(((DesignElementHandle)item).getElement());
                    }
                    ++i;
                }
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void clearRefTemplateParameterProp(ElementPropertyDefn prop, Object value) throws SemanticException {
        this.checkAllowedOperation();
        assert (prop != null);
        assert ("refTemplateParameter".equals(prop.getName()));
        ActivityStack stack = this.module.getActivityStack();
        PropertyRecord record = new PropertyRecord(this.element, prop.getName(), value);
        stack.startTrans(record.getLabel());
        try {
            ElementRefValue templateParam = (ElementRefValue)this.element.getProperty(this.module, prop);
            TemplateParameterDefinition definition = (TemplateParameterDefinition)templateParam.getElement();
            this.doSetProperty(prop, value);
            if (definition != null && !definition.hasReferences()) {
                ContentCommand cmd = new ContentCommand(definition.getRoot(), definition.getContainerInfo());
                cmd.remove(definition);
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void doSetProperty(ElementPropertyDefn prop, Object value) throws SemanticException {
        ActivityStack stack;
        ExtendedItem extendedItem;
        Object oldValue = this.element.getLocalProperty(this.module, prop);
        if (oldValue == null && value == null) {
            return;
        }
        if (oldValue != null && value != null && oldValue.equals(value)) {
            return;
        }
        if (this.element instanceof ExtendedItem && (extendedItem = (ExtendedItem)this.element).isExtensionModelProperty(prop.getName())) {
            IReportItem extElement = ((ExtendedItem)this.element).getExtendedElement();
            if (extElement == null) {
                return;
            }
            extElement.checkProperty(prop.getName(), value);
            extElement.setProperty(prop.getName(), value);
            return;
        }
        if (this.element instanceof Level && prop.getName().equals("dateTimeLevelType") && value != null) {
            stack = this.getActivityStack();
            PropertyRecord record = new PropertyRecord(this.element, prop, value);
            record.setEventTarget(this.getEventTarget(prop));
            stack.startTrans(record.getLabel());
            stack.execute(record);
            boolean isFound = false;
            ElementPropertyDefn attributesPropertyDefn = this.element.getPropertyDefn("attributes");
            List attrs = (List)this.element.getProperty(this.module, attributesPropertyDefn);
            if (attrs != null) {
                int i = 0;
                while (i < attrs.size()) {
                    LevelAttribute attr = (LevelAttribute)attrs.get(i);
                    if ("DateTime".equals(attr.getName())) {
                        isFound = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!isFound) {
                ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.module, this.element);
                LevelAttribute struct = null;
                if (this.element instanceof TabularLevel) {
                    LevelAttribute attibute = new LevelAttribute();
                    attibute.setName("DateTime");
                    attibute.setDataType("date-time");
                    struct = attibute;
                } else if (this.element instanceof OdaLevel) {
                    OdaLevelAttribute attibute = new OdaLevelAttribute();
                    attibute.setName("DateTime");
                    attibute.setDataType("date-time");
                    struct = attibute;
                }
                if (attributesPropertyDefn != null && struct != null) {
                    try {
                        cmd.addItem((MemberRef)new CachedMemberRef(attributesPropertyDefn), (Object)struct);
                    }
                    catch (SemanticException semanticException) {
                        assert (false);
                        stack.rollback();
                    }
                }
            }
            stack.commit();
            return;
        }
        stack = this.getActivityStack();
        PropertyRecord record = new PropertyRecord(this.element, prop, value);
        stack.startTrans(record.getLabel());
        record.setEventTarget(this.getEventTarget(prop));
        stack.execute(record);
        if ("dataBindingRef".equalsIgnoreCase(prop.getName())) {
            try {
                if (this.element instanceof ListingElement) {
                    GroupElementCommand tmpCmd = new GroupElementCommand(this.module, new ContainerContext(this.element, 1));
                    tmpCmd.updateBindingRef((ElementRefValue)oldValue, (ElementRefValue)value);
                }
                if ((value == null || !((ElementRefValue)value).isResolved()) && oldValue != null && ((ElementRefValue)oldValue).isResolved()) {
                    this.localizeProperties(((ElementRefValue)oldValue).getElement());
                }
            }
            catch (SemanticException e) {
                stack.rollback();
                throw e;
            }
        }
        stack.commit();
    }

    private void localizeProperties(DesignElement targetElement) throws SemanticException {
        ReportItem reportItem = (ReportItem)this.element;
        this.recoverReferredReportItem(reportItem, targetElement);
        if (!(reportItem instanceof ListingElement) || !(targetElement instanceof ListingElement)) {
            return;
        }
        if (!ModelUtil.isCompatibleDataBindingElements(this.element, targetElement)) {
            return;
        }
        ListingElement listing = (ListingElement)reportItem;
        List listingGroups = listing.getGroups();
        ListingElement targetListing = (ListingElement)targetElement;
        List targetGroups = targetListing.getGroups();
        int size = Math.min(listingGroups.size(), targetGroups.size());
        int i = 0;
        while (i < size) {
            this.recoverReferredReportItem((GroupElement)listingGroups.get(i), (GroupElement)targetGroups.get(i));
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void recoverReferredReportItem(DesignElement source, DesignElement targetElement) throws SemanticException {
        Iterator propNames = null;
        if (targetElement instanceof ReportItem) {
            propNames = ReportItemPropSearchStrategy.getDataBindingProperties(targetElement).iterator();
        } else {
            if (!(targetElement instanceof GroupElement)) {
                assert (false);
                return;
            }
            propNames = GroupPropSearchStrategy.getDataBindingPropties().iterator();
        }
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            ElementPropertyDefn propDefn = (ElementPropertyDefn)targetElement.getDefn().getProperty(propName);
            if (propDefn == null || source.getDefn().getProperty(propName) == null) continue;
            Object value = targetElement.getStrategy().getPropertyExceptRomDefault(this.module, targetElement, propDefn);
            value = ModelUtil.copyValue(propDefn, value);
            PropertyRecord propRecord = new PropertyRecord(source, propDefn, value);
            this.getActivityStack().execute(propRecord);
        }
    }

    private Object validateValue(ElementPropertyDefn prop, Object value) throws SemanticException {
        if (value == null) {
            return null;
        }
        Object input = value;
        if (value instanceof DesignElementHandle) {
            DesignElementHandle elementHandle = (DesignElementHandle)value;
            Module root = elementHandle.getModule();
            input = ReferenceValueUtil.needTheNamespacePrefix(elementHandle.getElement(), root, this.module);
        }
        Object retValue = null;
        String propName = prop.getName();
        try {
            retValue = prop.validateValue(this.module, input);
        }
        catch (PropertyValueException ex) {
            ex.setElement(this.element);
            ex.setPropertyName(propName);
            throw ex;
        }
        if (!(retValue instanceof ElementRefValue)) {
            return retValue;
        }
        ElementRefValue refValue = (ElementRefValue)retValue;
        if (refValue.isResolved() && value instanceof DesignElementHandle && refValue.getElement() != ((DesignElementHandle)value).getElement()) {
            throw new SemanticError(this.element, new String[]{propName, refValue.getName()}, "Error.SemanticError.INVALID_ELEMENT_REF");
        }
        return retValue;
    }

    private void setIntrinsicProperty(ElementPropertyDefn prop, Object value) throws SemanticException {
        this.checkAllowedOperation();
        String propName = prop.getName();
        if ("name".equals(propName) && prop.getTypeCode() == 13) {
            String name = (String)value;
            NameCommand cmd = new NameCommand(this.module, this.element);
            cmd.setName(name);
        } else if ("extends".equals(propName)) {
            ExtendsCommand cmd = new ExtendsCommand(this.module, this.element);
            cmd.setExtendsRefValue((ElementRefValue)value);
        } else if ("style".equals(propName)) {
            StyleCommand cmd = new StyleCommand(this.module, this.element);
            cmd.setStyleRefValue((ElementRefValue)value);
        } else if ("units".equals(propName)) {
            this.doSetProperty(prop, value);
        } else if ("extensionName".equals(propName)) {
            this.doSetProperty(prop, value);
        } else if ("theme".equals(propName)) {
            assert (this.module == this.element);
            ThemeCommand cmd = new ThemeCommand((Module)this.element);
            cmd.setThemeRefValue((ElementRefValue)value);
        } else assert (false);
    }

    private boolean isGroupNameValidInContext(String groupName) {
        assert (this.element instanceof GroupElement);
        if (groupName == null) {
            return true;
        }
        if (this.element.getContainer() != null) {
            DesignElement tmpContainer = this.element.getContainer();
            List errors = GroupNameValidator.getInstance().validateForRenamingGroup((ListingHandle)tmpContainer.getHandle(this.module), (GroupHandle)this.element.getHandle(this.module), groupName);
            if (!errors.isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public void clearProperty(String propName) throws SemanticException {
        this.setProperty(propName, null);
    }

    public void setMember(MemberRef ref, Object value) throws SemanticException {
        Object oldValue;
        this.checkAllowedOperation();
        PropertyDefn memberDefn = ref.getMemberDefn();
        ElementPropertyDefn propDefn = ref.getPropDefn();
        assert (propDefn != null);
        this.assertExtendedElement(this.module, this.element, propDefn);
        assert (memberDefn != null);
        value = memberDefn.validateValue(this.module, value);
        if (memberDefn.getTypeCode() == 13 || memberDefn.getTypeCode() == 22) {
            this.checkItemName(ref, (String)value);
        }
        if (value instanceof ElementRefValue && memberDefn.getTypeCode() == 15) {
            this.checkRecursiveElementReference(memberDefn, (ElementRefValue)value);
        }
        if ((oldValue = ref.getLocalValue(this.module, this.element)) == null && value == null) {
            return;
        }
        if (oldValue != null && value != null && oldValue.equals(value)) {
            return;
        }
        ActivityStack stack = this.getActivityStack();
        String label = CommandLabelFactory.getCommandLabel("Message.ChangeItem");
        stack.startTrans(label);
        this.makeLocalCompositeValue(ref);
        MemberRecord record = new MemberRecord(this.module, this.element, ref, value);
        record.setEventTarget(this.getEventTarget(ref.getPropDefn()));
        stack.execute(record);
        Structure structure = ref.getStructure(this.module, this.element);
        List semanticList = structure.validate(this.module, this.element);
        if (semanticList.size() > 0) {
            stack.rollback();
            throw (SemanticException)((Object)semanticList.get(0));
        }
        stack.commit();
    }

    private void checkAllowedOperation() {
        if (this.element != null && this.element instanceof CssStyle) {
            throw new IllegalOperationException("Error.CssException.READONLY");
        }
    }

    private void checkDataBindingReference(PropertyDefn propDefn, ElementRefValue refValue) throws SemanticException {
        if ("dataBindingRef".equals(propDefn.getName()) && refValue.isResolved() && ModelUtil.checkContainerOrContent(this.element, refValue.getElement())) {
            throw new SemanticError(this.element, new String[]{this.element.getName(), refValue.getName()}, "Error.SemanticError.INVALID_DATA_BINDING_REF");
        }
    }
}

