/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.io.IOException;
import java.util.Properties;
import java.util.Stack;
import org.eclipse.birt.report.model.css.CSSValue;
import org.eclipse.birt.report.model.css.CssErrorHandler;
import org.eclipse.birt.report.model.css.ParserFactory;
import org.eclipse.birt.report.model.css.Property;
import org.eclipse.birt.report.model.css.StyleDeclaration;
import org.eclipse.birt.report.model.css.StyleRule;
import org.eclipse.birt.report.model.css.StyleSheet;
import org.eclipse.birt.report.model.css.UnSupportedRule;
import org.eclipse.birt.report.model.util.SecurityUtil;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSStyleSheet;

public class CssParser {
    private Parser parser = ParserFactory.createCSS2Parser();
    private CssErrorHandler errorHandler = ParserFactory.createErrorHandler();

    public CSSStyleSheet parseStyleSheet(InputSource source) throws IOException {
        CssHandler handler = new CssHandler();
        this.parser.setDocumentHandler((DocumentHandler)handler);
        this.parser.setErrorHandler((ErrorHandler)this.errorHandler);
        this.parser.parseStyleSheet(source);
        return (StyleSheet)handler.getRoot();
    }

    public CssErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public static void setProperty(String key, String val) {
        Properties props = SecurityUtil.getSystemProperties();
        props.put(key, val);
        System.setProperties(props);
    }

    class CssHandler
    implements DocumentHandler {
        private Stack nodeStack;
        private Object root = null;

        public CssHandler(Stack nodeStack) {
            this.nodeStack = nodeStack;
        }

        public CssHandler() {
            this.nodeStack = new Stack();
        }

        public Object getRoot() {
            return this.root;
        }

        public void startDocument(InputSource source) throws CSSException {
            if (this.nodeStack.empty()) {
                StyleSheet ss = new StyleSheet();
                this.nodeStack.push(ss);
            }
        }

        public void endDocument(InputSource source) throws CSSException {
            this.root = this.nodeStack.pop();
        }

        public void comment(String text) throws CSSException {
        }

        private void unsupportedRule(String atRule) {
            UnSupportedRule ir = new UnSupportedRule(atRule);
            if (!this.nodeStack.empty()) {
                ((StyleSheet)this.nodeStack.peek()).add(ir);
            } else {
                this.root = ir;
            }
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            this.unsupportedRule(atRule);
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            this.unsupportedRule(uri);
        }

        public void startMedia(SACMediaList media) throws CSSException {
            this.unsupportedRule(media.toString());
        }

        public void endMedia(SACMediaList media) throws CSSException {
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            this.unsupportedRule(String.valueOf(name) + pseudo_page);
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
        }

        public void startFontFace() throws CSSException {
            this.unsupportedRule(null);
        }

        public void endFontFace() throws CSSException {
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            StyleRule sr = new StyleRule(selectors);
            if (!this.nodeStack.empty()) {
                ((StyleSheet)this.nodeStack.peek()).add(sr);
            }
            StyleDeclaration decl = new StyleDeclaration();
            sr.setStyle(decl);
            this.nodeStack.push(sr);
            this.nodeStack.push(decl);
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            this.nodeStack.pop();
            this.root = this.nodeStack.pop();
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            StyleDeclaration decl = (StyleDeclaration)this.nodeStack.peek();
            decl.addProperty(new Property(name, new CSSValue(value)));
        }
    }
}

