/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.css;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.DefaultResourceLocator;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;

public class CssStyleSheetAdapter
implements ICssStyleSheetOperation {
    private List csses = null;

    public static CssStyleSheet getCssStyleSheetByLocation(Module module, List csses, URL url) {
        if (url == null || csses == null) {
            return null;
        }
        DefaultResourceLocator locator = new DefaultResourceLocator();
        int i = 0;
        while (i < csses.size()) {
            CssStyleSheet css = (CssStyleSheet)csses.get(i);
            String tmpFileName = css.getFileName();
            URL tmpurl = locator.findResource((ModuleHandle)module.getHandle(module), tmpFileName, 3);
            if (tmpurl != null && url.equals(tmpurl)) {
                return css;
            }
            ++i;
        }
        return null;
    }

    public static int getPositionOfCssStyleSheet(Module module, List csses, String location) {
        if (location == null || csses == null) {
            return -1;
        }
        URL targetUrl = module.findResource(location, 3);
        String fileLocation = location;
        if (targetUrl != null) {
            fileLocation = targetUrl.getFile();
        }
        int i = 0;
        while (i < csses.size()) {
            URL url;
            CssStyleSheet css = (CssStyleSheet)csses.get(i);
            String tmpFileName = css.getFileName();
            if (targetUrl != null && (url = module.findResource(tmpFileName, 3)) != null) {
                tmpFileName = url.getFile();
            }
            if (fileLocation.equalsIgnoreCase(tmpFileName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int dropCss(CssStyleSheet css) {
        assert (this.csses != null);
        assert (this.csses.contains(css));
        int posn = this.csses.indexOf(css);
        if (posn != -1) {
            this.csses.remove(posn);
        }
        return posn;
    }

    public void addCss(CssStyleSheet css) {
        if (this.csses == null) {
            this.csses = new ArrayList();
        }
        this.csses.add(css);
    }

    public void insertCss(CssStyleSheet css, int index) {
        if (this.csses == null) {
            this.csses = new ArrayList();
        }
        if (index < 0 || index > this.csses.size()) {
            return;
        }
        this.csses.add(index, css);
    }

    public List getCsses() {
        if (this.csses == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.csses);
    }
}

