/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.ExtendsForbiddenException;
import org.eclipse.birt.report.model.api.validators.ElementReferenceValidator;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ReferencableStyledElement;
import org.eclipse.birt.report.model.elements.interfaces.IReportItemModel;
import org.eclipse.birt.report.model.elements.strategy.ReportItemPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.ContentIterator;

public abstract class ReportItem
extends ReferencableStyledElement
implements IReportItemModel {
    public ReportItem() {
        this(null);
    }

    public ReportItem(String theName) {
        super(theName);
        this.cachedPropStrategy = ReportItemPropSearchStrategy.getInstance();
    }

    public DesignElement getDataSetElement(Module module) {
        ElementRefValue dataSetRef = (ElementRefValue)this.getProperty(module, "dataSet");
        if (dataSetRef == null) {
            return null;
        }
        return dataSetRef.getElement();
    }

    public DesignElement getCubeElement(Module module) {
        ElementRefValue cubeRef = (ElementRefValue)this.getProperty(module, "cube");
        if (cubeRef == null) {
            return null;
        }
        return cubeRef.getElement();
    }

    public List validate(Module module) {
        List list = super.validate(module);
        list.addAll(ElementReferenceValidator.getInstance().validate(module, this, "dataSet"));
        list.addAll(this.validateStructureList(module, "paramBindings"));
        return list;
    }

    public boolean isDataBindingReferring(Module module) {
        ElementRefValue refValue = (ElementRefValue)this.getLocalProperty(module, "dataBindingRef");
        return refValue != null && refValue.isResolved();
    }

    public Object getProperty(Module module, ElementPropertyDefn prop) {
        String propName = prop.getName();
        if ("cascadeACL".equals(propName) && !this.getDefn().isContainer()) {
            return false;
        }
        return super.getProperty(module, prop);
    }

    public boolean canCascadeACL() {
        return this.getPropertyDefn("cascadeACL") != null && this.getDefn().isContainer();
    }

    public void cacheValues() {
    }

    public void checkExtends(DesignElement parent) throws ExtendsException {
        super.checkExtends(parent);
        Module lib = parent.getRoot();
        this.checkDataBindingReferring(lib, parent);
        ContentIterator iter = new ContentIterator(lib, parent);
        while (iter.hasNext()) {
            DesignElement element = (DesignElement)iter.next();
            this.checkDataBindingReferring(lib, element);
        }
    }

    private void checkDataBindingReferring(Module lib, DesignElement element) throws ExtendsException {
        if (element instanceof ReportItem && ((ReportItem)element).isDataBindingReferring(lib)) {
            throw new ExtendsForbiddenException(null, element, "Error.ExtendsForbiddenException.RESULT_SET_SHARED_CANT_EXTEND");
        }
    }
}

