/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.strategy;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.util.ModelUtil;

public class CopyForPastePolicy
extends CopyPolicy {
    private static final CopyForPastePolicy instance = new CopyForPastePolicy();

    private CopyForPastePolicy() {
    }

    public void execute(DesignElement source, DesignElement destination) {
        if (destination.getExtendsName() == null && !destination.isVirtualElement()) {
            this.clearDisplayName(destination);
            return;
        }
        destination.setExtendsName(null);
        destination.setBaseId(-1L);
        Iterator iter = null;
        DesignElement current = null;
        if (!source.isVirtualElement()) {
            current = source.getExtendsElement();
            while (current != null) {
                if (current.hasUserProperties()) {
                    for (UserPropertyDefn uDefn : current.getLocalUserProperties()) {
                        if (destination.getLocalUserPropertyDefn(uDefn.getName()) != null) continue;
                        destination.addUserPropertyDefn((UserPropertyDefn)uDefn.copy());
                    }
                }
                current = current.getExtendsElement();
            }
        }
        iter = source.getPropertyDefns().iterator();
        Module module = source.getRoot();
        block2: while (iter.hasNext()) {
            String propName;
            ElementPropertyDefn propDefn = (ElementPropertyDefn)iter.next();
            if (!propDefn.canInherit() && !propDefn.isStyleProperty() || "style".equals(propName = propDefn.getName()) || "extends".equals(propName) || "userProperties".equals(propName)) continue;
            if (propDefn.isEncryptable() && source.getLocalEncryptionID(propDefn) == null && source.getLocalProperty(module, propDefn) != null) {
                destination.setEncryptionHelper(propDefn, source.getEncryptionID(propDefn));
                continue;
            }
            Object tmpValue = source.getLocalProperty(module, propDefn);
            if (tmpValue != null) continue;
            current = source.isVirtualElement() ? source.getVirtualParent() : source.getExtendsElement();
            while (current != null) {
                Module tmpRoot = current.getRoot();
                Object value = current.getLocalProperty(tmpRoot, propDefn);
                if (value != null) {
                    String encryptionID;
                    Object copyValue = ModelUtil.copyValue(propDefn, value, this);
                    if (tmpRoot != module && copyValue instanceof ReferenceValue) {
                        assert (tmpRoot instanceof Library);
                        ((ReferenceValue)copyValue).setLibraryNamespace(((Library)tmpRoot).getNamespace());
                    }
                    if ((encryptionID = current.getEncryptionID(propDefn)) != null) {
                        destination.setEncryptionHelper(propDefn, encryptionID);
                        destination.setProperty(propDefn, ModelUtil.encryptProperty(destination, propDefn, encryptionID, copyValue));
                        continue block2;
                    }
                    destination.setProperty(propDefn, copyValue);
                    continue block2;
                }
                DesignElement designElement = current = current.isVirtualElement() ? current.getVirtualParent() : current.getExtendsElement();
            }
        }
        this.clearDisplayName(destination);
    }

    private void clearDisplayName(DesignElement e) {
        if (e.getLocalProperty(null, "displayName") != null) {
            e.setProperty("displayName", null);
        }
        if (e.getLocalProperty(null, "displayNameID") != null) {
            e.setProperty("displayNameID", null);
        }
    }

    public static CopyForPastePolicy getInstance() {
        return instance;
    }
}

