/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import org.eclipse.birt.report.model.api.metadata.IMetaLogger;
import org.eclipse.birt.report.model.metadata.FileMetaLogger;

public final class MetaLogManager {
    private static ArrayList loggers = new ArrayList();

    static {
        MetaLogManager.registerLogger(new FileMetaLogger());
    }

    public static void registerLogger(IMetaLogger logger) {
        if (logger == null) {
            return;
        }
        loggers.add(logger);
    }

    public static boolean removeLogger(IMetaLogger logger) {
        boolean exist = loggers.remove(logger);
        if (exist && logger != null) {
            logger.close();
        }
        return exist;
    }

    public static void log(String message, Throwable t) {
        int i = 0;
        while (i < loggers.size()) {
            ((IMetaLogger)loggers.get(i)).log(message, t);
            ++i;
        }
    }

    static void log(String message) {
        int i = 0;
        while (i < loggers.size()) {
            ((IMetaLogger)loggers.get(i)).log(message);
            ++i;
        }
    }

    public static void shutDown() {
        int i = 0;
        while (i < loggers.size()) {
            ((IMetaLogger)loggers.get(i)).close();
            ++i;
        }
        loggers.clear();
    }
}

