/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.birt.report.model.api.metadata.IObjectDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class ObjectDefn
implements IObjectDefn {
    protected String name = null;
    protected String displayNameKey = null;
    protected Map properties = new LinkedHashMap();
    protected String since;

    public ObjectDefn() {
        this.since = "none";
    }

    public ObjectDefn(String theName) {
        this.name = theName;
    }

    void setDisplayNameKey(String id) {
        this.displayNameKey = id;
    }

    public Object getDisplayNameKey() {
        return this.displayNameKey;
    }

    public String getDisplayName() {
        assert (this.displayNameKey != null);
        return ModelMessages.getMessage(this.displayNameKey);
    }

    public String getName() {
        return this.name;
    }

    void setName(String theName) {
        this.name = theName;
    }

    void addProperty(PropertyDefn property) throws MetaDataException {
        if (property == null) {
            return;
        }
        String name = property.getName();
        assert (name != null && name.trim().length() != 0);
        if (this.properties.containsKey(name)) {
            throw new MetaDataException(new String[]{name, this.name}, "DUPLICATE_PROPERTY");
        }
        this.properties.put(name, property);
        property.setOwner(this);
    }

    public IPropertyDefn findProperty(String propName) {
        assert (propName != null);
        return (PropertyDefn)this.properties.get(propName);
    }

    public Iterator getPropertyIterator() {
        ArrayList propDefns = new ArrayList(this.properties.values());
        return ModelUtil.sortPropertiesByLocalizedName(propDefns).iterator();
    }

    public Iterator propertiesIterator() {
        return new ArrayList(this.properties.values()).iterator();
    }

    protected void buildDefn() throws MetaDataException {
    }

    public void setSince(String value) {
        if (!StringUtil.isBlank(value)) {
            this.since = value;
        }
    }

    public String getSince() {
        return this.since;
    }

    public String toString() {
        if (!StringUtil.isBlank(this.getName())) {
            return this.getName();
        }
        return super.toString();
    }
}

