/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.parser.CompatibleLibraryStylesState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ModuleState;
import org.eclipse.birt.report.model.parser.ParametersState;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.PropertyState;
import org.eclipse.birt.report.model.parser.ThemeState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.xml.sax.SAXException;

public class LibraryState
extends ModuleState {
    public LibraryState(ModuleParserHandler theHandler) {
        super(theHandler);
    }

    public void end() throws SAXException {
        if (this.handler.versionNumber >= 3021600) {
            super.end();
            return;
        }
        Library library = (Library)this.getElement();
        Object themeObj = this.getElement().getLocalProperty(this.module, "theme");
        if (themeObj != null) {
            return;
        }
        Theme theme = null;
        ContainerSlot themes = this.module.getSlot(0);
        int i = 0;
        while (i < themes.getCount()) {
            Theme tmpTheme = (Theme)themes.getContent(i);
            if (ModelMessages.getMessage("Theme.defaultThemeName").equalsIgnoreCase(tmpTheme.getName())) {
                theme = tmpTheme;
                break;
            }
            ++i;
        }
        if (theme == null) {
            theme = new Theme(ModelMessages.getMessage("Theme.defaultThemeName"));
            ModelUtil.insertCompatibleThemeToLibrary(library, theme);
            this.handler.unhandleIDElements.add(theme);
            library.setProperty("theme", (Object)new ElementRefValue(null, theme));
        }
        super.end();
    }

    public AbstractParseState startElement(String tagName) {
        if (this.handler.isReadOnlyModuleProperties) {
            return super.startElement(tagName);
        }
        if (tagName.equalsIgnoreCase("translations")) {
            return new ModuleState.TranslationsState(this);
        }
        if (tagName.equalsIgnoreCase("parameters")) {
            return new ParametersState(this.handler, this.getElement(), 1);
        }
        if (tagName.equalsIgnoreCase("data-sources")) {
            return new ModuleState.DataSourcesState(this.handler, this.getElement(), 2);
        }
        if (tagName.equalsIgnoreCase("data-sets")) {
            return new ModuleState.DataSetsState(this.handler, this.getElement(), 3);
        }
        if (tagName.equalsIgnoreCase("themes")) {
            return new ThemesState();
        }
        if (tagName.equalsIgnoreCase("styles")) {
            return new CompatibleLibraryStylesState(this.handler, this.getElement(), 0);
        }
        if (tagName.equalsIgnoreCase("page-setup")) {
            return new ModuleState.PageSetupState(this.handler, this.getElement(), 4);
        }
        if (tagName.equalsIgnoreCase("components")) {
            return new ModuleState.ComponentsState(this.handler, this.getElement(), 5);
        }
        if (tagName.equalsIgnoreCase("property")) {
            return new PropertyState(this.handler, this.getElement());
        }
        if (tagName.equalsIgnoreCase("cubes")) {
            return new ModuleState.CubesState(this.handler, this.getElement(), 6);
        }
        return super.startElement(tagName);
    }

    class ThemesState
    extends ModuleState.InnerParseState {
        ThemesState() {
            super(LibraryState.this);
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.THEME_TAG == tagValue) {
                return new ThemeState(LibraryState.this.handler, (DesignElement)LibraryState.this.module, 0);
            }
            return super.startElement(tagName);
        }
    }
}

