/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertyStructure;
import org.eclipse.birt.report.model.util.DataTypeConversionUtil;

public class DataSetParameter
extends PropertyStructure {
    public static final String STRUCT_NAME = "DataSetParam";
    public static final String POSITION_MEMBER = "position";
    public static final String NAME_MEMBER = "name";
    public static final String DATA_TYPE_MEMBER = "dataType";
    public static final String IS_OPTIONAL_MEMBER = "isOptional";
    public static final String DEFAULT_VALUE_MEMBER = "defaultValue";
    @Deprecated
    public static final String IS_NULLABLE_MEMBER = "isNullable";
    public static final String ALLOW_NULL_MEMBER = "allowNull";
    public static final String IS_INPUT_MEMBER = "isInput";
    public static final String IS_OUTPUT_MEMBER = "isOutput";
    public static final String NATIVE_DATA_TYPE_MEMBER = "nativeDataType";
    public static final String DISPLAY_NAME_MEMBER = "displayName";
    public static final String DISPLAY_NAME_ID_MEMBER = "displayNameID";
    public static final String HEADING_MEMBER = "heading";
    public static final String HEADING_ID_MEMBER = "headingID";
    public static final String HELP_TEXT_MEMBER = "helpText";
    public static final String HELP_TEXT_ID_MEMBER = "helpTextID";
    public static final String DESCRIPTION_MEMBER = "description";
    public static final String DESCRIPTION_ID_MEMBER = "descriptionID";

    @Override
    public String getStructName() {
        return STRUCT_NAME;
    }

    public boolean isOptional() {
        return (Boolean)this.getProperty(null, IS_OPTIONAL_MEMBER);
    }

    public void setIsOptional(boolean value) {
        this.setProperty(IS_OPTIONAL_MEMBER, (Object)value);
    }

    public void setDefaultValue(String expr) {
        this.setProperty(DEFAULT_VALUE_MEMBER, (Object)expr);
    }

    public String getDefaultValue() {
        return this.getStringProperty(null, DEFAULT_VALUE_MEMBER);
    }

    public boolean isInput() {
        return (Boolean)this.getProperty(null, IS_INPUT_MEMBER);
    }

    public void setIsInput(boolean isInput) {
        this.setProperty(IS_INPUT_MEMBER, (Object)isInput);
    }

    @Deprecated
    public boolean isNullable() {
        return this.allowNull();
    }

    @Deprecated
    public void setIsNullable(boolean isNullable) {
        this.setAllowNull(isNullable);
    }

    public boolean allowNull() {
        return (Boolean)this.getProperty(null, ALLOW_NULL_MEMBER);
    }

    public void setAllowNull(boolean allowNull) {
        this.setProperty(ALLOW_NULL_MEMBER, (Object)allowNull);
    }

    public boolean isOutput() {
        return (Boolean)this.getProperty(null, IS_OUTPUT_MEMBER);
    }

    public void setIsOutput(boolean isOutput) {
        this.setProperty(IS_OUTPUT_MEMBER, (Object)isOutput);
    }

    public String getDataType() {
        String paramType = (String)this.getProperty(null, DATA_TYPE_MEMBER);
        return DataTypeConversionUtil.converToColumnDataType(paramType);
    }

    public void setDataType(String dataType) {
        String paramType = DataTypeConversionUtil.converToParamType(dataType);
        this.setProperty(DATA_TYPE_MEMBER, (Object)paramType);
    }

    public String getName() {
        return this.getStringProperty(null, NAME_MEMBER);
    }

    public void setName(String name) {
        this.setProperty(NAME_MEMBER, (Object)name);
    }

    public Integer getPosition() {
        return (Integer)this.getProperty(null, POSITION_MEMBER);
    }

    public void setPosition(Integer position) {
        this.setProperty(POSITION_MEMBER, (Object)position);
    }

    @Override
    public StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new DataSetParameterHandle(valueHandle, index);
    }

    public List validate(Module module, DesignElement element) {
        ArrayList<PropertyValueException> list = new ArrayList<PropertyValueException>();
        if (StringUtil.isBlank(this.getName())) {
            list.add(new PropertyValueException(element, this.getDefn().getMember(NAME_MEMBER), (Object)this.getName(), "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }

    public Integer getNativeDataType() {
        return (Integer)this.getProperty(null, NATIVE_DATA_TYPE_MEMBER);
    }

    public void setNativeDataType(Integer dataType) {
        this.setProperty(NATIVE_DATA_TYPE_MEMBER, (Object)dataType);
    }

    public String getParameterDataType() {
        return this.getStringProperty(null, DATA_TYPE_MEMBER);
    }

    public void setParameterDataType(String dataType) {
        this.setProperty(DATA_TYPE_MEMBER, (Object)dataType);
    }

    public String getDisplayName() {
        return this.getStringProperty(null, DISPLAY_NAME_MEMBER);
    }

    public void setDisplayName(String displayName) {
        this.setProperty(DISPLAY_NAME_MEMBER, (Object)displayName);
    }

    public String getDisplayNameKey() {
        return this.getStringProperty(null, DISPLAY_NAME_ID_MEMBER);
    }

    public void setDisplayNameKey(String displayNameID) {
        this.setProperty(DISPLAY_NAME_ID_MEMBER, (Object)displayNameID);
    }

    public String getHeading() {
        return this.getStringProperty(null, HEADING_MEMBER);
    }

    public void setHeading(String heading) {
        this.setProperty(HEADING_MEMBER, (Object)heading);
    }

    public String getHeadingKey() {
        return this.getStringProperty(null, HEADING_ID_MEMBER);
    }

    public void setHeadingKey(String headingID) {
        this.setProperty(HEADING_ID_MEMBER, (Object)headingID);
    }

    public String getHelpText() {
        return this.getStringProperty(null, HELP_TEXT_MEMBER);
    }

    public void setHelpText(String helpText) {
        this.setProperty(HELP_TEXT_MEMBER, (Object)helpText);
    }

    public String getHelpTextKey() {
        return this.getStringProperty(null, HELP_TEXT_ID_MEMBER);
    }

    public void setHelpTextKey(String helpTextID) {
        this.setProperty(HELP_TEXT_ID_MEMBER, (Object)helpTextID);
    }

    public String getDescription() {
        return this.getStringProperty(null, DESCRIPTION_MEMBER);
    }

    public void setDescription(String description) {
        this.setProperty(DESCRIPTION_MEMBER, (Object)description);
    }

    public String getDescriptionKey() {
        return this.getStringProperty(null, DESCRIPTION_ID_MEMBER);
    }

    public void setDescriptionKey(String descriptionID) {
        this.setProperty(DESCRIPTION_ID_MEMBER, (Object)descriptionID);
    }
}

