/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.metadata.ArgumentInfo;
import org.eclipse.birt.report.model.metadata.ArgumentInfoList;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ClassInfo;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MemberInfo;
import org.eclipse.birt.report.model.metadata.MetaDataBuilder;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataErrorHandler;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MethodInfo;
import org.eclipse.birt.report.model.metadata.NameConfig;
import org.eclipse.birt.report.model.metadata.NameSpaceFactory;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.SemanticTriggerDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;
import org.eclipse.birt.report.model.metadata.validators.SimpleValueValidator;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ErrorHandler;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.eclipse.birt.report.model.validators.AbstractSemanticValidator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MetaDataHandlerImpl
extends XMLParserHandler {
    MetaDataDictionary dictionary = MetaDataDictionary.getInstance();
    protected static final String PROPERTY_TAG = "Property";
    protected static final String ELEMENT_TAG = "Element";
    protected static final String NAME_ATTRIB = "name";
    protected static final String METHOD_TAG = "Method";
    protected static final String PROPERTY_GROUP_TAG = "PropertyGroup";
    private static final String ROOT_TAG = "ReportMetaData";
    private static final String STYLE_TAG = "Style";
    private static final String STYLE_PROPERTY_TAG = "StyleProperty";
    private static final String SLOT_TAG = "Slot";
    private static final String TYPE_TAG = "Type";
    private static final String DEFAULT_TAG = "Default";
    private static final String CHOICE_TAG = "Choice";
    private static final String CHOICE_TYPE_TAG = "ChoiceType";
    private static final String STRUCTURE_TAG = "Structure";
    private static final String ALLOWED_TAG = "Allowed";
    private static final String ALLOWED_UNITS_TAG = "AllowedUnits";
    private static final String MEMBER_TAG = "Member";
    private static final String VALUE_VALIDATOR_TAG = "ValueValidator";
    private static final String VALIDATORS_TAG = "Validators";
    private static final String ARGUMENT_TAG = "Argument";
    private static final String CLASS_TAG = "Class";
    private static final String CONSTRUCTOR_TAG = "Constructor";
    private static final String SEMANTIC_VALIDATOR_TAG = "SemanticValidator";
    private static final String TRIGGER_TAG = "Trigger";
    private static final String DEFAULT_UNIT_TAG = "DefaultUnit";
    private static final String PROPERTY_VISIBILITY_TAG = "PropertyVisibility";
    private static final String DISPLAY_NAME_ID_ATTRIB = "displayNameID";
    private static final String EXTENDS_ATTRIB = "extends";
    private static final String TYPE_ATTRIB = "type";
    private static final String SUB_TYPE_ATTRIB = "subType";
    private static final String HAS_STYLE_ATTRIB = "hasStyle";
    private static final String SELECTOR_ATTRIB = "selector";
    private static final String ALLOWS_USER_PROPERTIES_ATTRIB = "allowsUserProperties";
    private static final String CAN_EXTEND_ATTRIB = "canExtend";
    private static final String MULTIPLE_CARDINALITY_ATTRIB = "multipleCardinality";
    private static final String IS_MANAGED_BY_NAME_SPACE_ATTRIB = "isManagedByNameSpace";
    private static final String CAN_INHERIT_ATTRIBUTE = "canInherit";
    private static final String IS_INTRINSIC_ATTRIB = "isIntrinsic";
    private static final String IS_STYLE_PROPERTY_ATTRIB = "isStyleProperty";
    private static final String IS_LIST_ATTRIB = "isList";
    private static final String NAME_SPACE_ATTRIB = "nameSpace";
    private static final String IS_NAME_REQUIRED_ATTRIB = "isNameRequired";
    private static final String IS_ABSTRACT_ATTRIB = "isAbstract";
    private static final String DETAIL_TYPE_ATTRIB = "detailType";
    private static final String JAVA_CLASS_ATTRIB = "javaClass";
    private static final String TOOL_TIP_ID_ATTRIB = "toolTipID";
    private static final String RETURN_TYPE_ATTRIB = "returnType";
    private static final String TAG_ID_ATTRIB = "tagID";
    private static final String DATA_TYPE_ATTRIB = "dataType";
    private static final String IS_STATIC_ATTRIB = "isStatic";
    private static final String VALIDATOR_ATTRIB = "validator";
    private static final String CLASS_ATTRIB = "class";
    private static final String NATIVE_ATTRIB = "native";
    private static final String PRE_REQUISITE_ATTRIB = "preRequisite";
    private static final String TARGET_ELEMENT_ATTRIB = "targetElement";
    private static final String VALUE_REQUIRED_ATTRIB = "valueRequired";
    private static final String PROPERTY_VISIBILITY_ATTRIB = "visibility";
    private static final String SINCE_ATTRIB = "since";
    private static final String XML_NAME_ATTRIB = "xmlName";
    private static final String RUNTIME_SETTABLE_ATTRIB = "runtimeSettable";
    private static final String TRIM_OPTION_ATTRIB = "trimOption";
    private static final String CONTEXT_ATTRIB = "context";
    private static final String MODULES_ATTRIB = "modules";
    private static final String IS_BIDI_PROPERTY_ATTRIB = "isBidiProperty";
    private static final String ALLOW_EXPRESSION_ATTRIB = "allowExpression";
    private static final String ID_ATTRIB = "id";
    private static final String THIS_KEYWORD = "this";
    private String groupNameID;
    protected ElementDefn elementDefn = null;
    protected SlotDefn slotDefn = null;
    protected SystemPropertyDefn propDefn = null;
    protected StructureDefn struct = null;
    protected ArrayList<Choice> choices = new ArrayList();
    private static final String NO_TRIM = "noTrim";
    private static final String TRIM_SPACE = "trimSpace";
    private static final String TRIM_EMPTY_TO_NULL = "trimEmptyToNull";
    protected boolean checkDisplayNameID = true;
    protected MetaDataBuilder builder;

    public MetaDataHandlerImpl() {
        this(new MetaDataErrorHandler(), new MetaDataBuilder());
    }

    public MetaDataHandlerImpl(ErrorHandler errorHandler, MetaDataBuilder builder) {
        super(errorHandler);
        this.builder = builder;
    }

    @Override
    public AbstractParseState createStartState() {
        return new StartState();
    }

    private Choice[] getChoiceArray() {
        Choice[] choiceArray = new Choice[this.choices.size()];
        int i = 0;
        while (i < this.choices.size()) {
            choiceArray[i] = this.choices.get(i);
            ++i;
        }
        return choiceArray;
    }

    private ChoiceSet validateChoiceSet(String choiceSetName) {
        IChoiceSet choiceSet = this.dictionary.getChoiceSet(choiceSetName);
        if (choiceSet == null) {
            this.errorHandler.semanticError(new MetaDataParserException("INVALID_CHOICE_TYPE"));
            return null;
        }
        return (ChoiceSet)choiceSet;
    }

    private int handleTrimOption(String trimOption) throws MetaDataParserException {
        String[] options = trimOption.split(";");
        int value = 0;
        int i = 0;
        while (i < options.length) {
            String option = options[i];
            if (NO_TRIM.equals(option)) {
                value |= 1;
            } else if (TRIM_SPACE.equals(option)) {
                value |= 2;
            } else if (TRIM_EMPTY_TO_NULL.equals(option)) {
                value |= 4;
            } else {
                throw new MetaDataParserException("INVALID_TRIM_OPTION");
            }
            ++i;
        }
        return value;
    }

    @Override
    public void endDocument() throws MetaDataParserException {
        if (!this.errorHandler.getErrors().isEmpty()) {
            throw new MetaDataParserException(this.errorHandler.getErrors());
        }
        try {
            this.dictionary.build();
        }
        catch (MetaDataException e) {
            this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
            throw new MetaDataParserException(this.errorHandler.getErrors());
        }
    }

    abstract class AbstractMethodState
    extends XMLParserHandler.InnerParseState {
        protected Object owner = null;
        protected MethodInfo methodInfo = null;
        private ArgumentInfoList argumentList = null;

        AbstractMethodState(Object obj) {
            assert (obj != null);
            this.owner = obj;
        }

        abstract void addDefnTo();

        abstract MethodInfo getMethodInfo(String var1);

        @Override
        public void parseAttrs(Attributes attrs) {
            String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
            String displayNameID = attrs.getValue(MetaDataHandlerImpl.DISPLAY_NAME_ID_ATTRIB);
            String toolTipID = attrs.getValue(MetaDataHandlerImpl.TOOL_TIP_ID_ATTRIB);
            String returnType = attrs.getValue(MetaDataHandlerImpl.RETURN_TYPE_ATTRIB);
            boolean isStatic = this.getBooleanAttrib(attrs, MetaDataHandlerImpl.IS_STATIC_ATTRIB, false);
            boolean ok = true;
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (MetaDataHandlerImpl.this.checkDisplayNameID && StringUtil.isBlank(displayNameID)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                ok = false;
            }
            if (!ok) {
                return;
            }
            this.methodInfo = this.getMethodInfo(name);
            this.methodInfo.setName(name);
            this.methodInfo.setDisplayNameKey(displayNameID);
            this.methodInfo.setReturnType(returnType);
            this.methodInfo.setToolTipKey(toolTipID);
            this.methodInfo.setStatic(isStatic);
            this.addDefnTo();
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.ARGUMENT_TAG)) {
                return new ArgumentState();
            }
            return super.startElement(tagName);
        }

        @Override
        public void end() throws SAXException {
            if (this.argumentList == null) {
                this.argumentList = new ArgumentInfoList();
            }
            this.methodInfo.addArgumentList(this.argumentList);
            this.methodInfo = null;
            MetaDataHandlerImpl.this.propDefn = null;
        }

        class ArgumentState
        extends XMLParserHandler.InnerParseState {
            ArgumentState() {
            }

            @Override
            public void parseAttrs(Attributes attrs) {
                String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
                String tagID = attrs.getValue(MetaDataHandlerImpl.TAG_ID_ATTRIB);
                String type = attrs.getValue(MetaDataHandlerImpl.TYPE_ATTRIB);
                if (type == null) {
                    type = attrs.getValue(MetaDataHandlerImpl.DATA_TYPE_ATTRIB);
                }
                if (name == null) {
                    return;
                }
                ArgumentInfo argument = ((AbstractMethodState)AbstractMethodState.this).MetaDataHandlerImpl.this.builder.createArgumentInfo();
                argument.setName(name);
                argument.setType(type);
                argument.setDisplayNameKey(tagID);
                if (AbstractMethodState.this.argumentList == null) {
                    AbstractMethodState.this.argumentList = new ArgumentInfoList();
                }
                try {
                    AbstractMethodState.this.argumentList.addArgument(argument);
                }
                catch (MetaDataException e) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
        }
    }

    class AllowedState
    extends XMLParserHandler.InnerParseState {
        PropertyDefn tmpPropDefn;

        AllowedState(PropertyDefn tmpPropDefn) {
            this.tmpPropDefn = tmpPropDefn;
        }

        @Override
        public void end() throws SAXException {
            if (this.tmpPropDefn == null) {
                return;
            }
            int type = this.tmpPropDefn.getTypeCode();
            if (type != 3 && type != 5) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("RESTRICTION_NOT_ALLOWED"));
                return;
            }
            ChoiceSet allowedChoices = MetaDataHandlerImpl.this.builder.createChoiceSet();
            ArrayList<IChoice> allowedList = new ArrayList<IChoice>();
            String choicesStr = StringUtil.trimString(this.text.toString());
            if (choicesStr == null) {
                return;
            }
            String[] nameArray = choicesStr.split(",");
            if (type == 3) {
                IChoiceSet units = MetaDataHandlerImpl.this.dictionary.getChoiceSet("units");
                assert (units != null);
                int i = 0;
                while (i < nameArray.length) {
                    IChoice unit = units.findChoice(nameArray[i].trim());
                    if (unit == null) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_RESTRICTION"));
                        return;
                    }
                    allowedList.add(unit);
                    ++i;
                }
            } else {
                IChoiceSet choices = this.tmpPropDefn.getChoices();
                assert (choices != null);
                int i = 0;
                while (i < nameArray.length) {
                    IChoice choice = choices.findChoice(nameArray[i].trim());
                    if (choice == null) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_RESTRICTION"));
                        return;
                    }
                    allowedList.add(choice);
                    ++i;
                }
            }
            allowedChoices.setChoices(allowedList.toArray(new Choice[allowedList.size()]));
            this.tmpPropDefn.setAllowedChoices(allowedChoices);
        }
    }

    private class AllowedUnitsState
    extends XMLParserHandler.InnerParseState {
        PropertyDefn tmpPropDefn;

        AllowedUnitsState(PropertyDefn tmpPropDefn) {
            this.tmpPropDefn = tmpPropDefn;
        }

        @Override
        public void end() throws SAXException {
            if (this.tmpPropDefn == null) {
                return;
            }
            int type = this.tmpPropDefn.getTypeCode();
            if (type != 3 && (type != 20 || this.tmpPropDefn.getSubTypeCode() != 3)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("RESTRICTION_NOT_ALLOWED"));
                return;
            }
            ChoiceSet allowedChoices = MetaDataHandlerImpl.this.builder.createChoiceSet();
            ArrayList<IChoice> allowedList = new ArrayList<IChoice>();
            String choicesStr = StringUtil.trimString(this.text.toString());
            if (choicesStr == null) {
                return;
            }
            String[] nameArray = choicesStr.split(",");
            IChoiceSet units = MetaDataHandlerImpl.this.dictionary.getChoiceSet("units");
            assert (units != null);
            int i = 0;
            while (i < nameArray.length) {
                IChoice unit = units.findChoice(nameArray[i].trim());
                if (unit == null) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_RESTRICTION"));
                    return;
                }
                allowedList.add(unit);
                ++i;
            }
            allowedChoices.setChoices(allowedList.toArray(new Choice[allowedList.size()]));
            this.tmpPropDefn.setAllowedUnits(allowedChoices);
        }
    }

    class ChoiceState
    extends XMLParserHandler.InnerParseState {
        ChoiceState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String displayNameID = attrs.getValue(MetaDataHandlerImpl.DISPLAY_NAME_ID_ATTRIB);
            String xmlName = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
            if (MetaDataHandlerImpl.this.checkDisplayNameID && StringUtil.isBlank(displayNameID)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
            } else if (StringUtil.isBlank(xmlName)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("XML_NAME_REQUIRED"));
            } else {
                Choice choice = MetaDataHandlerImpl.this.builder.createChoice();
                choice.setName(xmlName);
                choice.setDisplayNameKey(displayNameID);
                boolean found = false;
                for (Choice tmpChoice : MetaDataHandlerImpl.this.choices) {
                    if (!tmpChoice.getName().equalsIgnoreCase(choice.getName())) continue;
                    found = true;
                    break;
                }
                if (found) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DUPLICATE_CHOICE_NAME"));
                } else {
                    MetaDataHandlerImpl.this.choices.add(choice);
                }
            }
        }
    }

    public class ChoiceTypeState
    extends XMLParserHandler.InnerParseState {
        ChoiceSet choiceSet = null;

        @Override
        public void parseAttrs(Attributes attrs) throws XMLParserException {
            MetaDataHandlerImpl.this.choices.clear();
            String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
            } else {
                this.choiceSet = MetaDataHandlerImpl.this.builder.createChoiceSet();
                this.choiceSet.setName(name);
                try {
                    MetaDataHandlerImpl.this.builder.addChoiceSet(this.choiceSet);
                }
                catch (MetaDataException e) {
                    this.choiceSet = null;
                    MetaDataHandlerImpl.this.errorHandler.semanticError((Exception)((Object)e));
                }
            }
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.CHOICE_TAG)) {
                return new ChoiceState();
            }
            return super.startElement(tagName);
        }

        @Override
        public void end() throws SAXException {
            if (!MetaDataHandlerImpl.this.choices.isEmpty() && this.choiceSet != null) {
                this.choiceSet.setChoices(MetaDataHandlerImpl.this.getChoiceArray());
            }
        }
    }

    class ClassMethodState
    extends AbstractMethodState {
        private boolean isConstructor;

        ClassMethodState(Object obj, boolean isConstructor) {
            super(obj);
            this.isConstructor = false;
            this.isConstructor = isConstructor;
        }

        @Override
        MethodInfo getMethodInfo(String name) {
            ClassInfo classInfo = (ClassInfo)this.owner;
            if (classInfo != null) {
                this.methodInfo = this.isConstructor ? (MethodInfo)classInfo.getConstructor() : classInfo.findMethod(name);
            }
            if (this.methodInfo == null) {
                this.methodInfo = MetaDataHandlerImpl.this.builder.createMethodInfo(this.isConstructor);
            }
            return this.methodInfo;
        }

        @Override
        void addDefnTo() {
            assert (this.owner instanceof ClassInfo);
            ClassInfo classInfo = (ClassInfo)this.owner;
            try {
                MetaDataHandlerImpl.this.builder.addMethodInfo(classInfo, this.methodInfo);
            }
            catch (MetaDataException e) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
            }
        }
    }

    protected class ClassState
    extends XMLParserHandler.InnerParseState {
        protected ClassInfo classInfo = null;

        protected ClassState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) {
            String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
            String displayNameID = attrs.getValue(MetaDataHandlerImpl.DISPLAY_NAME_ID_ATTRIB);
            String toolTipID = attrs.getValue(MetaDataHandlerImpl.TOOL_TIP_ID_ATTRIB);
            String isNative = attrs.getValue(MetaDataHandlerImpl.NATIVE_ATTRIB);
            boolean ok = true;
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (MetaDataHandlerImpl.this.checkDisplayNameID && StringUtil.isBlank(displayNameID)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                ok = false;
            }
            if (!ok) {
                return;
            }
            this.classInfo = MetaDataHandlerImpl.this.builder.createClassInfo();
            this.classInfo.setName(name);
            this.classInfo.setDisplayNameKey(displayNameID);
            this.classInfo.setToolTipKey(toolTipID);
            if (Boolean.TRUE.toString().equalsIgnoreCase(isNative)) {
                this.classInfo.setNative(true);
            } else if (Boolean.FALSE.toString().equalsIgnoreCase(isNative)) {
                this.classInfo.setNative(false);
            }
            try {
                MetaDataHandlerImpl.this.builder.addClassInfo(this.classInfo);
            }
            catch (MetaDataException e) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
            }
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.CONSTRUCTOR_TAG)) {
                return new ClassMethodState(this.classInfo, true);
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.MEMBER_TAG)) {
                return new MemberState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.METHOD_TAG)) {
                return new ClassMethodState(this.classInfo, false);
            }
            return super.startElement(tagName);
        }

        @Override
        public void end() throws SAXException {
            super.end();
            this.classInfo = null;
        }

        protected class MemberState
        extends XMLParserHandler.InnerParseState {
            protected MemberState() {
            }

            @Override
            public void parseAttrs(Attributes attrs) {
                String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
                String displayNameID = attrs.getValue(MetaDataHandlerImpl.DISPLAY_NAME_ID_ATTRIB);
                String toolTipID = attrs.getValue(MetaDataHandlerImpl.TOOL_TIP_ID_ATTRIB);
                String dataType = attrs.getValue(MetaDataHandlerImpl.DATA_TYPE_ATTRIB);
                boolean ok = true;
                if (StringUtil.isBlank(name)) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                    ok = false;
                }
                if (((ClassState)ClassState.this).MetaDataHandlerImpl.this.checkDisplayNameID && StringUtil.isBlank(displayNameID)) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                    ok = false;
                }
                if (dataType == null) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DATA_TYPE_REQUIRED"));
                    ok = false;
                }
                if (!ok) {
                    return;
                }
                MemberInfo memberDefn = ((ClassState)ClassState.this).MetaDataHandlerImpl.this.builder.createMemberInfo();
                memberDefn.setName(name);
                memberDefn.setDisplayNameKey(displayNameID);
                memberDefn.setToolTipKey(toolTipID);
                memberDefn.setDataType(dataType);
                memberDefn.setStatic(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.IS_STATIC_ATTRIB, false));
                try {
                    ((ClassState)ClassState.this).MetaDataHandlerImpl.this.builder.addMemberInfo(ClassState.this.classInfo, memberDefn);
                }
                catch (MetaDataException e) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
        }
    }

    class DefaultUnitState
    extends XMLParserHandler.InnerParseState {
        DefaultUnitState() {
        }

        @Override
        public void end() throws SAXException {
            if (MetaDataHandlerImpl.this.propDefn == null) {
                return;
            }
            int type = MetaDataHandlerImpl.this.propDefn.getTypeCode();
            if (type != 3) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DEFAULT_UNIT_NOT_ALLOWED"));
                return;
            }
            MetaDataHandlerImpl.this.propDefn.setDefaultUnit(this.text.toString());
        }
    }

    class DefaultValueState
    extends XMLParserHandler.InnerParseState {
        PropertyDefn propertyDefn = null;

        DefaultValueState(PropertyDefn propDefn) {
            this.propertyDefn = propDefn;
        }

        @Override
        public void end() throws SAXException {
            if (this.propertyDefn == null) {
                return;
            }
            this.propertyDefn.setDefault(this.text.toString());
        }
    }

    public class ElementDefnState
    extends XMLParserHandler.InnerParseState {
        protected ElementDefn createElementDefn() {
            return MetaDataHandlerImpl.this.builder.createElementDefn();
        }

        @Override
        public void parseAttrs(Attributes attrs) {
            String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
            String displayNameID = attrs.getValue(MetaDataHandlerImpl.DISPLAY_NAME_ID_ATTRIB);
            boolean ok = true;
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (MetaDataHandlerImpl.this.checkDisplayNameID && StringUtil.isBlank(displayNameID)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                ok = false;
            }
            if (!ok) {
                return;
            }
            MetaDataHandlerImpl.this.elementDefn = this.createElementDefn();
            MetaDataHandlerImpl.this.elementDefn.setName(name);
            MetaDataHandlerImpl.this.elementDefn.setAbstract(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.IS_ABSTRACT_ATTRIB, false));
            MetaDataHandlerImpl.this.elementDefn.setDisplayNameKey(displayNameID);
            MetaDataHandlerImpl.this.elementDefn.setExtends(attrs.getValue(MetaDataHandlerImpl.EXTENDS_ATTRIB));
            MetaDataHandlerImpl.this.elementDefn.setHasStyle(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.HAS_STYLE_ATTRIB, false));
            MetaDataHandlerImpl.this.elementDefn.setSelector(attrs.getValue(MetaDataHandlerImpl.SELECTOR_ATTRIB));
            MetaDataHandlerImpl.this.elementDefn.setAllowsUserProperties(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.ALLOWS_USER_PROPERTIES_ATTRIB, true));
            MetaDataHandlerImpl.this.elementDefn.setJavaClass(attrs.getValue(MetaDataHandlerImpl.JAVA_CLASS_ATTRIB));
            MetaDataHandlerImpl.this.elementDefn.setCanExtend(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.CAN_EXTEND_ATTRIB, true));
            MetaDataHandlerImpl.this.elementDefn.setSince(attrs.getValue(MetaDataHandlerImpl.SINCE_ATTRIB));
            MetaDataHandlerImpl.this.elementDefn.setXmlName(attrs.getValue(MetaDataHandlerImpl.XML_NAME_ATTRIB));
            String nameRequired = attrs.getValue(MetaDataHandlerImpl.IS_NAME_REQUIRED_ATTRIB);
            if (nameRequired != null) {
                boolean flag = this.parseBoolean(nameRequired, false);
                MetaDataHandlerImpl.this.elementDefn.setNameOption(flag ? 2 : 1);
            }
            String ns = attrs.getValue(MetaDataHandlerImpl.NAME_SPACE_ATTRIB);
            IElementDefn moduleDefn = MetaDataHandlerImpl.this.dictionary.getElement("Module");
            if (ns != null && ns.trim().length() != 0) {
                if (ns.equalsIgnoreCase("style")) {
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.nameSpaceID = "style";
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.holder = moduleDefn;
                } else if (ns.equalsIgnoreCase("theme")) {
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.nameSpaceID = "theme";
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.holder = moduleDefn;
                } else if (ns.equalsIgnoreCase("dataSet")) {
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.nameSpaceID = "dataset";
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.holder = moduleDefn;
                } else if (ns.equalsIgnoreCase("dataSource")) {
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.nameSpaceID = "datasource";
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.holder = moduleDefn;
                } else if (ns.equalsIgnoreCase("element")) {
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.nameSpaceID = "element";
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.holder = moduleDefn;
                } else if (ns.equalsIgnoreCase("parameter")) {
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.nameSpaceID = "parameter";
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.holder = moduleDefn;
                } else if (ns.equalsIgnoreCase("masterPage")) {
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.nameSpaceID = "page";
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.holder = moduleDefn;
                } else if (ns.equalsIgnoreCase("cube")) {
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.nameSpaceID = "cube";
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.holder = moduleDefn;
                } else if (ns.equalsIgnoreCase("templateParameterDefinition")) {
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.nameSpaceID = "template";
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.holder = moduleDefn;
                } else if (ns.equalsIgnoreCase("dimension")) {
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.nameSpaceID = "dimension";
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.holder = moduleDefn;
                } else if (ns.equalsIgnoreCase("none")) {
                    MetaDataHandlerImpl.this.elementDefn.nameConfig.nameSpaceID = "NONE";
                } else if (ns.startsWith("(") && ns.endsWith(")")) {
                    String nsValue = ns.substring(1, ns.length() - 1);
                    String[] splitStrings = nsValue.split(",");
                    if (splitStrings == null || splitStrings.length != 2 && splitStrings.length != 3) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError((Exception)((Object)new MetaDataException("INVALID_NAME_SPACE")));
                    } else {
                        int length = splitStrings.length;
                        assert (length == 2 || length == 3);
                        String holderName = StringUtil.trimString(splitStrings[0]);
                        String nameSpace = StringUtil.trimString(splitStrings[1]);
                        ElementDefn holderDefn = (ElementDefn)MetaDataHandlerImpl.this.dictionary.getElement(holderName);
                        if (holderDefn == null) {
                            MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_NAME_SPACE"));
                        } else {
                            MetaDataHandlerImpl.this.elementDefn.nameConfig.holder = holderDefn;
                            MetaDataHandlerImpl.this.elementDefn.nameConfig.nameSpaceID = NameSpaceFactory.getInstance().getNameSpaceID(holderName, nameSpace);
                            if (length == 3) {
                                MetaDataHandlerImpl.this.elementDefn.nameConfig.targetPropertyName = StringUtil.trimString(splitStrings[2]);
                            }
                        }
                    }
                } else {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_NAME_SPACE"));
                }
            }
            try {
                MetaDataHandlerImpl.this.builder.addElementDefn(MetaDataHandlerImpl.this.elementDefn);
            }
            catch (MetaDataException e) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
            }
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.PROPERTY_TAG)) {
                return new PropertyState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.PROPERTY_GROUP_TAG)) {
                return new PropertyGroupState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.STYLE_PROPERTY_TAG)) {
                return new StylePropertyState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.SLOT_TAG)) {
                return new SlotState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.METHOD_TAG)) {
                return new ElementMethodState(MetaDataHandlerImpl.this.elementDefn);
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.SEMANTIC_VALIDATOR_TAG)) {
                return new TriggerState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.PROPERTY_VISIBILITY_TAG)) {
                return new PropertyVisibilityState();
            }
            return super.startElement(tagName);
        }

        @Override
        public void end() throws SAXException {
            super.end();
            MetaDataHandlerImpl.this.elementDefn = null;
        }

        private class PropertyVisibilityState
        extends XMLParserHandler.InnerParseState {
            private PropertyVisibilityState() {
            }

            @Override
            public void parseAttrs(Attributes attrs) {
                String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
                String visible = attrs.getValue(MetaDataHandlerImpl.PROPERTY_VISIBILITY_ATTRIB);
                if (StringUtil.isBlank(name)) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                    return;
                }
                ((ElementDefnState)ElementDefnState.this).MetaDataHandlerImpl.this.elementDefn.addPropertyVisibility(name, visible);
            }
        }
    }

    class ElementMethodState
    extends AbstractMethodState {
        SystemPropertyDefn localPropDefn;

        @Override
        MethodInfo getMethodInfo(String name) {
            return new MethodInfo(false);
        }

        ElementMethodState(Object obj) {
            super(obj);
            this.localPropDefn = null;
            this.localPropDefn = MetaDataHandlerImpl.this.builder.createPropertyDefn();
        }

        @Override
        public void parseAttrs(Attributes attrs) {
            super.parseAttrs(attrs);
            this.localPropDefn.setValueRequired(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.VALUE_REQUIRED_ATTRIB, false));
            this.localPropDefn.setSince(attrs.getValue(MetaDataHandlerImpl.SINCE_ATTRIB));
            this.localPropDefn.setContext(attrs.getValue(MetaDataHandlerImpl.CONTEXT_ATTRIB));
            this.localPropDefn.setReturnType(attrs.getValue(MetaDataHandlerImpl.RETURN_TYPE_ATTRIB));
        }

        @Override
        final void addDefnTo() {
            assert (this.owner instanceof ElementDefn);
            PropertyType typeDefn = MetaDataHandlerImpl.this.dictionary.getPropertyType(18);
            String name = this.methodInfo.getName();
            String displayNameID = this.methodInfo.getDisplayNameKey();
            this.localPropDefn.setName(name);
            this.localPropDefn.setDisplayNameID(displayNameID);
            this.localPropDefn.setType(typeDefn);
            this.localPropDefn.setGroupNameKey(null);
            this.localPropDefn.setCanInherit(true);
            this.localPropDefn.setIntrinsic(false);
            this.localPropDefn.setStyleProperty(false);
            this.localPropDefn.setDetails(this.methodInfo);
            try {
                MetaDataHandlerImpl.this.builder.addPropertyDefn((ElementDefn)this.owner, this.localPropDefn);
            }
            catch (MetaDataException e) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
            }
        }
    }

    protected class MemberState
    extends XMLParserHandler.InnerParseState {
        StructPropertyDefn memberDefn = null;

        protected MemberState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) {
            boolean ok;
            String name = this.getAttrib(attrs, MetaDataHandlerImpl.NAME_ATTRIB);
            String displayNameID = this.getAttrib(attrs, MetaDataHandlerImpl.DISPLAY_NAME_ID_ATTRIB);
            String type = this.getAttrib(attrs, MetaDataHandlerImpl.TYPE_ATTRIB);
            String validator = this.getAttrib(attrs, MetaDataHandlerImpl.VALIDATOR_ATTRIB);
            String subType = this.getAttrib(attrs, MetaDataHandlerImpl.SUB_TYPE_ATTRIB);
            boolean bl = ok = MetaDataHandlerImpl.this.struct != null;
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (StringUtil.isBlank(displayNameID)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                ok = false;
            }
            if (StringUtil.isBlank(type)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("TYPE_REQUIRED"));
                ok = false;
            }
            if (!ok) {
                return;
            }
            PropertyType typeDefn = MetaDataHandlerImpl.this.dictionary.getPropertyType(type);
            if (typeDefn == null) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_TYPE"));
                return;
            }
            if (!ok) {
                return;
            }
            String detailName = this.getAttrib(attrs, MetaDataHandlerImpl.DETAIL_TYPE_ATTRIB);
            ChoiceSet choiceSet = null;
            String structDefn = null;
            PropertyType subTypeDefn = null;
            switch (typeDefn.getTypeCode()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 11: 
                case 14: 
                case 21: {
                    if (detailName == null || (choiceSet = MetaDataHandlerImpl.this.validateChoiceSet(detailName)) != null) break;
                    return;
                }
                case 5: {
                    if (detailName == null) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("CHOICE_TYPE_REQUIRED"));
                        return;
                    }
                    choiceSet = MetaDataHandlerImpl.this.validateChoiceSet(detailName);
                    if (choiceSet != null) break;
                    return;
                }
                case 4: {
                    choiceSet = MetaDataHandlerImpl.this.validateChoiceSet("colors");
                    if (choiceSet != null) break;
                    return;
                }
                case 16: 
                case 19: {
                    if (detailName == null) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("STRUCT_TYPE_REQUIRED"));
                        return;
                    }
                    structDefn = detailName;
                    break;
                }
                case 15: {
                    if (detailName == null) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("ELEMENT_REF_TYPE_REQUIRED"));
                        return;
                    }
                    if (!detailName.equals(MetaDataHandlerImpl.THIS_KEYWORD)) break;
                    detailName = MetaDataHandlerImpl.this.elementDefn.getName();
                    break;
                }
                case 20: {
                    if (subType == null) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("MISSING_SUB_TYPE"));
                        break;
                    }
                    subTypeDefn = MetaDataHandlerImpl.this.dictionary.getPropertyType(subType);
                    if (subTypeDefn == null) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_TYPE"));
                        return;
                    }
                    if (subTypeDefn.getTypeCode() != 15) break;
                    if (detailName == null) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("ELEMENT_REF_TYPE_REQUIRED"));
                        return;
                    }
                    if (!detailName.equals(MetaDataHandlerImpl.THIS_KEYWORD)) break;
                    detailName = MetaDataHandlerImpl.this.elementDefn.getName();
                }
            }
            this.memberDefn = new StructPropertyDefn();
            this.memberDefn.setName(name);
            this.memberDefn.setType(typeDefn);
            if (subTypeDefn != null && typeDefn.getTypeCode() == 20) {
                this.memberDefn.setSubType(subTypeDefn);
            }
            this.memberDefn.setDisplayNameID(displayNameID);
            this.memberDefn.setValueRequired(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.VALUE_REQUIRED_ATTRIB, false));
            this.memberDefn.setSince(attrs.getValue(MetaDataHandlerImpl.SINCE_ATTRIB));
            this.memberDefn.setRuntimeSettable(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.RUNTIME_SETTABLE_ATTRIB, true));
            String trimOption = attrs.getValue(MetaDataHandlerImpl.TRIM_OPTION_ATTRIB);
            if (trimOption != null) {
                try {
                    int value = MetaDataHandlerImpl.this.handleTrimOption(trimOption);
                    this.memberDefn.setTrimOption(value);
                }
                catch (MetaDataParserException e) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(e);
                }
            }
            this.memberDefn.setAllowExpression(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.ALLOW_EXPRESSION_ATTRIB, false));
            if (this.memberDefn.getTypeCode() == 7) {
                this.memberDefn.setReturnType(attrs.getValue(MetaDataHandlerImpl.RETURN_TYPE_ATTRIB));
                this.memberDefn.setContext(attrs.getValue(MetaDataHandlerImpl.CONTEXT_ATTRIB));
            }
            if (!StringUtil.isBlank(validator)) {
                this.memberDefn.setValueValidator(validator);
            }
            if (typeDefn.getTypeCode() == 16) {
                this.memberDefn.setIsList(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.IS_LIST_ATTRIB, false));
            }
            if (choiceSet != null) {
                this.memberDefn.setDetails(choiceSet);
            } else if (structDefn != null) {
                this.memberDefn.setDetails(structDefn);
            } else if (detailName != null) {
                this.memberDefn.setDetails(detailName);
            }
            this.memberDefn.setIntrinsic(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.IS_INTRINSIC_ATTRIB, false));
            try {
                MetaDataHandlerImpl.this.struct.addProperty(this.memberDefn);
            }
            catch (MetaDataException e) {
                MetaDataHandlerImpl.this.errorHandler.semanticError((Exception)((Object)e));
            }
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.DEFAULT_TAG)) {
                return new DefaultValueState(this.memberDefn);
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.ALLOWED_TAG)) {
                return new AllowedState(this.memberDefn);
            }
            return super.startElement(tagName);
        }

        @Override
        public void end() throws SAXException {
            if (this.memberDefn == null) {
                return;
            }
            if (this.memberDefn.getDefault() != null) {
                try {
                    Object value = this.memberDefn.validateXml(null, null, this.memberDefn.getDefault());
                    this.memberDefn.setDefault(value);
                }
                catch (PropertyValueException e) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_DEFAULT"));
                }
            }
            this.memberDefn = null;
        }
    }

    class PropertyGroupState
    extends XMLParserHandler.InnerParseState {
        PropertyGroupState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) {
            MetaDataHandlerImpl.this.groupNameID = attrs.getValue(MetaDataHandlerImpl.DISPLAY_NAME_ID_ATTRIB);
            if (StringUtil.isBlank(MetaDataHandlerImpl.this.groupNameID)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("GROUP_NAME_ID_REQUIRED"));
            }
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.PROPERTY_TAG)) {
                return new PropertyState();
            }
            return super.startElement(tagName);
        }

        @Override
        public void end() throws SAXException {
            MetaDataHandlerImpl.this.groupNameID = null;
        }
    }

    protected class PropertyState
    extends XMLParserHandler.InnerParseState {
        List<String> propertyTypes = new ArrayList<String>();

        protected PropertyState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) {
            boolean ok;
            MetaDataHandlerImpl.this.choices.clear();
            MetaDataHandlerImpl.this.propDefn = null;
            String name = this.getAttrib(attrs, MetaDataHandlerImpl.NAME_ATTRIB);
            String displayNameID = this.getAttrib(attrs, MetaDataHandlerImpl.DISPLAY_NAME_ID_ATTRIB);
            String type = this.getAttrib(attrs, MetaDataHandlerImpl.TYPE_ATTRIB);
            String validator = this.getAttrib(attrs, MetaDataHandlerImpl.VALIDATOR_ATTRIB);
            String subType = this.getAttrib(attrs, MetaDataHandlerImpl.SUB_TYPE_ATTRIB);
            boolean isList = this.getBooleanAttrib(attrs, MetaDataHandlerImpl.IS_LIST_ATTRIB, false);
            String detailName = this.getAttrib(attrs, MetaDataHandlerImpl.DETAIL_TYPE_ATTRIB);
            String namespace = this.getAttrib(attrs, MetaDataHandlerImpl.NAME_SPACE_ATTRIB);
            boolean bl = ok = MetaDataHandlerImpl.this.elementDefn != null;
            if (name == null) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (MetaDataHandlerImpl.this.checkDisplayNameID && StringUtil.isBlank(displayNameID)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                ok = false;
            }
            if (type == null) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("TYPE_REQUIRED"));
                ok = false;
            }
            if (!ok) {
                return;
            }
            PropertyType typeDefn = MetaDataHandlerImpl.this.dictionary.getPropertyType(type);
            if (typeDefn == null) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_TYPE"));
                return;
            }
            int typeCode = typeDefn.getTypeCode();
            if (isList && typeCode != 20 && PropertyDefn.isSupportedSubType(typeDefn)) {
                subType = type;
            }
            ChoiceSet choiceSet = null;
            StructureDefn struct = null;
            PropertyType subTypeDefn = null;
            switch (typeDefn.getTypeCode()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 11: 
                case 14: 
                case 21: {
                    if (detailName == null || (choiceSet = MetaDataHandlerImpl.this.validateChoiceSet(detailName)) != null) break;
                    return;
                }
                case 5: {
                    if (detailName == null || (choiceSet = MetaDataHandlerImpl.this.validateChoiceSet(detailName)) != null) break;
                    return;
                }
                case 4: {
                    choiceSet = MetaDataHandlerImpl.this.validateChoiceSet("colors");
                    if (choiceSet != null) break;
                    return;
                }
                case 16: 
                case 19: {
                    if (detailName == null) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("STRUCT_TYPE_REQUIRED"));
                        return;
                    }
                    struct = (StructureDefn)MetaDataHandlerImpl.this.dictionary.getStructure(detailName);
                    if (struct != null) break;
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_STRUCT_TYPE"));
                    return;
                }
                case 15: 
                case 23: 
                case 24: {
                    if (!MetaDataHandlerImpl.THIS_KEYWORD.equals(detailName)) break;
                    detailName = MetaDataHandlerImpl.this.elementDefn.getName();
                    break;
                }
                case 20: {
                    if (subType == null) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("MISSING_SUB_TYPE"));
                        break;
                    }
                    subTypeDefn = MetaDataHandlerImpl.this.dictionary.getPropertyType(subType);
                    if (subTypeDefn == null) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_TYPE"));
                        return;
                    }
                    if (subTypeDefn.getTypeCode() != 15) break;
                    if (detailName == null) {
                        MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("ELEMENT_REF_TYPE_REQUIRED"));
                        return;
                    }
                    if (!detailName.equals(MetaDataHandlerImpl.THIS_KEYWORD)) break;
                    detailName = MetaDataHandlerImpl.this.elementDefn.getName();
                    break;
                }
                default: {
                    detailName = null;
                }
            }
            MetaDataHandlerImpl.this.propDefn = MetaDataHandlerImpl.this.builder.createPropertyDefn();
            MetaDataHandlerImpl.this.propDefn.setName(name);
            MetaDataHandlerImpl.this.propDefn.setDisplayNameID(displayNameID);
            MetaDataHandlerImpl.this.propDefn.setType(typeDefn);
            if (typeDefn.getTypeCode() == 20) {
                MetaDataHandlerImpl.this.propDefn.setSubType(subTypeDefn);
            }
            MetaDataHandlerImpl.this.propDefn.setGroupNameKey(MetaDataHandlerImpl.this.groupNameID);
            MetaDataHandlerImpl.this.propDefn.setCanInherit(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.CAN_INHERIT_ATTRIBUTE, true));
            MetaDataHandlerImpl.this.propDefn.setIntrinsic(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.IS_INTRINSIC_ATTRIB, false));
            MetaDataHandlerImpl.this.propDefn.setStyleProperty(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.IS_STYLE_PROPERTY_ATTRIB, false));
            MetaDataHandlerImpl.this.propDefn.setBidiProperty(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.IS_BIDI_PROPERTY_ATTRIB, false));
            MetaDataHandlerImpl.this.propDefn.setValueRequired(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.VALUE_REQUIRED_ATTRIB, false));
            MetaDataHandlerImpl.this.propDefn.setSince(attrs.getValue(MetaDataHandlerImpl.SINCE_ATTRIB));
            MetaDataHandlerImpl.this.propDefn.setRuntimeSettable(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.RUNTIME_SETTABLE_ATTRIB, true));
            String trimOption = attrs.getValue(MetaDataHandlerImpl.TRIM_OPTION_ATTRIB);
            if (trimOption != null) {
                try {
                    int value = MetaDataHandlerImpl.this.handleTrimOption(trimOption);
                    MetaDataHandlerImpl.this.propDefn.setTrimOption(value);
                }
                catch (MetaDataParserException e) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(e);
                }
            }
            MetaDataHandlerImpl.this.propDefn.setAllowExpression(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.ALLOW_EXPRESSION_ATTRIB, false));
            if (MetaDataHandlerImpl.this.propDefn.getTypeCode() == 7) {
                MetaDataHandlerImpl.this.propDefn.setReturnType(attrs.getValue(MetaDataHandlerImpl.RETURN_TYPE_ATTRIB));
                MetaDataHandlerImpl.this.propDefn.setContext(attrs.getValue(MetaDataHandlerImpl.CONTEXT_ATTRIB));
            }
            if (!StringUtil.isBlank(validator)) {
                MetaDataHandlerImpl.this.propDefn.setValueValidator(validator);
            }
            if (typeCode == 16 || MetaDataHandlerImpl.this.propDefn.isElementType()) {
                MetaDataHandlerImpl.this.propDefn.setIsList(isList);
            }
            if (choiceSet != null) {
                MetaDataHandlerImpl.this.propDefn.setDetails(choiceSet);
            } else if (struct != null) {
                MetaDataHandlerImpl.this.propDefn.setDetails(struct);
            } else if (detailName != null) {
                MetaDataHandlerImpl.this.propDefn.setDetails(detailName);
            }
            if ("true".equalsIgnoreCase(namespace)) {
                NameConfig config = new NameConfig();
                config.holder = MetaDataHandlerImpl.this.elementDefn;
                config.nameSpaceID = NameSpaceFactory.getInstance().getNameSpaceID(MetaDataHandlerImpl.this.elementDefn.getName(), MetaDataHandlerImpl.this.propDefn.getName());
                MetaDataHandlerImpl.this.propDefn.setNameConfig(config);
            }
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.DEFAULT_TAG)) {
                return new DefaultValueState(MetaDataHandlerImpl.this.propDefn);
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.ALLOWED_TAG)) {
                return new AllowedState(MetaDataHandlerImpl.this.propDefn);
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.ALLOWED_UNITS_TAG)) {
                return new AllowedUnitsState(MetaDataHandlerImpl.this.propDefn);
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.TRIGGER_TAG)) {
                return new TriggerState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.DEFAULT_UNIT_TAG)) {
                return new DefaultUnitState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.TYPE_TAG)) {
                return new PropertyTypeState(this.propertyTypes);
            }
            return super.startElement(tagName);
        }

        @Override
        public void end() throws SAXException {
            if (MetaDataHandlerImpl.this.propDefn == null) {
                return;
            }
            int typeCode = MetaDataHandlerImpl.this.propDefn.getTypeCode();
            if (!this.propertyTypes.isEmpty()) {
                ChoiceSet choiceSet;
                if (typeCode == 23 || typeCode == 16 || typeCode == 24) {
                    MetaDataHandlerImpl.this.propDefn.setDetails(this.propertyTypes);
                }
                if (typeCode == 5 && MetaDataHandlerImpl.this.propDefn.getDetails() == null && (choiceSet = MetaDataHandlerImpl.this.validateChoiceSet(this.propertyTypes.get(0))) != null) {
                    MetaDataHandlerImpl.this.propDefn.setDetails(choiceSet);
                }
            }
            if (this.isValidPropertyDefn()) {
                try {
                    MetaDataHandlerImpl.this.builder.addPropertyDefn(MetaDataHandlerImpl.this.elementDefn, MetaDataHandlerImpl.this.propDefn);
                }
                catch (MetaDataException e) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
            MetaDataHandlerImpl.this.propDefn = null;
        }

        protected boolean isValidPropertyDefn() {
            int typeCode = MetaDataHandlerImpl.this.propDefn.getTypeCode();
            if (MetaDataHandlerImpl.this.propDefn.getDetails() == null) {
                if (typeCode == 5) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("CHOICE_TYPE_REQUIRED"));
                    return false;
                }
                if (typeCode == 15) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("ELEMENT_REF_TYPE_REQUIRED"));
                    return false;
                }
            }
            if (MetaDataHandlerImpl.this.propDefn.getDefault() != null) {
                try {
                    Object value = MetaDataHandlerImpl.this.propDefn.validateXml(null, null, MetaDataHandlerImpl.this.propDefn.getDefault());
                    MetaDataHandlerImpl.this.propDefn.setDefault(value);
                }
                catch (PropertyValueException e) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_DEFAULT"));
                    return false;
                }
            }
            return true;
        }
    }

    class PropertyTypeState
    extends XMLParserHandler.InnerParseState {
        protected List<String> types = null;

        public PropertyTypeState(List<String> propertyTypes) {
            this.types = propertyTypes;
        }

        @Override
        public void parseAttrs(Attributes attrs) throws XMLParserException {
            boolean ok = MetaDataHandlerImpl.this.propDefn != null;
            String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (ok) {
                this.types.add(name);
            }
        }
    }

    class RootState
    extends XMLParserHandler.InnerParseState {
        RootState() {
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (MetaDataHandlerImpl.CHOICE_TYPE_TAG.equalsIgnoreCase(tagName)) {
                return new ChoiceTypeState();
            }
            if (MetaDataHandlerImpl.STRUCTURE_TAG.equalsIgnoreCase(tagName)) {
                return new StructDefnState();
            }
            if (MetaDataHandlerImpl.ELEMENT_TAG.equalsIgnoreCase(tagName)) {
                return new ElementDefnState();
            }
            if (MetaDataHandlerImpl.STYLE_TAG.equalsIgnoreCase(tagName)) {
                return new StyleState();
            }
            if (MetaDataHandlerImpl.CLASS_TAG.equalsIgnoreCase(tagName)) {
                return new ClassState();
            }
            if (MetaDataHandlerImpl.VALIDATORS_TAG.equalsIgnoreCase(tagName)) {
                return new ValidatorsState();
            }
            return super.startElement(tagName);
        }
    }

    class SemanticValidatorState
    extends XMLParserHandler.InnerParseState {
        SemanticValidatorState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String name = this.getAttrib(attrs, MetaDataHandlerImpl.NAME_ATTRIB);
            String modules = this.getAttrib(attrs, MetaDataHandlerImpl.MODULES_ATTRIB);
            String className = this.getAttrib(attrs, MetaDataHandlerImpl.CLASS_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("VALIDATOR_NAME_REQUIRED"));
                return;
            }
            if (StringUtil.isBlank(className)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("CLASS_NAME_REQUIRED"));
                return;
            }
            try {
                Class<?> c = Class.forName(className);
                Method m = c.getMethod("getInstance", null);
                AbstractSemanticValidator validator = (AbstractSemanticValidator)m.invoke(null, null);
                validator.setName(name);
                validator.setModules(modules);
                try {
                    MetaDataHandlerImpl.this.dictionary.addSemanticValidator(validator);
                }
                catch (MetaDataException e) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
            catch (Exception e) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_META_VALIDATOR"));
            }
        }
    }

    class SlotState
    extends XMLParserHandler.InnerParseState {
        SlotState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) throws XMLParserException {
            boolean ok;
            String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
            String displayNameID = attrs.getValue(MetaDataHandlerImpl.DISPLAY_NAME_ID_ATTRIB);
            String multipleCardinality = attrs.getValue(MetaDataHandlerImpl.MULTIPLE_CARDINALITY_ATTRIB);
            String tmpID = attrs.getValue(MetaDataHandlerImpl.ID_ATTRIB);
            String namespace = this.getAttrib(attrs, MetaDataHandlerImpl.NAME_SPACE_ATTRIB);
            boolean bl = ok = MetaDataHandlerImpl.this.elementDefn != null;
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            } else if (StringUtil.isBlank(displayNameID)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
                ok = false;
            } else if (StringUtil.isBlank(multipleCardinality)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("MULTIPLE_CARDINALITY_REQUIRED"));
                ok = false;
            }
            if (!ok) {
                return;
            }
            MetaDataHandlerImpl.this.slotDefn = new SlotDefn();
            MetaDataHandlerImpl.this.slotDefn.setName(name);
            MetaDataHandlerImpl.this.slotDefn.setDisplayNameID(displayNameID);
            MetaDataHandlerImpl.this.slotDefn.setManagedByNameSpace(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.IS_MANAGED_BY_NAME_SPACE_ATTRIB, true));
            MetaDataHandlerImpl.this.slotDefn.setMultipleCardinality(this.parseBoolean(multipleCardinality, true));
            MetaDataHandlerImpl.this.slotDefn.setSelector(attrs.getValue(MetaDataHandlerImpl.SELECTOR_ATTRIB));
            MetaDataHandlerImpl.this.slotDefn.setSince(attrs.getValue(MetaDataHandlerImpl.SINCE_ATTRIB));
            MetaDataHandlerImpl.this.slotDefn.setXmlName(attrs.getValue(MetaDataHandlerImpl.XML_NAME_ATTRIB));
            if (!StringUtil.isBlank(tmpID)) {
                try {
                    MetaDataHandlerImpl.this.slotDefn.setSlotID(Integer.parseInt(tmpID));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ("true".equalsIgnoreCase(namespace)) {
                NameConfig nameConfig = new NameConfig();
                nameConfig.holder = MetaDataHandlerImpl.this.elementDefn;
                nameConfig.nameSpaceID = NameSpaceFactory.getInstance().getNameSpaceID(MetaDataHandlerImpl.this.elementDefn.getName(), MetaDataHandlerImpl.this.slotDefn.getName());
                MetaDataHandlerImpl.this.slotDefn.setNameConfig(nameConfig);
            }
            MetaDataHandlerImpl.this.elementDefn.addSlot(MetaDataHandlerImpl.this.slotDefn);
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.TYPE_TAG)) {
                return new SlotTypeState();
            }
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.TRIGGER_TAG)) {
                return new TriggerState();
            }
            return super.startElement(tagName);
        }

        @Override
        public void end() throws SAXException {
            super.end();
            MetaDataHandlerImpl.this.slotDefn = null;
        }
    }

    class SlotTypeState
    extends XMLParserHandler.InnerParseState {
        SlotTypeState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) throws XMLParserException {
            boolean ok = MetaDataHandlerImpl.this.slotDefn != null;
            String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (ok) {
                MetaDataHandlerImpl.this.slotDefn.addType(name);
            }
        }
    }

    class StartState
    extends XMLParserHandler.InnerParseState {
        StartState() {
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.ROOT_TAG)) {
                return new RootState();
            }
            return super.startElement(tagName);
        }
    }

    protected class StructDefnState
    extends XMLParserHandler.InnerParseState {
        protected StructDefnState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
            String displayNameID = attrs.getValue(MetaDataHandlerImpl.DISPLAY_NAME_ID_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
            }
            if (StringUtil.isBlank(displayNameID)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
            } else {
                MetaDataHandlerImpl.this.struct = new StructureDefn(name);
                MetaDataHandlerImpl.this.struct.setDisplayNameKey(attrs.getValue(MetaDataHandlerImpl.DISPLAY_NAME_ID_ATTRIB));
                MetaDataHandlerImpl.this.struct.setSince(attrs.getValue(MetaDataHandlerImpl.SINCE_ATTRIB));
                try {
                    MetaDataHandlerImpl.this.dictionary.addStructure(MetaDataHandlerImpl.this.struct);
                }
                catch (MetaDataException e) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
        }

        @Override
        public void end() throws SAXException {
            super.end();
            MetaDataHandlerImpl.this.struct = null;
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase(MetaDataHandlerImpl.MEMBER_TAG)) {
                return new MemberState();
            }
            return super.startElement(tagName);
        }
    }

    class StylePropertyState
    extends XMLParserHandler.InnerParseState {
        StylePropertyState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) throws XMLParserException {
            boolean ok;
            String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
            boolean bl = ok = MetaDataHandlerImpl.this.elementDefn != null;
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
                ok = false;
            }
            if (ok) {
                MetaDataHandlerImpl.this.elementDefn.addStyleProperty(name);
            }
        }
    }

    protected class StyleState
    extends XMLParserHandler.InnerParseState {
        protected StyleState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String name = attrs.getValue(MetaDataHandlerImpl.NAME_ATTRIB);
            String displayNameID = attrs.getValue(MetaDataHandlerImpl.DISPLAY_NAME_ID_ATTRIB);
            String type = attrs.getValue(MetaDataHandlerImpl.TYPE_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("NAME_REQUIRED"));
            } else if (StringUtil.isBlank(displayNameID)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("DISPLAY_NAME_ID_REQUIRED"));
            } else {
                PredefinedStyle style = new PredefinedStyle();
                style.setName(name);
                style.setDisplayNameKey(displayNameID);
                style.setType(type);
                try {
                    MetaDataHandlerImpl.this.dictionary.addPredefinedStyle(style);
                }
                catch (MetaDataException e) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
        }
    }

    class TriggerState
    extends XMLParserHandler.InnerParseState {
        TriggerState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) throws XMLParserException {
            assert (MetaDataHandlerImpl.this.propDefn != null || MetaDataHandlerImpl.this.slotDefn != null);
            String validatorName = attrs.getValue(MetaDataHandlerImpl.VALIDATOR_ATTRIB);
            String targetElement = attrs.getValue(MetaDataHandlerImpl.TARGET_ELEMENT_ATTRIB);
            if (!StringUtil.isBlank(validatorName)) {
                SemanticTriggerDefn triggerDefn = new SemanticTriggerDefn(validatorName);
                triggerDefn.setPreRequisite(this.getBooleanAttrib(attrs, MetaDataHandlerImpl.PRE_REQUISITE_ATTRIB, false));
                if (!StringUtil.isBlank(targetElement)) {
                    triggerDefn.setTargetElement(targetElement);
                }
                if (MetaDataHandlerImpl.this.propDefn != null) {
                    MetaDataHandlerImpl.this.propDefn.getTriggerDefnSet().add(triggerDefn);
                }
                if (MetaDataHandlerImpl.this.slotDefn != null) {
                    MetaDataHandlerImpl.this.slotDefn.getTriggerDefnSet().add(triggerDefn);
                }
            } else {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("VALIDATOR_NAME_REQUIRED"));
            }
        }
    }

    class ValidatorsState
    extends XMLParserHandler.InnerParseState {
        ValidatorsState() {
        }

        @Override
        public AbstractParseState startElement(String tagName) {
            if (MetaDataHandlerImpl.VALUE_VALIDATOR_TAG.equalsIgnoreCase(tagName)) {
                return new ValueValidatorState();
            }
            if (MetaDataHandlerImpl.SEMANTIC_VALIDATOR_TAG.equalsIgnoreCase(tagName)) {
                return new SemanticValidatorState();
            }
            return super.startElement(tagName);
        }
    }

    class ValueValidatorState
    extends XMLParserHandler.InnerParseState {
        ValueValidatorState() {
        }

        @Override
        public void parseAttrs(Attributes attrs) throws XMLParserException {
            String name = this.getAttrib(attrs, MetaDataHandlerImpl.NAME_ATTRIB);
            String className = this.getAttrib(attrs, MetaDataHandlerImpl.CLASS_ATTRIB);
            if (StringUtil.isBlank(name)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("VALIDATOR_NAME_REQUIRED"));
                return;
            }
            if (StringUtil.isBlank(className)) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("CLASS_NAME_REQUIRED"));
                return;
            }
            try {
                Class<?> c = MetaDataHandlerImpl.this.builder.loadClass(className);
                SimpleValueValidator validator = (SimpleValueValidator)c.newInstance();
                validator.setName(name);
                try {
                    MetaDataHandlerImpl.this.builder.addValueValidator(validator);
                }
                catch (MetaDataException e) {
                    MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException((Exception)((Object)e), "BUILD_FAILED"));
                }
            }
            catch (Exception e) {
                MetaDataHandlerImpl.this.errorHandler.semanticError(new MetaDataParserException("INVALID_META_VALIDATOR"));
            }
        }
    }
}

