/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.ArrayList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.ReportExecutorUtil;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.extension.ReportItemExecutorBase;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.html.HTMLBlockStackingLM;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.html.buffer.DummyPageBuffer;
import org.eclipse.birt.report.engine.layout.html.buffer.INode;
import org.eclipse.birt.report.engine.layout.html.buffer.IPageBuffer;
import org.eclipse.birt.report.engine.layout.html.buffer.TableBreakBuffer;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;

public class HTMLPageLM
extends HTMLBlockStackingLM {
    protected IReportContent report;
    protected IPageContent pageContent;
    protected IReportExecutor reportExecutor = null;
    boolean isLastPage = false;
    boolean isFirstPage = true;

    public HTMLPageLM(HTMLReportLayoutEngine engine, IReportContent report, IReportExecutor executor, IContentEmitter emitter) {
        super(engine.getFactory());
        this.report = report;
        this.reportExecutor = executor;
        this.emitter = emitter;
        this.executor = new ReportItemExecutorBase(){

            public void close() {
            }

            public IContent execute() {
                return HTMLPageLM.this.pageContent;
            }

            public IReportItemExecutor getNextChild() throws BirtException {
                return HTMLPageLM.this.reportExecutor.getNextChild();
            }

            public boolean hasNextChild() throws BirtException {
                return HTMLPageLM.this.reportExecutor.hasNextChild();
            }
        };
        this.context.setPageLM(this);
    }

    public int getType() {
        return 2;
    }

    public boolean layout() throws BirtException {
        if (this.context.getCancelFlag()) {
            this.close();
            this.isLastPage = true;
            return false;
        }
        this.start(this.isFirstPage);
        boolean hasNextPage = this.layoutNodes();
        if (this.isChildrenFinished()) {
            this.isLastPage = true;
        }
        this.isFirstPage = false;
        this.end(this.isLastPage);
        this.context.initilizePage();
        return hasNextPage;
    }

    public boolean isFinished() {
        return this.isLastPage;
    }

    public void layoutPageContent(IPageContent pageContent) throws BirtException {
        IContent footer;
        IContent header = pageContent.getPageHeader();
        if (header != null) {
            pageContent.setPageHeader(this.layoutContent(header));
        }
        if ((footer = pageContent.getPageFooter()) != null) {
            pageContent.setPageFooter(this.layoutContent(footer));
        }
    }

    protected IContent layoutContent(IContent content) throws BirtException {
        if (content == null) {
            return null;
        }
        ContentDOMEmitter domEmitter = new ContentDOMEmitter(content, this.emitter);
        boolean pageBreak = this.context.allowPageBreak();
        IPageBuffer pageBuffer = this.context.getPageBufferManager();
        this.context.setPageBufferManager(new PageContentBuffer());
        this.context.setAllowPageBreak(false);
        this.engine.layout((ILayoutManager)this, content, (IContentEmitter)domEmitter);
        this.context.setAllowPageBreak(pageBreak);
        this.context.setPageBufferManager(pageBuffer);
        domEmitter.refreshChildren();
        return content;
    }

    protected void start(boolean isFirst) throws BirtException {
        this.context.getBufferFactory().refresh();
        this.context.setPageBufferManager(this.createPageBuffer());
        MasterPageDesign pageDesign = this.getMasterPage(this.report);
        this.pageContent = ReportExecutorUtil.executeMasterPage(this.reportExecutor, this.context.getPageNumber(), pageDesign);
        if (this.pageContent != null && this.context.needLayoutPageContent()) {
            this.layoutPageContent(this.pageContent);
        }
        if (this.emitter != null) {
            this.context.getPageBufferManager().startContainer(this.pageContent, isFirst, this.emitter, true);
        }
    }

    protected IContent getContent() {
        return this.pageContent;
    }

    protected IPageBuffer createPageBuffer() {
        IPageBuffer bufferMgr = null;
        bufferMgr = this.context.allowPageBreak ? new TableBreakBuffer(null, this.context) : new DummyPageBuffer(this.context, this.reportExecutor);
        return bufferMgr;
    }

    protected void end(boolean finished) throws BirtException {
        if (this.emitter != null) {
            this.context.getPageBufferManager().endContainer(this.pageContent, finished, this.emitter, true);
            this.context.getBufferFactory().close();
        }
        if (!finished) {
            this.context.getPageHintManager().resetRowHint();
        }
        this.context.setEmptyPage(false);
    }

    static class BufferNode {
        IContent content;
        ArrayList children = new ArrayList();
        BufferNode parent;

        public BufferNode(IContent content, BufferNode parent) {
            this.content = content;
            this.parent = parent;
        }

        public void addChild(IContent child) {
            this.children.add(child);
        }
    }

    public class ContentDOMEmitter
    extends ContentEmitterAdapter {
        protected ArrayList nodes = new ArrayList();
        protected BufferNode current;
        protected IContentEmitter emitter;

        public ContentDOMEmitter(IContent root, IContentEmitter emitter) {
            this.emitter = emitter;
            this.current = new BufferNode(root, null);
            this.nodes.add(this.current);
        }

        public String getOutputFormat() {
            return this.emitter.getOutputFormat();
        }

        public void refreshChildren() {
            int i = 0;
            while (i < this.nodes.size()) {
                BufferNode node = (BufferNode)this.nodes.get(i);
                node.content.getChildren().clear();
                node.content.getChildren().addAll(node.children);
                ++i;
            }
        }

        public void startContent(IContent content) {
            if (this.current != null) {
                if (content != null) {
                    this.current.children.add(content);
                    this.current = new BufferNode(content, this.current);
                    this.nodes.add(this.current);
                } else {
                    this.current = null;
                }
            }
        }

        public void endContent(IContent content) {
            if (this.current != null && content != null) {
                this.current = this.current.parent;
            }
        }
    }

    public static class PageContentBuffer
    implements IPageBuffer {
        public boolean isRepeated() {
            return false;
        }

        public void setRepeated(boolean isRepeated) {
        }

        public void endContainer(IContent content, boolean finished, IContentEmitter emitter, boolean visible) throws BirtException {
            if (content != null && visible) {
                ContentEmitterUtil.endContent(content, emitter);
            }
        }

        public void startContainer(IContent content, boolean isFirst, IContentEmitter emitter, boolean visible) throws BirtException {
            if (content != null && visible) {
                ContentEmitterUtil.startContent(content, emitter);
            }
        }

        public void startContent(IContent content, IContentEmitter emitter, boolean visible) throws BirtException {
            if (content != null && visible) {
                ContentEmitterUtil.startContent(content, emitter);
                ContentEmitterUtil.endContent(content, emitter);
            }
        }

        public void closePage(INode[] nodeList) {
        }

        public boolean finished() {
            return false;
        }

        public void flush() {
        }

        public INode[] getNodeStack() {
            return null;
        }

        public void openPage(INode[] nodeList) {
        }

        public void addTableColumnHint(TableColumnHint hint) {
        }
    }
}

