/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.HashMap;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.script.IDataRow;
import org.eclipse.birt.data.engine.api.script.IDataSetInstanceHandle;
import org.eclipse.birt.data.engine.api.script.IScriptDataSetEventHandler;
import org.eclipse.birt.data.engine.api.script.IScriptDataSetMetaDataDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.engine.api.script.eventhandler.IScriptedDataSetEventHandler;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.DataSetScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptTextUtil;
import org.eclipse.birt.report.engine.script.internal.ScriptedDataSetMetaData;
import org.eclipse.birt.report.engine.script.internal.UpdatableDataSetRow;
import org.eclipse.birt.report.engine.script.internal.instance.DataSetInstance;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ScriptDataSetScriptExecutor
extends DataSetScriptExecutor
implements IScriptDataSetEventHandler {
    private static final String OPEN = "OPEN";
    private static final String CLOSE = "CLOSE";
    private static final String FETCH = "FETCH";
    private static final String DESCRIBE = "DESCRIBE";
    private IScriptedDataSetEventHandler scriptedEventHandler;
    private boolean useOpenEventHandler = false;
    private boolean useFetchEventHandler = false;
    private boolean useCloseEventHandler = false;
    private boolean useDescribeEventHandler = false;
    private String fetchScript = null;
    private HashMap<IDataSetInstanceHandle, Scriptable> sharedScopes = new HashMap();
    private final String openMethodID;
    private final String closeMethodID;
    private final String fetchMethodID;
    private final String describeMethodID;

    public ScriptDataSetScriptExecutor(ScriptDataSetHandle dataSetHandle, ExecutionContext context) throws BirtException {
        super((DataSetHandle)dataSetHandle, context);
        this.fetchScript = dataSetHandle.getFetch();
        this.useOpenEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getOpen());
        this.useFetchEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getFetch());
        this.useCloseEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getClose());
        this.useDescribeEventHandler = ScriptTextUtil.isNullOrComments(dataSetHandle.getDescribe());
        this.openMethodID = ModuleUtil.getScriptUID((Object)dataSetHandle.getPropertyHandle("open"));
        this.closeMethodID = ModuleUtil.getScriptUID((Object)dataSetHandle.getPropertyHandle("close"));
        this.fetchMethodID = ModuleUtil.getScriptUID((Object)dataSetHandle.getPropertyHandle("fetch"));
        this.describeMethodID = ModuleUtil.getScriptUID((Object)dataSetHandle.getPropertyHandle("describe"));
    }

    protected void initEventHandler(String className) {
        super.initEventHandler(className);
        if (this.eventHandler != null) {
            try {
                this.scriptedEventHandler = (IScriptedDataSetEventHandler)this.eventHandler;
            }
            catch (ClassCastException e) {
                ScriptDataSetScriptExecutor.addClassCastException(this.context, e, (DesignElementHandle)this.dataSetHandle, IScriptedDataSetEventHandler.class);
            }
        }
    }

    public void handleOpen(IDataSetInstanceHandle dataSet) throws BirtException {
        try {
            ScriptExecutor.ScriptStatus status;
            if (!this.useOpenEventHandler && (status = this.handleJS(this.getScriptScope(dataSet), dataSet.getName(), OPEN, ((ScriptDataSetHandle)this.dataSetHandle).getOpen(), this.openMethodID)).didRun()) {
                return;
            }
            if (this.scriptedEventHandler != null) {
                this.scriptedEventHandler.open(new DataSetInstance(dataSet));
            }
        }
        catch (Exception e) {
            ScriptDataSetScriptExecutor.addException(this.context, e);
        }
    }

    public void handleClose(IDataSetInstanceHandle dataSet) {
        try {
            ScriptExecutor.ScriptStatus status;
            if (!this.useCloseEventHandler && (status = this.handleJS(this.getScriptScope(dataSet), dataSet.getName(), CLOSE, ((ScriptDataSetHandle)this.dataSetHandle).getClose(), this.closeMethodID)).didRun()) {
                return;
            }
            if (this.scriptedEventHandler != null) {
                this.scriptedEventHandler.close(new DataSetInstance(dataSet));
            }
        }
        catch (Exception e) {
            ScriptDataSetScriptExecutor.addException(this.context, e);
        }
    }

    public boolean handleFetch(IDataSetInstanceHandle dataSet, IDataRow row) {
        try {
            ScriptExecutor.ScriptStatus status;
            if (!this.useFetchEventHandler && (status = this.handleJS(this.getScriptScope(dataSet), dataSet.getName(), FETCH, this.fetchScript, this.fetchMethodID)).didRun()) {
                Object result = status.result();
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                throw new DataException("data.engine.BadFetchScriptReturnType", new Object[]{"Fetch", result});
            }
            if (this.scriptedEventHandler != null) {
                return this.scriptedEventHandler.fetch(new DataSetInstance(dataSet), new UpdatableDataSetRow(row));
            }
        }
        catch (Exception e) {
            ScriptDataSetScriptExecutor.addException(this.context, e);
        }
        return false;
    }

    public boolean handleDescribe(IDataSetInstanceHandle dataSet, IScriptDataSetMetaDataDefinition metaData) throws BirtException {
        try {
            ScriptExecutor.ScriptStatus status;
            if (!this.useDescribeEventHandler && (status = this.handleJS(this.getScriptScope(dataSet), dataSet.getName(), DESCRIBE, ((ScriptDataSetHandle)this.dataSetHandle).getDescribe(), this.describeMethodID)).didRun()) {
                Object result = status.result();
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                throw new DataException("data.engine.BadFetchScriptReturnType", new Object[]{"Describe", result});
            }
            if (this.scriptedEventHandler != null) {
                return this.scriptedEventHandler.describe(new DataSetInstance(dataSet), new ScriptedDataSetMetaData(metaData));
            }
        }
        catch (Exception e) {
            ScriptDataSetScriptExecutor.addException(this.context, e);
        }
        return false;
    }

    private Scriptable getScriptScope(IDataSetInstanceHandle dataSet) throws DataException {
        Scriptable result = this.sharedScopes.get(dataSet);
        if (result != null) {
            return result;
        }
        result = (Scriptable)Context.javaToJS((Object)new DataSetInstance(dataSet), (Scriptable)this.scope);
        result.setParentScope(this.scope);
        result.setPrototype(dataSet.getScriptScope());
        this.sharedScopes.put(dataSet, result);
        return result;
    }
}

