/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.parser.destinations;

import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.rtf.parser.RtfImportMgr;
import com.lowagie.text.rtf.parser.RtfParser;
import com.lowagie.text.rtf.parser.ctrlwords.RtfCtrlWordData;
import com.lowagie.text.rtf.parser.destinations.RtfDestination;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Properties;

public final class RtfDestinationFontTable
extends RtfDestination {
    private RtfImportMgr importHeader = null;
    private String themeFont = "";
    private String fontNr = "";
    private String fontFamily = "";
    private String charset = "";
    private static final String CHARSET_DEFAULT = "0";
    private int fprq = 0;
    private String panose = "";
    private String nontaggedname = "";
    private String fontName = "";
    private String falt = "";
    private String fontemb = "";
    private String fontType = "";
    private String fontFile = "";
    private String fontFileCpg = "";
    private int fbias = 0;
    private String cpg = "";
    private String trueType = "";
    private int state = 0;
    private static final int SETTING_NORMAL = 0;
    private static final int SETTING_ALTERNATE = 1;
    private static final int SETTING_FONTNAME = 2;
    private static final int SETTING_PANOSE = 3;
    private static final int SETTING_FONT_EMBED = 4;
    private static final int SETTING_FONT_FILE = 5;
    private HashMap fontMap = null;

    public RtfDestinationFontTable() {
        super(null);
    }

    public RtfDestinationFontTable(RtfParser rtfParser) {
        super(rtfParser);
        this.init(true);
    }

    public void setParser(RtfParser rtfParser) {
        if (this.rtfParser != null && this.rtfParser.equals(rtfParser)) {
            return;
        }
        this.rtfParser = rtfParser;
        this.init(true);
    }

    private void init(boolean bl) {
        this.fontMap = new HashMap();
        if (this.rtfParser != null) {
            this.importHeader = this.rtfParser.getImportManager();
        }
        this.setToDefaults();
        if (bl) {
            this.importSystemFonts();
        }
    }

    public boolean handleOpeningSubGroup() {
        return true;
    }

    public boolean closeDestination() {
        return true;
    }

    public boolean handleCloseGroup() {
        if (this.state == 0) {
            this.processFont();
        }
        this.state = 0;
        return true;
    }

    public boolean handleOpenGroup() {
        return true;
    }

    public boolean handleCharacter(int n) {
        switch (this.state) {
            case 0: {
                this.fontName = this.fontName + (char)n;
                break;
            }
            case 1: {
                this.falt = this.falt + (char)n;
                break;
            }
            case 3: {
                this.panose = this.panose + (char)n;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
        }
        return true;
    }

    public boolean handleControlWord(RtfCtrlWordData rtfCtrlWordData) {
        boolean bl = true;
        if (rtfCtrlWordData.ctrlWord.equals("f")) {
            this.setFontNumber(rtfCtrlWordData.param);
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fcharset")) {
            this.setCharset(rtfCtrlWordData.param);
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fnil")) {
            this.setFontFamily("roman");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("froman")) {
            this.setFontFamily("roman");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fswiss")) {
            this.setFontFamily("swiss");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fmodern")) {
            this.setFontFamily("modern");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fscript")) {
            this.setFontFamily("script");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fdecor")) {
            this.setFontFamily("decor");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("ftech")) {
            this.setFontFamily("tech");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fbidi")) {
            this.setFontFamily("bidi");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fprq")) {
            this.setPitch(rtfCtrlWordData.param);
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fbias")) {
            this.setBias(rtfCtrlWordData.param);
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("flomajor")) {
            this.setThemeFont("flomajor");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fhimajor")) {
            this.setThemeFont("fhimajor");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fdbmajor")) {
            this.setThemeFont("fdbmajor");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fbimajor")) {
            this.setThemeFont("fbimajor");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("flominor")) {
            this.setThemeFont("flominor");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fhiminor")) {
            this.setThemeFont("fhiminor");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fdbminor")) {
            this.setThemeFont("fdbminor");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fbiminor")) {
            this.setThemeFont("fbiminor");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("panose")) {
            this.state = 3;
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fname")) {
            this.state = 2;
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("falt")) {
            this.state = 1;
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fontemb")) {
            this.state = 4;
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("ftnil")) {
            this.setTrueType("ftnil");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fttruetype")) {
            this.setTrueType("fttruetype");
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("fontemb")) {
            this.state = 5;
            bl = true;
        }
        if (rtfCtrlWordData.ctrlWord.equals("cpg")) {
            this.setCodePage(rtfCtrlWordData.param);
            bl = true;
        }
        this.lastCtrlWord = rtfCtrlWordData;
        return bl;
    }

    public void setCodePage(String string) {
        this.cpg = string;
    }

    public void setTrueType(String string) {
        this.trueType = string;
    }

    public void setPitch(String string) {
        this.fprq = Integer.parseInt(string);
    }

    public void setBias(String string) {
        this.fbias = Integer.parseInt(string);
    }

    public void setThemeFont(String string) {
        this.themeFont = string;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public void setFontFamily(String string) {
        this.fontFamily = string;
    }

    public void setFontNumber(String string) {
        this.fontNr = string;
    }

    public void setFontAlternate(String string) {
        this.falt = string;
    }

    public void setCharset(String string) {
        if (string.length() == 0) {
            string = CHARSET_DEFAULT;
        }
        this.charset = string;
    }

    public void setToDefaults() {
        this.themeFont = "";
        this.fontNr = "";
        this.fontName = "";
        this.fontFamily = "";
        this.charset = "";
        this.fprq = 0;
        this.panose = "";
        this.nontaggedname = "";
        this.falt = "";
        this.fontemb = "";
        this.fontType = "";
        this.fontFile = "";
        this.fontFileCpg = "";
        this.fbias = 0;
        this.cpg = "";
        this.trueType = "";
        this.state = 0;
    }

    private void processFont() {
        this.fontName = this.fontName.trim();
        if (this.fontName.length() == 0) {
            return;
        }
        if (this.fontNr.length() == 0) {
            return;
        }
        if (this.fontName.length() > 0 && this.fontName.indexOf(59) >= 0) {
            this.fontName = this.fontName.substring(0, this.fontName.indexOf(59));
        }
        if (this.rtfParser.isImport() && !this.importHeader.importFont(this.fontNr, this.fontName, Integer.parseInt("".equals(this.charset) ? CHARSET_DEFAULT : this.charset)) && this.falt.length() > 0) {
            this.importHeader.importFont(this.fontNr, this.falt, Integer.parseInt("".equals(this.charset) ? CHARSET_DEFAULT : this.charset));
        }
        if (this.rtfParser.isConvert()) {
            String string = this.fontName;
            Font font = this.createfont(string);
            if (font.getBaseFont() == null && this.falt.length() > 0) {
                font = this.createfont(this.falt);
            }
            if (font.getBaseFont() == null) {
                font = "Courier".indexOf(string) > -1 ? FontFactory.getFont("Courier") : ("Helvetica".indexOf(string) > -1 ? FontFactory.getFont("Helvetica") : ("Times".indexOf(string) > -1 ? FontFactory.getFont("Times") : ("Symbol".indexOf(string) > -1 ? FontFactory.getFont("Symbol") : ("ZapfDingbats".indexOf(string) > -1 ? FontFactory.getFont("ZapfDingbats") : FontFactory.getFont("Helvetica")))));
            }
            this.fontMap.put(this.fontNr, font);
        }
        this.setToDefaults();
    }

    private Font createfont(String string) {
        Font font = null;
        int n = -1;
        while ((font = FontFactory.getFont(string)).getBaseFont() == null) {
            n = string.lastIndexOf(32);
            if (n > 0) {
                string = string.substring(0, n);
            }
            if (n > 0) continue;
        }
        return font;
    }

    public Font getFont(String string) {
        return (Font)this.fontMap.get(string);
    }

    private void importSystemFonts() {
        Properties properties = null;
        try {
            properties = this.getEnvironmentVariables();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string = properties.getProperty("SystemRoot");
        Runtime runtime = Runtime.getRuntime();
        String string2 = System.getProperty("file.separator");
        int n = FontFactory.registerDirectory(string + string2 + "fonts");
    }

    private Properties getEnvironmentVariables() throws Throwable {
        Properties properties = new Properties();
        String string = System.getProperty("os.name").toLowerCase();
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        process = string.indexOf("windows 95") > -1 || string.indexOf("windows 98") > -1 || string.indexOf("me") > -1 ? runtime.exec("command.com /c set") : (string.indexOf("nt") > -1 || string.indexOf("windows 2000") > -1 || string.indexOf("windows xp") > -1 || string.indexOf("windows 2003") > -1 || string.indexOf("windows vista") > -1 ? runtime.exec("cmd.exe /c set") : runtime.exec("env"));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String string2 = "";
        int n = -1;
        while ((string2 = bufferedReader.readLine()) != null) {
            n = string2.indexOf(61);
            properties.setProperty(string2.substring(0, n), string2.substring(n + 1));
        }
        return properties;
    }
}

